/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.sampling.ReservoirSize;
import org.apache.datasketches.sampling.SamplingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReservoirSizeTest {
    @Test
    public void checkComputeSize() {
        short enc = ReservoirSize.computeSize((int)1);
        Assert.assertEquals((short)enc, (short)0);
        enc = ReservoirSize.computeSize((int)128);
        Assert.assertEquals((short)enc, (short)14336);
        enc = ReservoirSize.computeSize((int)200);
        Assert.assertEquals((short)enc, (short)15488);
        enc = ReservoirSize.computeSize((int)4097);
        Assert.assertEquals((short)enc, (short)24577);
        enc = ReservoirSize.computeSize((int)5000);
        Assert.assertEquals((short)enc, (short)25029);
        enc = ReservoirSize.computeSize((int)25000);
        Assert.assertEquals((short)enc, (short)29750);
        enc = ReservoirSize.computeSize((int)Short.MAX_VALUE);
        Assert.assertEquals((short)enc, (short)30720);
        enc = ReservoirSize.computeSize((int)95342);
        Assert.assertEquals((short)enc, (short)-31836);
        try {
            ReservoirSize.computeSize((int)-1);
            Assert.fail();
        }
        catch (SketchesArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Can only encode strictly positive sketch sizes less than"));
        }
    }

    @Test
    public void checkDecodeValue() {
        int dec = ReservoirSize.decodeValue((short)0);
        Assert.assertEquals((int)dec, (int)1);
        dec = ReservoirSize.decodeValue((short)14336);
        Assert.assertEquals((int)dec, (int)128);
        dec = ReservoirSize.decodeValue((short)15488);
        Assert.assertEquals((int)dec, (int)200);
        dec = ReservoirSize.decodeValue((short)24577);
        Assert.assertEquals((int)dec, (int)4098);
        dec = ReservoirSize.decodeValue((short)25028);
        Assert.assertEquals((int)dec, (int)5000);
        dec = ReservoirSize.decodeValue((short)29749);
        Assert.assertEquals((int)dec, (int)25000);
        dec = ReservoirSize.decodeValue((short)-31836);
        Assert.assertEquals((int)dec, (int)95360);
        try {
            ReservoirSize.decodeValue((short)-1);
            Assert.fail();
        }
        catch (SketchesArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Maximum valid encoded value is "));
        }
    }

    @Test
    public void checkRelativeError() {
        double eps = 4.8828125E-4;
        int maxValue = 0x7FF7FFFF;
        int numIters = 100;
        for (int i = 0; i < 100; ++i) {
            int input = SamplingUtil.rand().nextInt(0x7FF7FFFF) + 1;
            int result = ReservoirSize.decodeValue((short)ReservoirSize.computeSize((int)input));
            Assert.assertTrue((result >= input ? 1 : 0) != 0, (String)("encoded/decoded result < input: " + result + " vs " + input + " (iter " + i + ")"));
            double relativeError = ((double)result - (double)input) / (double)input;
            Assert.assertTrue((relativeError <= 4.8828125E-4 ? 1 : 0) != 0, (String)("Error exceeds tolerance. Expected relative error <= 4.8828125E-4; found " + relativeError));
        }
    }
}

