/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.req.FloatBuffer;
import org.apache.datasketches.req.ReqCompactor;
import org.apache.datasketches.req.ReqSerDe;
import org.apache.datasketches.req.ReqSketch;
import org.apache.datasketches.req.ReqSketchTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReqCompactorTest {
    final ReqSketchTest reqSketchTest = new ReqSketchTest();

    @Test
    public void checkNearestEven() {
        Assert.assertEquals((int)ReqCompactor.nearestEven((float)-0.9f), (int)0);
    }

    @Test
    public void checkGetters() {
        boolean up = true;
        boolean hra = true;
        boolean ltEq = true;
        ReqSketch sk = this.reqSketchTest.loadSketch(20, 1, 120, true, true, true, 0);
        ReqCompactor c = (ReqCompactor)sk.getCompactors().get(0);
        c.getCoin();
        long state = c.getState();
        Assert.assertEquals((long)state, (long)1L);
        Assert.assertEquals((int)c.getNumSections(), (int)3);
        Assert.assertEquals((int)c.getSectionSize(), (int)20);
    }

    @Test
    public void checkSerDe() {
        ReqCompactorTest.checkSerDeImpl(12, false);
        ReqCompactorTest.checkSerDeImpl(12, true);
    }

    private static void checkSerDeImpl(int k, boolean hra) {
        ReqCompactor c1 = new ReqCompactor(0, hra, k, null);
        int nomCap = 6 * k;
        int cap = 2 * nomCap;
        int delta = nomCap;
        FloatBuffer buf = c1.getBuffer();
        for (int i = 1; i <= nomCap; ++i) {
            buf.append((float)i);
        }
        float minV = 1.0f;
        float maxV = nomCap;
        float sectionSizeFlt = c1.getSectionSizeFlt();
        int sectionSize = c1.getSectionSize();
        int numSections = c1.getNumSections();
        long state = c1.getState();
        byte lgWeight = c1.getLgWeight();
        boolean c1hra = c1.isHighRankAccuracy();
        boolean sorted = buf.isSorted();
        byte[] c1ser = c1.toByteArray();
        Buffer buff = Memory.wrap((byte[])c1ser).asBuffer();
        ReqSerDe.Compactor compactor = ReqSerDe.extractCompactor((Buffer)buff, (boolean)sorted, (boolean)c1hra);
        ReqCompactor c2 = compactor.reqCompactor;
        Assert.assertEquals((float)compactor.minVal, (float)1.0f);
        Assert.assertEquals((float)compactor.maxVal, (float)maxV);
        Assert.assertEquals((int)compactor.count, (int)nomCap);
        Assert.assertEquals((float)c2.getSectionSizeFlt(), (float)sectionSizeFlt);
        Assert.assertEquals((int)c2.getSectionSize(), (int)sectionSize);
        Assert.assertEquals((int)c2.getNumSections(), (int)numSections);
        Assert.assertEquals((long)c2.getState(), (long)state);
        Assert.assertEquals((int)c2.getLgWeight(), (int)lgWeight);
        Assert.assertEquals((boolean)c2.isHighRankAccuracy(), (boolean)c1hra);
        FloatBuffer buf2 = c2.getBuffer();
        Assert.assertEquals((int)buf2.getCapacity(), (int)cap);
        Assert.assertEquals((int)buf2.getDelta(), (int)delta);
        Assert.assertTrue((boolean)buf.isEqualTo(buf2));
    }
}

