/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.AbstractCoupons;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CouponListTest {
    @Test
    public void checkIterator() {
        CouponListTest.checkIterator(false, 4, 7);
        CouponListTest.checkIterator(true, 4, 7);
    }

    private static void checkIterator(boolean direct, int lgK, int n) {
        TgtHllType tgtHllType = TgtHllType.HLL_4;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)tgtHllType);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = direct ? new HllSketch(lgK, tgtHllType, wmem) : new HllSketch(lgK);
        for (int i = 0; i < n; ++i) {
            sk.update((long)i);
        }
        String store = direct ? "Memory" : "Heap";
        CouponListTest.println("CurMode: " + sk.getCurMode().toString() + "; Store: " + store);
        PairIterator itr = sk.iterator();
        CouponListTest.println(itr.getHeader());
        while (itr.nextAll()) {
            Assert.assertTrue((itr.getSlot() < 1 << lgK ? 1 : 0) != 0);
            CouponListTest.println(itr.getString());
        }
    }

    @Test
    public void checkDuplicatesAndMisc() {
        CouponListTest.checkDuplicatesAndMisc(false);
        CouponListTest.checkDuplicatesAndMisc(true);
    }

    private static void checkDuplicatesAndMisc(boolean direct) {
        int i;
        int lgConfigK = 8;
        TgtHllType tgtHllType = TgtHllType.HLL_4;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgConfigK, (TgtHllType)tgtHllType);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = direct ? new HllSketch(lgConfigK, tgtHllType, wmem) : new HllSketch(8);
        for (i = 1; i <= 7; ++i) {
            sk.update((long)i);
            sk.update((long)i);
        }
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.LIST);
        Assert.assertEquals((double)sk.getCompositeEstimate(), (double)7.0, (double)0.07);
        Assert.assertEquals((double)sk.getHipEstimate(), (double)7.0, (double)0.07);
        sk.hllSketchImpl.putEmptyFlag(false);
        sk.hllSketchImpl.putRebuildCurMinNumKxQFlag(false);
        if (direct) {
            Assert.assertNotNull((Object)sk.getWritableMemory());
            Assert.assertNotNull((Object)sk.getMemory());
        } else {
            Assert.assertNull((Object)sk.getWritableMemory());
            Assert.assertNull((Object)sk.getMemory());
        }
        sk.update(8L);
        sk.update(8L);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.SET);
        Assert.assertEquals((double)sk.getCompositeEstimate(), (double)8.0, (double)0.08);
        Assert.assertEquals((double)sk.getHipEstimate(), (double)8.0, (double)0.08);
        if (direct) {
            Assert.assertNotNull((Object)sk.getWritableMemory());
            Assert.assertNotNull((Object)sk.getMemory());
        } else {
            Assert.assertNull((Object)sk.getWritableMemory());
            Assert.assertNull((Object)sk.getMemory());
        }
        for (i = 9; i <= 25; ++i) {
            sk.update((long)i);
            sk.update((long)i);
        }
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.HLL);
        Assert.assertEquals((double)sk.getCompositeEstimate(), (double)25.0, (double)2.5);
        if (direct) {
            Assert.assertNotNull((Object)sk.getWritableMemory());
            Assert.assertNotNull((Object)sk.getMemory());
        } else {
            Assert.assertNull((Object)sk.getWritableMemory());
            Assert.assertNull((Object)sk.getMemory());
        }
        double re = sk.getRelErr(true, true, 4, 1);
        Assert.assertTrue((re < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void toByteArray_Heapify() {
        CouponListTest.toByteArrayHeapify(7);
        CouponListTest.toByteArrayHeapify(21);
    }

    private static void toByteArrayHeapify(int lgK) {
        HllSketch sk1 = new HllSketch(lgK);
        int u = lgK < 8 ? 7 : (1 << lgK - 3) / 4 * 3;
        for (int i = 0; i < u; ++i) {
            sk1.update((long)i);
        }
        double est1 = sk1.getEstimate();
        Assert.assertEquals((double)est1, (double)u, (double)((double)u * 1.0E-4));
        byte[] byteArray = sk1.toCompactByteArray();
        HllSketch sk2 = HllSketch.heapify((byte[])byteArray);
        double est2 = sk2.getEstimate();
        Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        byteArray = sk1.toUpdatableByteArray();
        sk2 = HllSketch.heapify((byte[])byteArray);
        est2 = sk2.getEstimate();
        Assert.assertEquals((double)est2, (double)est1, (double)0.0);
    }

    @Test
    public void checkGetMemory() {
        HllSketch sk1 = new HllSketch(4);
        AbstractCoupons absCoup = (AbstractCoupons)sk1.hllSketchImpl;
        Assert.assertNull((Object)absCoup.getMemory());
    }

    @Test
    public void printlnTest() {
        CouponListTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

