/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import java.util.Random;
import org.apache.datasketches.QuickSelect;
import org.apache.datasketches.SketchesArgumentException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QuickSelectTest {
    private static final String LS = System.getProperty("line.separator");
    private static final Random random = new Random();

    @Test
    public void checkQuickSelect0Based() {
        int len = 64;
        long[] arr = new long[64];
        for (int i = 0; i < 64; ++i) {
            arr[i] = i;
        }
        for (int pivot = 0; pivot < 64; ++pivot) {
            long trueVal = pivot;
            for (int i = 0; i < 1000; ++i) {
                QuickSelectTest.shuffle(arr);
                long retVal = QuickSelect.select((long[])arr, (int)0, (int)63, (int)pivot);
                Assert.assertEquals((long)retVal, (long)trueVal);
            }
        }
    }

    @Test
    public void checkQuickSelect1BasedExcludingZeros() {
        int len = 64;
        int nonZeros = 56;
        long[] arr = new long[64];
        for (int i = 0; i < 56; ++i) {
            arr[i] = i + 1;
        }
        int pivot = 32;
        long trueVal = arr[31];
        QuickSelectTest.shuffle(arr);
        long retVal = QuickSelect.selectExcludingZeros((long[])arr, (int)56, (int)32);
        Assert.assertEquals((long)retVal, (long)trueVal);
    }

    @Test
    public void checkQuickSelect1BasedExcludingZeros2() {
        int len = 64;
        int nonZeros = 16;
        long[] arr = new long[64];
        for (int i = 0; i < 16; ++i) {
            arr[i] = i + 1;
        }
        QuickSelectTest.shuffle(arr);
        int pivot = 32;
        long retVal = QuickSelect.selectExcludingZeros((long[])arr, (int)16, (int)32);
        Assert.assertEquals((long)retVal, (long)0L);
    }

    @Test
    public void checkQuickSelect1BasedIncludingZeros() {
        int len = 64;
        int zeros = 8;
        long[] arr = new long[64];
        for (int i = 8; i < 64; ++i) {
            arr[i] = i + 1;
        }
        int pivot = 32;
        long trueVal = arr[31];
        QuickSelectTest.shuffle(arr);
        long retVal = QuickSelect.selectIncludingZeros((long[])arr, (int)32);
        Assert.assertEquals((long)retVal, (long)trueVal);
    }

    @Test
    public void checkQuickSelectDbl0Based() {
        int len = 64;
        double[] arr = new double[64];
        for (int i = 0; i < 64; ++i) {
            arr[i] = i;
        }
        for (int pivot = 0; pivot < 64; ++pivot) {
            double trueVal = pivot;
            for (int i = 0; i < 1000; ++i) {
                QuickSelectTest.shuffle(arr);
                double retVal = QuickSelect.select((double[])arr, (int)0, (int)63, (int)pivot);
                Assert.assertEquals((double)retVal, (double)trueVal, (double)0.0);
            }
        }
    }

    @Test
    public void checkQuickSelectDbl1BasedExcludingZeros() {
        int len = 64;
        int nonZeros = 56;
        double[] arr = new double[64];
        for (int i = 0; i < 56; ++i) {
            arr[i] = i + 1;
        }
        int pivot = 32;
        double trueVal = arr[31];
        QuickSelectTest.shuffle(arr);
        double retVal = QuickSelect.selectExcludingZeros((double[])arr, (int)56, (int)32);
        Assert.assertEquals((double)retVal, (double)trueVal, (double)0.0);
    }

    @Test
    public void checkQuickSelectDbl1BasedExcludingZeros2() {
        int len = 64;
        int nonZeros = 16;
        double[] arr = new double[64];
        for (int i = 0; i < 16; ++i) {
            arr[i] = i + 1;
        }
        QuickSelectTest.shuffle(arr);
        int pivot = 32;
        double retVal = QuickSelect.selectExcludingZeros((double[])arr, (int)16, (int)32);
        Assert.assertEquals((double)retVal, (double)0.0, (double)0.0);
    }

    @Test
    public void checkQuickSelectDbl1BasedIncludingZeros() {
        int len = 64;
        int zeros = 8;
        double[] arr = new double[64];
        for (int i = 8; i < 64; ++i) {
            arr[i] = i + 1;
        }
        int pivot = 32;
        double trueVal = arr[31];
        QuickSelectTest.shuffle(arr);
        double retVal = QuickSelect.selectIncludingZeros((double[])arr, (int)32);
        Assert.assertEquals((double)retVal, (double)trueVal, (double)0.0);
    }

    public static void shuffle(long[] a) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            int r = i + QuickSelectTest.uniform(N - i);
            long temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(double[] a) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            int r = i + QuickSelectTest.uniform(N - i);
            double temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static int uniform(int n) {
        if (n <= 0) {
            throw new SketchesArgumentException("n must be positive");
        }
        return random.nextInt(n);
    }

    private static String printArr(long[] arr) {
        StringBuilder sb = new StringBuilder();
        int len = arr.length;
        sb.append(" Base0").append(" Base1").append(" Value").append(LS);
        for (int i = 0; i < len; ++i) {
            sb.append(String.format("%6d", i)).append(String.format("%6d", i + 1)).append(String.format("%6d", arr[i])).append(LS);
        }
        return sb.toString();
    }

    private static String printArr(double[] arr) {
        StringBuilder sb = new StringBuilder();
        int len = arr.length;
        sb.append(" Base0").append(" Base1").append("    Value").append(LS);
        for (int i = 0; i < len; ++i) {
            sb.append(String.format("%6d", i)).append(String.format("%6d", i + 1)).append(String.format("%9.3f", arr[i])).append(LS);
        }
        return sb.toString();
    }

    static void test1() {
        int len = 16;
        int nonZeros = 12;
        int zeros = 4;
        long[] arr = new long[16];
        for (int i = 0; i < 12; ++i) {
            arr[i] = i + 1;
        }
        QuickSelectTest.println("Generated Numbers:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        QuickSelectTest.shuffle(arr);
        QuickSelectTest.println("Randomized Ordering:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        int pivot = 8;
        QuickSelectTest.println("select(...):");
        QuickSelectTest.println("ArrSize : 16");
        QuickSelectTest.println("NonZeros: 12");
        QuickSelectTest.println("Zeros   : 4");
        QuickSelectTest.println("Choose pivot at 1/2 array size, pivot: 8");
        long ret = QuickSelect.select((long[])arr, (int)0, (int)15, (int)8);
        QuickSelectTest.println("Return value of 0-based pivot including zeros:");
        QuickSelectTest.println("select(arr, 0, 15, 8) => " + ret);
        QuickSelectTest.println("0-based index of pivot = pivot = 8");
        QuickSelectTest.println("Result Array:" + LS);
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
    }

    static void test2() {
        int len = 16;
        int nonZeros = 12;
        int zeros = 4;
        long[] arr = new long[16];
        for (int i = 0; i < 12; ++i) {
            arr[i] = i + 1;
        }
        QuickSelectTest.println("Generated Numbers:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        QuickSelectTest.shuffle(arr);
        QuickSelectTest.println("Randomized Ordering:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        int pivot = 8;
        QuickSelectTest.println("selectDiscountingZeros(...):");
        QuickSelectTest.println("ArrSize : 16");
        QuickSelectTest.println("NonZeros: 12");
        QuickSelectTest.println("Zeros   : 4");
        QuickSelectTest.println("Choose pivot at 1/2 array size, pivot= 8");
        long ret = QuickSelect.selectExcludingZeros((long[])arr, (int)12, (int)8);
        QuickSelectTest.println("Return value of 1-based pivot discounting zeros:");
        QuickSelectTest.println("selectDiscountingZeros(arr, 12, 8) => " + ret);
        QuickSelectTest.println("0-based index of pivot= pivot+zeros-1 = 11");
        QuickSelectTest.println("Result Array:" + LS);
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
    }

    static void test3() {
        int len = 16;
        int nonZeros = 12;
        int zeros = 4;
        long[] arr = new long[16];
        for (int i = 0; i < 12; ++i) {
            arr[i] = i + 1;
        }
        QuickSelectTest.println("Generated Numbers:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        QuickSelectTest.shuffle(arr);
        QuickSelectTest.println("Randomized Ordering:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        int pivot = 8;
        QuickSelectTest.println("selectIncludingZeros(...):");
        QuickSelectTest.println("ArrSize : 16");
        QuickSelectTest.println("NonZeros: 12");
        QuickSelectTest.println("Zeros   : 4");
        QuickSelectTest.println("Choose pivot at 1/2 array size, pivot= 8");
        long ret = QuickSelect.selectIncludingZeros((long[])arr, (int)8);
        QuickSelectTest.println("Return value of 1-based pivot including zeros:");
        QuickSelectTest.println("selectIncludingZeros(arr, 8) => " + ret);
        QuickSelectTest.println("0-based index of pivot= pivot-1 = 7");
        QuickSelectTest.println("Result Array:" + LS);
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
    }

    static void testDbl1() {
        int len = 16;
        int nonZeros = 12;
        int zeros = 4;
        double[] arr = new double[16];
        for (int i = 0; i < 12; ++i) {
            arr[i] = i + 1;
        }
        QuickSelectTest.println("Generated Numbers:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        QuickSelectTest.shuffle(arr);
        QuickSelectTest.println("Randomized Ordering:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        int pivot = 8;
        QuickSelectTest.println("select(...):");
        QuickSelectTest.println("ArrSize : 16");
        QuickSelectTest.println("NonZeros: 12");
        QuickSelectTest.println("Zeros   : 4");
        QuickSelectTest.println("Choose pivot at 1/2 array size, pivot: 8");
        double ret = QuickSelect.select((double[])arr, (int)0, (int)15, (int)8);
        QuickSelectTest.println("Return value of 0-based pivot including zeros:");
        QuickSelectTest.println("select(arr, 0, 15, 8) => " + ret);
        QuickSelectTest.println("0-based index of pivot = pivot = 8");
        QuickSelectTest.println("Result Array:" + LS);
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
    }

    static void testDbl2() {
        int len = 16;
        int nonZeros = 12;
        int zeros = 4;
        double[] arr = new double[16];
        for (int i = 0; i < 12; ++i) {
            arr[i] = i + 1;
        }
        QuickSelectTest.println("Generated Numbers:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        QuickSelectTest.shuffle(arr);
        QuickSelectTest.println("Randomized Ordering:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        int pivot = 8;
        QuickSelectTest.println("selectDiscountingZeros(...):");
        QuickSelectTest.println("ArrSize : 16");
        QuickSelectTest.println("NonZeros: 12");
        QuickSelectTest.println("Zeros   : 4");
        QuickSelectTest.println("Choose pivot at 1/2 array size, pivot= 8");
        double ret = QuickSelect.selectExcludingZeros((double[])arr, (int)12, (int)8);
        QuickSelectTest.println("Return value of 1-based pivot discounting zeros:");
        QuickSelectTest.println("selectDiscountingZeros(arr, 12, 8) => " + ret);
        QuickSelectTest.println("0-based index of pivot= pivot+zeros-1 = 11");
        QuickSelectTest.println("Result Array:" + LS);
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
    }

    static void testDbl3() {
        int len = 16;
        int nonZeros = 12;
        int zeros = 4;
        double[] arr = new double[16];
        for (int i = 0; i < 12; ++i) {
            arr[i] = i + 1;
        }
        QuickSelectTest.println("Generated Numbers:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        QuickSelectTest.shuffle(arr);
        QuickSelectTest.println("Randomized Ordering:");
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
        int pivot = 8;
        QuickSelectTest.println("selectIncludingZeros(...):");
        QuickSelectTest.println("ArrSize : 16");
        QuickSelectTest.println("NonZeros: 12");
        QuickSelectTest.println("Zeros   : 4");
        QuickSelectTest.println("Choose pivot at 1/2 array size, pivot= 8");
        double ret = QuickSelect.selectIncludingZeros((double[])arr, (int)8);
        QuickSelectTest.println("Return value of 1-based pivot including zeros:");
        QuickSelectTest.println("selectIncludingZeros(arr, 8) => " + ret);
        QuickSelectTest.println("0-based index of pivot= pivot-1 = 7");
        QuickSelectTest.println("Result Array:" + LS);
        QuickSelectTest.println(QuickSelectTest.printArr(arr));
    }

    @Test
    public void printlnTest() {
        QuickSelectTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    static void println(double d) {
    }
}

