/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.strings;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.AnotB;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.strings.ArrayOfStringsSketch;
import org.apache.datasketches.tuple.strings.ArrayOfStringsSummary;
import org.apache.datasketches.tuple.strings.ArrayOfStringsSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfStringsSketchTest {
    private static final String LS = System.getProperty("line.separator");

    @Test
    public void checkSketch() {
        ArrayOfStringsSketch sketch1 = new ArrayOfStringsSketch();
        String[][] strArrArr = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        int len = strArrArr.length;
        for (int i = 0; i < len; ++i) {
            sketch1.update(strArrArr[i], strArrArr[i]);
        }
        sketch1.update(strArrArr[0], strArrArr[0]);
        byte[] array = sketch1.toByteArray();
        WritableMemory wmem = WritableMemory.wrap((byte[])array);
        ArrayOfStringsSketch sketch2 = new ArrayOfStringsSketch((Memory)wmem);
        ArrayOfStringsSketchTest.checkSummaries(sketch2, sketch2);
        String[] strArr3 = new String[]{"g", "h"};
        sketch2.update(strArr3, strArr3);
        Union union = new Union((SummarySetOperations)new ArrayOfStringsSummarySetOperations());
        union.update((Sketch)sketch1);
        union.update((Sketch)sketch2);
        CompactSketch csk = union.getResult();
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)4);
        Intersection inter = new Intersection((SummarySetOperations)new ArrayOfStringsSummarySetOperations());
        inter.update((Sketch)sketch1);
        inter.update((Sketch)sketch2);
        csk = inter.getResult();
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)3);
        AnotB aNotB = new AnotB();
        aNotB.update((Sketch)sketch2, (Sketch)sketch1);
        csk = aNotB.getResult();
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)1);
    }

    private static void checkSummaries(ArrayOfStringsSketch sk1, ArrayOfStringsSketch sk2) {
        SketchIterator it1 = sk1.iterator();
        SketchIterator it2 = sk2.iterator();
        while (it1.next() && it2.next()) {
            ArrayOfStringsSummary sum1 = (ArrayOfStringsSummary)it1.getSummary();
            ArrayOfStringsSummary sum2 = (ArrayOfStringsSummary)it2.getSummary();
            Assert.assertTrue((boolean)sum1.equals((Object)sum2));
        }
    }

    static void printSummaries(SketchIterator<ArrayOfStringsSummary> it) {
        while (it.next()) {
            String[] strArr;
            for (String s : strArr = ((ArrayOfStringsSummary)it.getSummary()).getValue()) {
                ArrayOfStringsSketchTest.print(s + ", ");
            }
            ArrayOfStringsSketchTest.println("");
        }
    }

    @Test
    public void printlnTest() {
        ArrayOfStringsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        ArrayOfStringsSketchTest.print(s + LS);
    }

    static void print(String s) {
    }
}

