/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.adouble;

import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.AnotB;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSketch;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UpdatableSketchWithDoubleSummaryTest {
    private final DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;

    @Test
    public void isEmpty() {
        int lgK = 12;
        DoubleSketch sketch = new DoubleSketch(lgK, this.mode);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        Assert.assertNotNull((Object)sketch.toString());
        SketchIterator it = sketch.iterator();
        Assert.assertNotNull((Object)it);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void checkLowK() {
        UpdatableSketchBuilder bldr = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum));
        bldr.setNominalEntries(16);
        UpdatableSketch sk = bldr.build();
        Assert.assertEquals((int)sk.getLgK(), (int)4);
    }

    @Test
    public void serDeTest() {
        int lgK = 12;
        int K = 1 << lgK;
        DoubleSketch a1Sk = new DoubleSketch(lgK, DoubleSummary.Mode.AlwaysOne);
        int m = 2 * K;
        for (int key = 0; key < m; ++key) {
            a1Sk.update((long)key, Double.valueOf(1.0));
        }
        double est1 = a1Sk.getEstimate();
        Memory mem = Memory.wrap((byte[])a1Sk.toByteArray());
        DoubleSketch a1Sk2 = new DoubleSketch(mem, DoubleSummary.Mode.AlwaysOne);
        double est2 = a1Sk2.getEstimate();
        Assert.assertEquals((Object)est1, (Object)est2);
    }

    @Test
    public void checkStringKey() {
        int lgK = 12;
        int K = 1 << lgK;
        DoubleSketch a1Sk1 = new DoubleSketch(lgK, DoubleSummary.Mode.AlwaysOne);
        int m = K / 2;
        for (int key = 0; key < m; ++key) {
            a1Sk1.update(Integer.toHexString(key), Double.valueOf(1.0));
        }
        Assert.assertEquals((Object)a1Sk1.getEstimate(), (Object)((double)K / 2.0));
    }

    @Test
    public void isEmptyWithSampling() {
        float samplingProbability = 0.1f;
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(samplingProbability).build();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)Float.valueOf((float)sketch.getTheta()), (Object)Float.valueOf(samplingProbability));
        Assert.assertEquals((Object)sketch.getTheta(), (Object)samplingProbability);
    }

    @Test
    public void sampling() {
        float samplingProbability = 0.001f;
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(samplingProbability).build();
        sketch.update("a", (Object)1.0);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertTrue((sketch.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0, (double)1.0E-7);
        Assert.assertEquals((Object)Float.valueOf((float)sketch.getTheta()), (Object)Float.valueOf(samplingProbability));
        Assert.assertEquals((Object)sketch.getTheta(), (Object)samplingProbability);
    }

    @Test
    public void exactMode() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        for (int i = 1; i <= 4096; ++i) {
            sketch.update((long)i, (Object)1.0);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)4096.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)4096.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)4096.0);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        int count = 0;
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)4096);
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
    }

    @Test
    public void estimationMode() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        for (int i = 1; i <= 8192; ++i) {
            sketch.update((long)i, (Object)1.0);
        }
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)8192.0, (double)81.92);
        Assert.assertTrue((sketch.getEstimate() >= sketch.getLowerBound(1) ? 1 : 0) != 0);
        Assert.assertTrue((sketch.getEstimate() < sketch.getUpperBound(1) ? 1 : 0) != 0);
        int count = 0;
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.0);
            ++count;
        }
        Assert.assertTrue((count >= 4096 ? 1 : 0) != 0);
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
    }

    @Test
    public void estimationModeWithSamplingNoResizing() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.5f).setResizeFactor(ResizeFactor.X1).build();
        for (int i = 0; i < 16384; ++i) {
            sketch.update((long)i, (Object)1.0);
        }
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)16384.0, (double)163.84);
        Assert.assertTrue((sketch.getEstimate() >= sketch.getLowerBound(1) ? 1 : 0) != 0);
        Assert.assertTrue((sketch.getEstimate() < sketch.getUpperBound(1) ? 1 : 0) != 0);
    }

    @Test
    public void updatesOfAllKeyTypes() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch.update(1L, (Object)1.0);
        sketch.update(2.0, (Object)1.0);
        byte[] bytes = new byte[]{3};
        sketch.update(bytes, (Object)1.0);
        int[] ints = new int[]{4};
        sketch.update(ints, (Object)1.0);
        long[] longs = new long[]{5L};
        sketch.update(longs, (Object)1.0);
        sketch.update("a", (Object)1.0);
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)6.0);
    }

    @Test
    public void doubleSummaryDefaultSumMode() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch.update(1L, (Object)1.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        SketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.7);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.7);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.8);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)2.5);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void doubleSummaryMinMode() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Min)).build();
        sketch.update(1L, (Object)1.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        SketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.7);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)0.7);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.8);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)0.7);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void doubleSummaryMaxMode() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Max)).build();
        sketch.update(1L, (Object)1.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        SketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.7);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)2.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)2.0);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void serializeDeserializeExact() throws Exception {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        UpdatableSketch sketch2 = Sketches.heapifyUpdatableSketch((Memory)Memory.wrap((byte[])sketch1.toByteArray()), (SummaryDeserializer)new DoubleSummaryDeserializer(), (SummaryFactory)new DoubleSummaryFactory(this.mode));
        Assert.assertEquals((Object)sketch2.getEstimate(), (Object)1.0);
        SketchIterator it = sketch2.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch2.update(1L, (Object)1.0);
        Assert.assertEquals((Object)sketch2.getEstimate(), (Object)1.0);
        sketch2.update(2L, (Object)1.0);
        Assert.assertEquals((Object)sketch2.getEstimate(), (Object)2.0);
    }

    @Test
    public void serializeDeserializeEstimationNoResizing() throws Exception {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setResizeFactor(ResizeFactor.X1).build();
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 8192; ++i) {
                sketch1.update((long)i, (Object)1.0);
            }
        }
        sketch1.trim();
        byte[] bytes = sketch1.toByteArray();
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertTrue((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)8192.0, (double)8110.08);
        Assert.assertEquals((Object)sketch1.getTheta(), (Object)sketch2.getTheta());
        SketchIterator it = sketch2.iterator();
        int count = 0;
        while (it.next()) {
            Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)10.0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)4096);
    }

    @Test
    public void serializeDeserializeSampling() throws Exception {
        int sketchSize;
        int numberOfUniques = sketchSize = 16384;
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setNominalEntries(sketchSize).setSamplingProbability(0.5f).build();
        for (int i = 0; i < numberOfUniques; ++i) {
            sketch1.update((long)i, (Object)1.0);
        }
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])sketch1.toByteArray()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertTrue((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)(sketch2.getEstimate() / (double)numberOfUniques), (double)1.0, (double)0.01);
        Assert.assertEquals((double)((double)sketch2.getRetainedEntries() / (double)numberOfUniques), (double)0.5, (double)0.01);
        Assert.assertEquals((Object)sketch1.getTheta(), (Object)sketch2.getTheta());
    }

    @Test
    public void unionEmptySampling() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.01f).build();
        sketch.update(1L, (Object)1.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
        Union union = new Union((SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        union.update((Sketch)sketch);
        CompactSketch result = union.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)result.isEstimationMode());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
    }

    @Test
    public void unionExactMode() {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        sketch1.update(1L, (Object)1.0);
        sketch1.update(1L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch2.update(2L, (Object)1.0);
        sketch2.update(2L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        Union union = new Union((SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        union.update((Sketch)sketch1);
        union.update((Sketch)sketch2);
        CompactSketch result = union.getResult();
        Assert.assertEquals((Object)result.getEstimate(), (Object)3.0);
        SketchIterator it = result.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)3.0);
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)3.0);
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)3.0);
        Assert.assertFalse((boolean)it.next());
        union.reset();
        result = union.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getTheta(), (Object)1.0);
    }

    @Test
    public void unionEstimationMode() {
        int key = 0;
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        key -= 4096;
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        Union union = new Union(4096, (SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        union.update((Sketch)sketch1);
        union.update((Sketch)sketch2);
        CompactSketch result = union.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
    }

    @Test
    public void unionMixedMode() {
        int key = 0;
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        key -= 500;
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.2f).build();
        for (int i = 0; i < 20000; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        Union union = new Union(4096, (SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        union.update((Sketch)sketch1);
        union.update((Sketch)sketch2);
        CompactSketch result = union.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)20500.0, (double)205.0);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
    }

    @Test
    public void intersectionEmpty() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        intersection.update((Sketch)sketch);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
    }

    @Test
    public void intersectionNotEmptyNoEntries() {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.01f).build();
        sketch1.update("a", (Object)1.0);
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        intersection.update((Sketch)sketch1);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0, (double)1.0E-4);
        Assert.assertTrue((result.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void intersectionExactWithNull() {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        sketch1.update(3L, (Object)1.0);
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        intersection.update((Sketch)sketch1);
        intersection.update(null);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
    }

    @Test
    public void intersectionExactWithEmpty() {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        sketch1.update(3L, (Object)1.0);
        Sketch sketch2 = Sketches.createEmptySketch();
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        intersection.update((Sketch)sketch1);
        intersection.update(sketch2);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
    }

    @Test
    public void intersectionExactMode() {
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        sketch1.update(1L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        sketch1.update(2L, (Object)1.0);
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch2.update(2L, (Object)1.0);
        sketch2.update(2L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        sketch2.update(3L, (Object)1.0);
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        intersection.update((Sketch)sketch1);
        intersection.update((Sketch)sketch2);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)1.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)1.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)1.0);
        SketchIterator it = result.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)4.0);
        Assert.assertFalse((boolean)it.next());
        intersection.reset();
        intersection.update(null);
        result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getTheta(), (Object)1.0);
    }

    @Test
    public void intersectionDisjointEstimationMode() {
        int key = 0;
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        intersection.update((Sketch)sketch1);
        intersection.update((Sketch)sketch2);
        CompactSketch result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertTrue((result.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
        intersection.update((Sketch)sketch1);
        result = intersection.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertTrue((result.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void intersectionEstimationMode() {
        int key = 0;
        UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, (Object)1.0);
        }
        key -= 4096;
        UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, (Object)1.0);
        }
        Intersection intersection = new Intersection((SummarySetOperations)new DoubleSummarySetOperations(this.mode));
        intersection.update((Sketch)sketch1);
        intersection.update((Sketch)sketch2);
        CompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        SketchIterator it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)2.0);
        }
    }

    @Test
    public void aNotBEmpty() {
        AnotB aNotB = new AnotB();
        CompactSketch result = aNotB.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        aNotB.update(null, null);
        result = aNotB.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        aNotB.update((Sketch)sketch, (Sketch)sketch);
        result = aNotB.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
    }

    @Test
    public void aNotBEmptyA() {
        UpdatableSketch sketchA = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        UpdatableSketch sketchB = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketchB.update(1L, (Object)1.0);
        sketchB.update(2L, (Object)1.0);
        AnotB aNotB = new AnotB();
        aNotB.update((Sketch)sketchA, (Sketch)sketchB);
        CompactSketch result = aNotB.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
    }

    @Test
    public void aNotBEmptyB() {
        UpdatableSketch sketchA = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketchA.update(1L, (Object)1.0);
        sketchA.update(2L, (Object)1.0);
        UpdatableSketch sketchB = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        AnotB aNotB = new AnotB();
        aNotB.update((Sketch)sketchA, (Sketch)sketchB);
        CompactSketch result = aNotB.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)2);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)2.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)2.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)2.0);
        aNotB.update((Sketch)sketchA.compact(), (Sketch)sketchB.compact());
        result = aNotB.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)2);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)2.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)2.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)2.0);
    }

    @Test
    public void aNotBExactMode() {
        UpdatableSketch sketchA = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketchA.update(1L, (Object)1.0);
        sketchA.update(1L, (Object)1.0);
        sketchA.update(2L, (Object)1.0);
        sketchA.update(2L, (Object)1.0);
        UpdatableSketch sketchB = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketchB.update(2L, (Object)1.0);
        sketchB.update(2L, (Object)1.0);
        sketchB.update(3L, (Object)1.0);
        sketchB.update(3L, (Object)1.0);
        AnotB aNotB = new AnotB();
        aNotB.update((Sketch)sketchA, (Sketch)sketchB);
        CompactSketch result = aNotB.getResult();
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)1.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)1.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)1.0);
        SketchIterator it = result.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)2.0);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void aNotBEstimationMode() {
        int key = 0;
        UpdatableSketch sketchA = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketchA.update((long)key++, (Object)1.0);
        }
        key -= 4096;
        UpdatableSketch sketchB = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            sketchB.update((long)key++, (Object)1.0);
        }
        AnotB aNotB = new AnotB();
        aNotB.update((Sketch)sketchA, (Sketch)sketchB);
        CompactSketch result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        SketchIterator it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.0);
        }
        aNotB.update((Sketch)sketchA.compact(), (Sketch)sketchB.compact());
        result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((Object)((DoubleSummary)it.getSummary()).getValue(), (Object)1.0);
        }
    }

    @Test
    public void aNotBEstimationModeLargeB() {
        int key = 0;
        UpdatableSketch sketchA = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 10000; ++i) {
            sketchA.update((long)key++, (Object)1.0);
        }
        key -= 2000;
        UpdatableSketch sketchB = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 100000; ++i) {
            sketchB.update((long)key++, (Object)1.0);
        }
        int expected = 8000;
        AnotB aNotB = new AnotB();
        aNotB.update((Sketch)sketchA, (Sketch)sketchB);
        CompactSketch result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)8000.0, (double)800.0);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        aNotB.update((Sketch)sketchA.compact(), (Sketch)sketchB.compact());
        result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)8000.0, (double)800.0);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void invalidSamplingProbability() {
        new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(2.0f).build();
    }
}

