/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SerializerDeserializerTest {
    @Test
    public void validSketchType() {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)SerializerDeserializer.SketchType.CompactSketch.ordinal();
        Assert.assertEquals((Object)SerializerDeserializer.getSketchType((Memory)Memory.wrap((byte[])bytes)), (Object)SerializerDeserializer.SketchType.CompactSketch);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void invalidSketchType() {
        byte[] bytes = new byte[4];
        bytes[3] = 33;
        SerializerDeserializer.getSketchType((Memory)Memory.wrap((byte[])bytes));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void validateFamilyNotTuple() {
        SerializerDeserializer.validateFamily((byte)1, (byte)0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void validateFamilyWrongPreambleLength() {
        SerializerDeserializer.validateFamily((byte)((byte)Family.TUPLE.getID()), (byte)0);
    }
}

