/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.util.Arrays;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.ArrayOfDoublesUnion;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesUnionTest {
    @Test
    public void heapExactMode() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union.update((ArrayOfDoublesSketch)sketch1);
        union.update((ArrayOfDoublesSketch)sketch2);
        int maxBytes = ArrayOfDoublesUnion.getMaxBytes((int)4096, (int)1);
        Assert.assertEquals((int)maxBytes, (int)131120);
        ArrayOfDoublesCompactSketch result = union.getResult();
        Assert.assertEquals((Object)result.getEstimate(), (Object)3.0);
        double[][] values = result.getValues();
        Assert.assertEquals((Object)values[0][0], (Object)3.0);
        Assert.assertEquals((Object)values[1][0], (Object)3.0);
        Assert.assertEquals((Object)values[2][0], (Object)3.0);
        WritableMemory wmem = WritableMemory.wrap((byte[])union.toByteArray());
        ArrayOfDoublesUnion wrappedUnion = ArrayOfDoublesSketches.wrapUnion((WritableMemory)wmem);
        result = wrappedUnion.getResult();
        Assert.assertEquals((Object)result.getEstimate(), (Object)3.0);
        values = result.getValues();
        Assert.assertEquals((Object)values[0][0], (Object)3.0);
        Assert.assertEquals((Object)values[1][0], (Object)3.0);
        Assert.assertEquals((Object)values[2][0], (Object)3.0);
        union.reset();
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getTheta(), (Object)1.0);
    }

    @Test
    public void heapEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union.update((ArrayOfDoublesSketch)sketch1);
        union.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        union.reset();
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getTheta(), (Object)1.0);
    }

    @Test
    public void heapEstimationModeFullOverlapTwoValuesAndDownsizing() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0, 2.0});
        }
        key = 0;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0, 2.0});
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setNumberOfValues(2).setNominalEntries(1024).buildUnion();
        union.update((ArrayOfDoublesSketch)sketch1);
        union.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)8192.0, (double)81.92);
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1024);
        ArrayOfDoublesSketchIterator it = result.iterator();
        double[] expected = new double[]{2.0, 4.0};
        while (it.next()) {
            Assert.assertEquals((double[])it.getValues(), (double[])expected, (String)(Arrays.toString(it.getValues()) + " != " + Arrays.toString(expected)));
        }
    }

    @Test
    public void heapMixedMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 500;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setSamplingProbability(0.2f).build();
        for (int i = 0; i < 20000; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union.update((ArrayOfDoublesSketch)sketch1);
        union.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)result.isEstimationMode());
        Assert.assertEquals((double)result.getEstimate(), (double)20500.0, (double)205.0);
    }

    @Test
    public void heapSerializeDeserialize() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union1.update((ArrayOfDoublesSketch)sketch1);
        union1.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesUnion.heapify((Memory)Memory.wrap((byte[])union1.toByteArray()));
        ArrayOfDoublesCompactSketch result = union2.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        union2.reset();
        result = union2.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getTheta(), (Object)1.0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)values[i][0], (Object)2.0);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void noSupportHeapifyV0_9_1() throws Exception {
        byte[] bytes = Util.getResourceBytes((String)"ArrayOfDoublesUnion_v0.9.1.bin");
        ArrayOfDoublesUnion.heapify((Memory)Memory.wrap((byte[])bytes));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void noSupportWrapV0_9_1() throws Exception {
        byte[] bytes = Util.getResourceBytes((String)"ArrayOfDoublesUnion_v0.9.1.bin");
        ArrayOfDoublesUnion.wrap((WritableMemory)WritableMemory.wrap((byte[])bytes));
    }

    @Test
    public void heapSerializeDeserializeWithSeed() {
        long seed = 1L;
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().setSeed(seed).buildUnion();
        union1.update((ArrayOfDoublesSketch)sketch1);
        union1.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesUnion.heapify((Memory)Memory.wrap((byte[])union1.toByteArray()), (long)seed);
        ArrayOfDoublesCompactSketch result = union2.getResult();
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
    }

    @Test
    public void directSerializeDeserialize() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().buildUnion(WritableMemory.wrap((byte[])new byte[1000000]));
        union1.update((ArrayOfDoublesSketch)sketch1);
        union1.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesUnion.wrap((WritableMemory)WritableMemory.wrap((byte[])union1.toByteArray()));
        ArrayOfDoublesCompactSketch result = union2.getResult(WritableMemory.wrap((byte[])new byte[1000000]));
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        union2.reset();
        result = union2.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getTheta(), (Object)1.0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)values[i][0], (Object)2.0);
        }
    }

    @Test
    public void directSerializeDeserializeWithSeed() {
        long seed = 1L;
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().setSeed(seed).buildUnion(WritableMemory.wrap((byte[])new byte[1000000]));
        union1.update((ArrayOfDoublesSketch)sketch1);
        union1.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesUnion.wrap((WritableMemory)WritableMemory.wrap((byte[])union1.toByteArray()), (long)seed);
        ArrayOfDoublesCompactSketch result = union2.getResult(WritableMemory.wrap((byte[])new byte[1000000]));
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
    }

    @Test
    public void directExactMode() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion(WritableMemory.wrap((byte[])new byte[1000000]));
        union.update((ArrayOfDoublesSketch)sketch1);
        union.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult(WritableMemory.wrap((byte[])new byte[1000000]));
        Assert.assertEquals((Object)result.getEstimate(), (Object)3.0);
        double[][] values = result.getValues();
        Assert.assertEquals((Object)values[0][0], (Object)3.0);
        Assert.assertEquals((Object)values[1][0], (Object)3.0);
        Assert.assertEquals((Object)values[2][0], (Object)3.0);
        union.reset();
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getTheta(), (Object)1.0);
    }

    @Test
    public void directEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion(WritableMemory.wrap((byte[])new byte[1000000]));
        union.update((ArrayOfDoublesSketch)sketch1);
        union.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = union.getResult(WritableMemory.wrap((byte[])new byte[1000000]));
        Assert.assertEquals((double)result.getEstimate(), (double)12288.0, (double)122.88);
        union.reset();
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)result.isEstimationMode());
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getTheta(), (Object)1.0);
    }

    @Test
    public void heapToDirect() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesUnion heapUnion = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        heapUnion.update((ArrayOfDoublesSketch)sketch1);
        ArrayOfDoublesUnion directUnion = ArrayOfDoublesUnion.wrap((WritableMemory)WritableMemory.wrap((byte[])heapUnion.toByteArray()));
        directUnion.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = directUnion.getResult(WritableMemory.wrap((byte[])new byte[1000000]));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)3.0);
        double[][] values = result.getValues();
        Assert.assertEquals((int)values.length, (int)3);
        Assert.assertEquals((Object)values[0][0], (Object)3.0);
        Assert.assertEquals((Object)values[1][0], (Object)3.0);
        Assert.assertEquals((Object)values[2][0], (Object)3.0);
    }

    @Test
    public void directToHeap() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesUnion directUnion = new ArrayOfDoublesSetOperationBuilder().buildUnion(WritableMemory.wrap((byte[])new byte[1000000]));
        directUnion.update((ArrayOfDoublesSketch)sketch1);
        ArrayOfDoublesUnion heapUnion = ArrayOfDoublesUnion.heapify((Memory)Memory.wrap((byte[])directUnion.toByteArray()));
        heapUnion.update((ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = heapUnion.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((Object)result.getEstimate(), (Object)3.0);
        double[][] values = result.getValues();
        Assert.assertEquals((int)values.length, (int)3);
        Assert.assertEquals((Object)values[0][0], (Object)3.0);
        Assert.assertEquals((Object)values[1][0], (Object)3.0);
        Assert.assertEquals((Object)values[2][0], (Object)3.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleSeeds() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build();
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setSeed(2L).buildUnion();
        union.update((ArrayOfDoublesSketch)sketch);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleInputSketchFewerValues() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setNumberOfValues(2).buildUnion();
        union.update((ArrayOfDoublesSketch)sketch);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleInputSketchMoreValues() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union.update((ArrayOfDoublesSketch)sketch);
    }

    @Test
    public void directDruidUsageOneSketch() {
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[1000000]);
        new ArrayOfDoublesSetOperationBuilder().buildUnion(mem);
        int n = 100000;
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 100000; ++i) {
            sketch.update((long)i, new double[]{1.0});
        }
        sketch.trim();
        ArrayOfDoublesSketches.wrapUnion((WritableMemory)mem).update((ArrayOfDoublesSketch)sketch.compact(WritableMemory.wrap((byte[])new byte[1000000])));
        ArrayOfDoublesCompactSketch result = ArrayOfDoublesUnion.wrap((WritableMemory)mem).getResult();
        Assert.assertEquals((Object)result.getEstimate(), (Object)sketch.getEstimate());
        Assert.assertEquals((boolean)result.isEstimationMode(), (boolean)sketch.isEstimationMode());
    }

    @Test
    public void directDruidUsageTwoSketches() {
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[1000000]);
        new ArrayOfDoublesSetOperationBuilder().buildUnion(mem);
        int key = 0;
        int n1 = 100000;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 100000; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesSketches.wrapUnion((WritableMemory)mem).update((ArrayOfDoublesSketch)sketch1.compact(WritableMemory.wrap((byte[])new byte[1000000])));
        int n2 = 1000000;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 1000000; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesSketches.wrapUnion((WritableMemory)mem).update((ArrayOfDoublesSketch)sketch2.compact(WritableMemory.wrap((byte[])new byte[1000000])));
        key = 0;
        int n = 1100000;
        ArrayOfDoublesUpdatableSketch expected = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 1100000; ++i) {
            expected.update((long)key++, new double[]{1.0});
        }
        expected.trim();
        ArrayOfDoublesCompactSketch result = ArrayOfDoublesUnion.wrap((WritableMemory)mem).getResult();
        Assert.assertEquals((Object)result.getEstimate(), (Object)expected.getEstimate());
        Assert.assertEquals((boolean)result.isEstimationMode(), (boolean)expected.isEstimationMode());
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)expected.getUpperBound(1));
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)expected.getLowerBound(1));
        Assert.assertEquals((int)result.getRetainedEntries(), (int)expected.getRetainedEntries());
        Assert.assertEquals((int)result.getNumValues(), (int)expected.getNumValues());
    }
}

