/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.ArrayOfDoublesCombiner;
import org.apache.datasketches.tuple.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesIntersection;
import org.apache.datasketches.tuple.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesIntersectionTest {
    private static ArrayOfDoublesCombiner combiner = new ArrayOfDoublesCombiner(){

        public double[] combine(double[] a, double[] b) {
            for (int i = 0; i < a.length; ++i) {
                int n = i;
                a[n] = a[n] + b[i];
            }
            return a;
        }
    };

    @Test
    public void nullInput() {
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.update(null, null);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((int)result.getValues().length, (int)0);
    }

    @Test
    public void empty() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.update((ArrayOfDoublesSketch)sketch1, null);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((int)result.getValues().length, (int)0);
    }

    @Test
    public void notEmptyNoEntries() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSamplingProbability(0.01f).build();
        sketch1.update("a", new double[]{1.0});
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.update((ArrayOfDoublesSketch)sketch1, null);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((int)result.getValues().length, (int)0);
    }

    @Test
    public void heapExactWithEmpty() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        sketch1.update(3L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.update((ArrayOfDoublesSketch)sketch1, null);
        intersection.update((ArrayOfDoublesSketch)sketch2, null);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
    }

    @Test
    public void directExactWithEmpty() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        sketch1.update(3L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection(WritableMemory.wrap((byte[])new byte[1000000]));
        intersection.update((ArrayOfDoublesSketch)sketch1, null);
        intersection.update((ArrayOfDoublesSketch)sketch2, null);
        ArrayOfDoublesCompactSketch result = intersection.getResult(WritableMemory.wrap((byte[])new byte[1000000]));
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
    }

    @Test
    public void heapExactMode() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.update((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.update((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1);
        Assert.assertEquals((Object)result.getEstimate(), (Object)1.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)1.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)1.0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)values[i][0], (Object)4.0);
        }
        intersection.reset();
        intersection.update(null, null);
        result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
    }

    @Test
    public void heapDisjointEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.update((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.update((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((int)result.getValues().length, (int)0);
    }

    @Test
    public void directDisjointEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection(WritableMemory.wrap((byte[])new byte[1000000]));
        intersection.update((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.update((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult(WritableMemory.wrap((byte[])new byte[1000000]));
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((Object)result.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((int)result.getValues().length, (int)0);
    }

    @Test
    public void heapEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        intersection.update((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.update((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)values[i][0], (Object)2.0);
        }
    }

    @Test
    public void directEstimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build(WritableMemory.wrap((byte[])new byte[1000000]));
        for (int i = 0; i < 8192; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().buildIntersection(WritableMemory.wrap((byte[])new byte[1000000]));
        intersection.update((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.update((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult(WritableMemory.wrap((byte[])new byte[1000000]));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)values[i][0], (Object)2.0);
        }
    }

    @Test
    public void heapExactModeCustomSeed() {
        long seed = 1234567890L;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build();
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(1L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        sketch1.update(2L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build();
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(2L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        sketch2.update(3L, new double[]{1.0});
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().setSeed(seed).buildIntersection();
        intersection.update((ArrayOfDoublesSketch)sketch1, combiner);
        intersection.update((ArrayOfDoublesSketch)sketch2, combiner);
        ArrayOfDoublesCompactSketch result = intersection.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)1);
        Assert.assertEquals((Object)result.getEstimate(), (Object)1.0);
        Assert.assertEquals((Object)result.getLowerBound(1), (Object)1.0);
        Assert.assertEquals((Object)result.getUpperBound(1), (Object)1.0);
        double[][] values = result.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)values[i][0], (Object)4.0);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleSeeds() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build();
        ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().setSeed(2L).buildIntersection();
        intersection.update((ArrayOfDoublesSketch)sketch, combiner);
    }
}

