/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableDirectHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BackwardConversions;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UnionImpl;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionImplTest {
    @Test
    public void checkUpdateWithSketch() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 8 + 24]);
        WritableMemory mem2 = WritableMemory.wrap((byte[])new byte[k * 8 + 24]);
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            sketch.update((long)i);
        }
        CompactSketch sketchInDirectOrd = sketch.compact(true, mem);
        CompactSketch sketchInDirectUnord = sketch.compact(false, mem2);
        CompactSketch sketchInHeap = sketch.compact(true, null);
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        union.update((Sketch)sketchInDirectOrd);
        union.update((Sketch)sketchInHeap);
        union.update((Sketch)sketchInDirectUnord);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)k, (double)0.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCorruptedCompactFlag() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 8 + 24]);
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            sketch.update((long)i);
        }
        CompactSketch sketchInDirectOrd = sketch.compact(true, mem);
        sketch.compact(false, mem);
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        union.update((Sketch)sketchInDirectOrd);
    }

    @Test
    public void checkUpdateWithMem() {
        int k = 16;
        WritableMemory skMem = WritableMemory.wrap((byte[])new byte[2 * k * 8 + 24]);
        WritableMemory dirOrdCskMem = WritableMemory.wrap((byte[])new byte[k * 8 + 24]);
        WritableMemory dirUnordCskMem = WritableMemory.wrap((byte[])new byte[k * 8 + 24]);
        UpdateSketch udSketch = UpdateSketch.builder().setNominalEntries(k).build(skMem);
        for (int i = 0; i < k; ++i) {
            udSketch.update((long)i);
        }
        udSketch.compact(true, dirOrdCskMem);
        udSketch.compact(false, dirUnordCskMem);
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        union.update((Memory)skMem);
        union.update((Memory)dirOrdCskMem);
        union.update((Memory)dirUnordCskMem);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)k, (double)0.0);
    }

    @Test
    public void checkFastWrap() {
        int k = 16;
        long seed = 9001L;
        int unionSize = Sketches.getMaxUnionBytes((int)k);
        WritableMemory srcMem = WritableMemory.wrap((byte[])new byte[unionSize]);
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion(srcMem);
        for (int i = 0; i < k; ++i) {
            union.update((long)i);
        }
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)k, (double)0.0);
        UnionImpl union2 = UnionImpl.fastWrap((WritableMemory)srcMem, (long)seed);
        Assert.assertEquals((double)union2.getResult().getEstimate(), (double)k, (double)0.0);
        WritableMemory srcMemR = srcMem;
        UnionImpl union3 = UnionImpl.fastWrap((Memory)srcMemR, (long)seed);
        Assert.assertEquals((double)union3.getResult().getEstimate(), (double)k, (double)0.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCorruptFamilyException() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 8 + 24]);
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            sketch.update((long)i);
        }
        sketch.compact(true, mem);
        mem.putByte(2L, (byte)0);
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        union.update((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkVer1FamilyException() {
        int k = 16;
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            sketch.update((long)i);
        }
        CompactSketch csk = sketch.compact(true, null);
        WritableMemory v1mem = (WritableMemory)BackwardConversions.convertSerVer3toSerVer1(csk);
        v1mem.putByte(2L, (byte)2);
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        union.update((Memory)v1mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkVer2FamilyException() {
        int k = 16;
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            sketch.update((long)i);
        }
        CompactSketch csk = sketch.compact(true, null);
        WritableMemory v2mem = (WritableMemory)BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        v2mem.putByte(2L, (byte)2);
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        union.update((Memory)v2mem);
    }

    @Test
    public void checkVer2EmptyHandling() {
        int k = 16;
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        Memory mem = BackwardConversions.convertSerVer3toSerVer2(sketch.compact(), 9001L);
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        union.update(mem);
    }

    @Test
    public void checkMoveAndResize() {
        int k = 4096;
        int u = 2 * k;
        int bytes = Sketches.getMaxUpdateSketchBytes((int)k);
        try (WritableDirectHandle wdh = WritableMemory.allocateDirect((long)(bytes / 2));
             WritableDirectHandle wdh2 = WritableMemory.allocateDirect((long)(bytes / 2));){
            WritableMemory wmem = wdh.get();
            UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build(wmem);
            Assert.assertTrue((boolean)sketch.isSameResource((Memory)wmem));
            WritableMemory wmem2 = wdh2.get();
            Union union = SetOperation.builder().buildUnion(wmem2);
            Assert.assertTrue((boolean)union.isSameResource((Memory)wmem2));
            for (int i = 0; i < u; ++i) {
                union.update((long)i);
            }
            Assert.assertFalse((boolean)union.isSameResource((Memory)wmem));
            Union union2 = SetOperation.builder().buildUnion();
            Assert.assertFalse((boolean)union2.isSameResource((Memory)wmem2));
        }
    }

    @Test
    public void checkRestricted() {
        Union union = Sketches.setOperationBuilder().buildUnion();
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertEquals((long)union.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((short)union.getSeedHash(), (short)Util.computeSeedHash((long)9001L));
        Assert.assertEquals((int)union.getRetainedEntries(true), (int)0);
        Assert.assertEquals((int)union.getCache().length, (int)128);
    }

    @Test
    public void checkUnionCompactOrderedSource() {
        int k = 4096;
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        for (int i = 0; i < k; ++i) {
            sk.update((long)i);
        }
        double est1 = sk.getEstimate();
        int bytes = Sketches.getMaxCompactSketchBytes((int)sk.getRetainedEntries());
        try (WritableDirectHandle h = WritableMemory.allocateDirect((long)bytes);){
            WritableMemory wmem = h.get();
            CompactSketch csk = sk.compact(true, wmem);
            Union union = Sketches.setOperationBuilder().buildUnion();
            union.update((Sketch)csk);
            double est2 = union.getResult().getEstimate();
            Assert.assertEquals((Object)est2, (Object)est1);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCompactFlagCorruption() {
        int k = 4096;
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem1 = WritableMemory.allocate((int)bytes);
        UpdateSketch sk = Sketches.updateSketchBuilder().setNominalEntries(k).build(wmem1);
        for (int i = 0; i < k; ++i) {
            sk.update((long)i);
        }
        sk.compact(true, wmem1);
        Union union = SetOperation.builder().buildUnion();
        union.update((Sketch)sk);
        CompactSketch csk1 = union.getResult();
        UnionImplTest.println("" + csk1.getEstimate());
    }

    @Test
    public void checkDirectUnionSingleItem() {
        int i;
        int i2;
        int num = 2;
        UpdateSketch[] skArr = new UpdateSketch[num];
        for (i2 = 0; i2 < num; ++i2) {
            skArr[i2] = new UpdateSketchBuilder().build();
        }
        for (i2 = 0; i2 < num / 2; ++i2) {
            skArr[i2].update((long)i2);
            skArr[i2 + num / 2].update((long)i2);
            skArr[i2].update((long)(i2 + num));
        }
        Union union = new SetOperationBuilder().buildUnion();
        for (int i3 = 0; i3 < num; ++i3) {
            union.update((Sketch)skArr[i3]);
        }
        CompactSketch csk = union.getResult();
        Assert.assertEquals((Object)csk.getEstimate(), (Object)2.0);
        Memory[] memArr = new Memory[num];
        for (i = 0; i < num; ++i) {
            memArr[i] = Memory.wrap((byte[])skArr[i].compact().toByteArray());
        }
        union = new SetOperationBuilder().buildUnion();
        for (i = 0; i < num; ++i) {
            union.update(memArr[i]);
        }
        csk = union.getResult();
        Assert.assertEquals((Object)csk.getEstimate(), (Object)2.0);
    }

    @Test
    public void printlnTest() {
        UnionImplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }
}

