/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BackwardConversions;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchesTest {
    private static Memory getCompactSketchMemory(int k, int from, int to) {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = from; i < to; ++i) {
            sk1.update((long)i);
        }
        CompactSketch csk = sk1.compact(true, null);
        byte[] sk1bytes = csk.toByteArray();
        Memory mem = Memory.wrap((byte[])sk1bytes);
        return mem;
    }

    private static Memory getMemoryFromCompactSketch(CompactSketch csk) {
        byte[] sk1bytes = csk.toByteArray();
        Memory mem = Memory.wrap((byte[])sk1bytes);
        return mem;
    }

    private static CompactSketch getCompactSketch(int k, int from, int to) {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = from; i < to; ++i) {
            sk1.update((long)i);
        }
        return sk1.compact(true, null);
    }

    @Test
    public void checkSketchMethods() {
        int k = 1024;
        Memory mem = SketchesTest.getCompactSketchMemory(k, 0, k);
        CompactSketch csk2 = (CompactSketch)Sketches.heapifySketch((Memory)mem);
        Assert.assertEquals((int)((int)csk2.getEstimate()), (int)k);
        csk2 = (CompactSketch)Sketches.heapifySketch((Memory)mem, (long)9001L);
        Assert.assertEquals((int)((int)csk2.getEstimate()), (int)k);
        csk2 = (CompactSketch)Sketches.wrapSketch((Memory)mem);
        Assert.assertEquals((int)((int)csk2.getEstimate()), (int)k);
        csk2 = (CompactSketch)Sketches.wrapSketch((Memory)mem, (long)9001L);
        Assert.assertEquals((int)((int)csk2.getEstimate()), (int)k);
    }

    @Test
    public void checkSetOpMethods() {
        int k = 1024;
        Memory mem1 = SketchesTest.getCompactSketchMemory(k, 0, k);
        Memory mem2 = SketchesTest.getCompactSketchMemory(k, k / 2, 3 * k / 2);
        SetOperationBuilder bldr = Sketches.setOperationBuilder();
        Union union = bldr.setNominalEntries(2 * k).buildUnion();
        union.update(mem1);
        CompactSketch cSk = union.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)k);
        union.update(mem2);
        cSk = union.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)(3 * k / 2));
        byte[] ubytes = union.toByteArray();
        WritableMemory uMem = WritableMemory.wrap((byte[])ubytes);
        Union union2 = (Union)Sketches.heapifySetOperation((Memory)uMem);
        cSk = union2.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)(3 * k / 2));
        union2 = (Union)Sketches.heapifySetOperation((Memory)uMem, (long)9001L);
        cSk = union2.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)(3 * k / 2));
        union2 = (Union)Sketches.wrapSetOperation((WritableMemory)uMem);
        cSk = union2.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)(3 * k / 2));
        union2 = (Union)Sketches.wrapSetOperation((WritableMemory)uMem, (long)9001L);
        cSk = union2.getResult(true, null);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)(3 * k / 2));
        int serVer = Sketches.getSerializationVersion((Memory)uMem);
        Assert.assertEquals((int)serVer, (int)3);
    }

    @Test
    public void checkUtilMethods() {
        int k = 1024;
        int maxUnionBytes = Sketches.getMaxUnionBytes((int)k);
        Assert.assertEquals((int)(2 * k * 8 + 32), (int)maxUnionBytes);
        int maxInterBytes = Sketches.getMaxIntersectionBytes((int)k);
        Assert.assertEquals((int)(2 * k * 8 + 24), (int)maxInterBytes);
        int maxCompSkBytes = Sketches.getMaxCompactSketchBytes((int)(k + 1));
        Assert.assertEquals((int)(24 + (k + 1) * 8), (int)maxCompSkBytes);
        int maxSkBytes = Sketches.getMaxUpdateSketchBytes((int)k);
        Assert.assertEquals((int)(24 + 2 * k * 8), (int)maxSkBytes);
    }

    @Test
    public void checkStaticEstimators() {
        int k = 4096;
        int u = 4 * k;
        CompactSketch csk = SketchesTest.getCompactSketch(k, 0, u);
        Memory srcMem = SketchesTest.getMemoryFromCompactSketch(csk);
        double est = Sketches.getEstimate((Memory)srcMem);
        Assert.assertEquals((double)est, (double)u, (double)(0.05 * (double)u));
        double rse = 1.0 / Math.sqrt(k);
        double ub = Sketches.getUpperBound((int)1, (Memory)srcMem);
        Assert.assertEquals((double)ub, (double)(est + rse), (double)(0.05 * (double)u));
        double lb = Sketches.getLowerBound((int)1, (Memory)srcMem);
        Assert.assertEquals((double)lb, (double)(est - rse), (double)(0.05 * (double)u));
        Memory memV1 = BackwardConversions.convertSerVer3toSerVer1(csk);
        boolean empty = Sketches.getEmpty((Memory)memV1);
        Assert.assertFalse((boolean)empty);
        CompactSketch csk2 = SketchesTest.getCompactSketch(k, 0, 0);
        Memory emptyMemV3 = SketchesTest.getMemoryFromCompactSketch(csk2);
        Assert.assertEquals((int)Sketches.getRetainedEntries((Memory)emptyMemV3), (int)0);
        Assert.assertEquals((long)Sketches.getThetaLong((Memory)emptyMemV3), (long)Long.MAX_VALUE);
        Memory emptyMemV1 = BackwardConversions.convertSerVer3toSerVer1(csk2);
        empty = Sketches.getEmpty((Memory)emptyMemV1);
        Assert.assertTrue((boolean)empty);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSketchFamily() {
        Union union = Sketches.setOperationBuilder().buildUnion();
        byte[] byteArr = union.toByteArray();
        Memory srcMem = Memory.wrap((byte[])byteArr);
        Sketches.getEstimate((Memory)srcMem);
    }

    @Test
    public void printlnTest() {
        SketchesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

