/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Random;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.PairwiseSetOperations;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PairwiseCornerCasesTest {
    Random rand = new Random(9001L);

    @Test
    public void checkSetOps() {
        int hiA = 0;
        int loB = 0;
        int hiB = 0;
        for (int i = 0; i < 1000; ++i) {
            hiA = 0 + this.rand.nextInt(128);
            loB = this.rand.nextInt(64);
            hiB = 0 + loB + this.rand.nextInt(64);
            PairwiseCornerCasesTest.compareSetOps(64, 0, hiA, loB, hiB);
        }
    }

    private static void compareSetOps(int k, int loA, int hiA, int loB, int hiB) {
        int i;
        UpdateSketch skA = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        UpdateSketch skB = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        for (i = loA; i < hiA; ++i) {
            skA.update((long)i);
        }
        for (i = loB; i < hiB; ++i) {
            skB.update((long)i);
        }
        union.update((Sketch)skA);
        union.update((Sketch)skB);
        CompactSketch comp = union.getResult(true, null);
        double unionEst = comp.getEstimate();
        CompactSketch cskA = skA.compact();
        CompactSketch cskB = skB.compact();
        CompactSketch pwComp = PairwiseSetOperations.union((CompactSketch)cskA, (CompactSketch)cskB, (int)k);
        double pwUnionEst = pwComp.getEstimate();
        Assert.assertEquals((double)pwUnionEst, (double)unionEst, (double)0.0);
        inter.update((Sketch)skA);
        inter.update((Sketch)skB);
        comp = inter.getResult(true, null);
        double interEst = comp.getEstimate();
        cskA = skA.compact();
        cskB = skB.compact();
        pwComp = PairwiseSetOperations.intersect((Sketch)cskA, (Sketch)cskB);
        double pwInterEst = pwComp.getEstimate();
        Assert.assertEquals((double)pwInterEst, (double)interEst, (double)0.0);
        aNotB.update((Sketch)skA, (Sketch)skB);
        comp = aNotB.getResult(true, null);
        double aNbEst = comp.getEstimate();
        cskA = skA.compact();
        cskB = skB.compact();
        pwComp = PairwiseSetOperations.aNotB((Sketch)cskA, (Sketch)cskB);
        double pwAnBEst = pwComp.getEstimate();
        Assert.assertEquals((Object)pwAnBEst, (Object)aNbEst);
    }

    @Test
    public void compareCornerCases() {
        int k = 64;
        for (State stateA : State.values()) {
            for (State stateB : State.values()) {
                if (stateA == State.EST_MEMORY_UNORDERED || stateB == State.EST_MEMORY_UNORDERED) continue;
                PairwiseCornerCasesTest.cornerCaseChecks(stateA, stateB, k);
            }
        }
    }

    @Test
    public void checkNull_THLT1_CNT0_FALSE() {
        PairwiseCornerCasesTest.cornerCaseChecks(State.NULL, State.THLT1_CNT0_FALSE, 64);
    }

    private static void cornerCaseChecks(State stateA, State stateB, int k) {
        PairwiseCornerCasesTest.println("StateA: " + (Object)((Object)stateA) + ", StateB: " + (Object)((Object)stateB));
        CompactSketch cskA = PairwiseCornerCasesTest.generate(stateA, k);
        CompactSketch cskB = PairwiseCornerCasesTest.generate(stateB, k);
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        union.update((Sketch)cskA);
        union.update((Sketch)cskB);
        CompactSketch comp = union.getResult(true, null);
        double stdEst = comp.getEstimate();
        boolean stdEmpty = comp.isEmpty();
        double stdTheta = comp.getTheta();
        int stdEnt = comp.getRetainedEntries(true);
        CompactSketch pwComp = PairwiseSetOperations.union((CompactSketch)cskA, (CompactSketch)cskB, (int)k);
        double pwEst = pwComp.getEstimate();
        boolean pwEmpty = pwComp.isEmpty();
        double pwTheta = pwComp.getTheta();
        int pwEnt = pwComp.getRetainedEntries(true);
        if (stateA == State.NULL && stateB == State.NULL) {
            Assert.assertEquals((double)pwEst, (double)0.0, (double)0.0);
            Assert.assertEquals((double)stdEst, (double)0.0, (double)0.0);
        } else {
            Assert.assertEquals((double)pwEst, (double)stdEst, (double)0.0);
        }
        assert (pwEmpty == stdEmpty);
        Assert.assertEquals((boolean)pwEmpty, (boolean)stdEmpty);
        Assert.assertEquals((double)pwTheta, (double)stdTheta, (double)0.0);
        Assert.assertEquals((int)pwEnt, (int)stdEnt);
        inter.update((Sketch)cskA);
        inter.update((Sketch)cskB);
        comp = inter.getResult(true, null);
        stdEst = comp.getEstimate();
        stdEmpty = comp.isEmpty();
        stdTheta = comp.getTheta();
        stdEnt = comp.getRetainedEntries(true);
        pwComp = PairwiseSetOperations.intersect((Sketch)cskA, (Sketch)cskB);
        pwEst = pwComp.getEstimate();
        pwEmpty = pwComp.isEmpty();
        pwTheta = pwComp.getTheta();
        pwEnt = pwComp.getRetainedEntries(true);
        if (stateA == State.NULL && stateB == State.NULL) {
            Assert.assertEquals((double)pwEst, (double)0.0, (double)0.0);
            Assert.assertEquals((double)stdEst, (double)0.0, (double)0.0);
        } else {
            Assert.assertEquals((double)pwEst, (double)stdEst, (double)0.0);
        }
        Assert.assertEquals((boolean)pwEmpty, (boolean)stdEmpty);
        Assert.assertEquals((double)pwTheta, (double)stdTheta, (double)0.0);
        Assert.assertEquals((int)pwEnt, (int)stdEnt);
        aNotB.update((Sketch)cskA, (Sketch)cskB);
        comp = aNotB.getResult(true, null);
        stdEst = comp.getEstimate();
        stdEmpty = comp.isEmpty();
        stdTheta = comp.getTheta();
        stdEnt = comp.getRetainedEntries(true);
        pwComp = PairwiseSetOperations.aNotB((Sketch)cskA, (Sketch)cskB);
        pwEst = pwComp.getEstimate();
        pwEmpty = pwComp.isEmpty();
        pwTheta = pwComp.getTheta();
        pwEnt = pwComp.getRetainedEntries(true);
        if (stateA == State.NULL && stateB == State.NULL) {
            Assert.assertEquals((double)pwEst, (double)0.0, (double)0.0);
            Assert.assertEquals((double)stdEst, (double)0.0, (double)0.0);
        } else {
            Assert.assertEquals((double)pwEst, (double)stdEst, (double)0.0);
        }
        Assert.assertEquals((boolean)pwEmpty, (boolean)stdEmpty);
        Assert.assertEquals((double)pwTheta, (double)stdTheta, (double)0.0);
        Assert.assertEquals((int)pwEnt, (int)stdEnt);
    }

    @Test
    public void checkNotOrdered() {
        int k = 64;
        CompactSketch skNull = PairwiseCornerCasesTest.generate(State.NULL, k);
        CompactSketch skEmpty = PairwiseCornerCasesTest.generate(State.EMPTY, k);
        CompactSketch skHeap = PairwiseCornerCasesTest.generate(State.EST_HEAP, k);
        CompactSketch skHeapUO = PairwiseCornerCasesTest.generate(State.EST_MEMORY_UNORDERED, k);
        try {
            PairwiseSetOperations.union((CompactSketch)skNull, (CompactSketch)skHeapUO, (int)k);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skEmpty, (CompactSketch)skHeapUO, (int)k);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skHeapUO, (CompactSketch)skNull, (int)k);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skHeapUO, (CompactSketch)skEmpty, (int)k);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skHeapUO, (CompactSketch)skHeap, (int)k);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skHeap, (CompactSketch)skHeapUO, (int)k);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkSeedHash() {
        int k = 64;
        UpdateSketch tmp1 = Sketches.updateSketchBuilder().setNominalEntries(k).setSeed(123L).build();
        tmp1.update(1L);
        tmp1.update(3L);
        CompactSketch skSmallSeed2 = tmp1.compact(true, null);
        UpdateSketch tmp2 = Sketches.updateSketchBuilder().setNominalEntries(k).setSeed(123L).build();
        tmp2.update(1L);
        tmp2.update(2L);
        CompactSketch skSmallSeed2B = tmp2.compact(true, null);
        CompactSketch skExact = PairwiseCornerCasesTest.generate(State.EXACT, k);
        CompactSketch skHeap = PairwiseCornerCasesTest.generate(State.EST_HEAP, 2 * k);
        try {
            PairwiseSetOperations.intersect((Sketch)skExact, (Sketch)skSmallSeed2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.intersect((Sketch)skExact, (Sketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.intersect((Sketch)skSmallSeed2B, (Sketch)skExact);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.intersect((Sketch)skHeap, (Sketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.aNotB((Sketch)skExact, (Sketch)skSmallSeed2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.aNotB((Sketch)skExact, (Sketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.aNotB((Sketch)skSmallSeed2B, (Sketch)skExact);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.aNotB((Sketch)skHeap, (Sketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skExact, (CompactSketch)skSmallSeed2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skExact, (CompactSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skSmallSeed2B, (CompactSketch)skExact);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PairwiseSetOperations.union((CompactSketch)skHeap, (CompactSketch)skSmallSeed2B);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void checkReduceToK() {
        int k = 16;
        CompactSketch skNull = PairwiseCornerCasesTest.generate(State.NULL, k);
        CompactSketch skEmpty = PairwiseCornerCasesTest.generate(State.EMPTY, k);
        CompactSketch skHeap1 = PairwiseCornerCasesTest.generate(State.EST_HEAP, k);
        CompactSketch skHeap2 = PairwiseCornerCasesTest.generate(State.EST_HEAP, k);
        CompactSketch csk = PairwiseSetOperations.union((CompactSketch)skNull, (CompactSketch)skHeap1, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)k);
        csk = PairwiseSetOperations.union((CompactSketch)skEmpty, (CompactSketch)skHeap1, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)k);
        csk = PairwiseSetOperations.union((CompactSketch)skHeap1, (CompactSketch)skNull, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)k);
        csk = PairwiseSetOperations.union((CompactSketch)skHeap1, (CompactSketch)skEmpty, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)k);
        csk = PairwiseSetOperations.union((CompactSketch)skHeap1, (CompactSketch)skHeap2, (int)k);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)k);
    }

    @Test
    public void printlnTest() {
        PairwiseCornerCasesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    @Test
    public void checkGenerate() {
        int k = 16;
        CompactSketch csk = PairwiseCornerCasesTest.generate(State.NULL, 0);
        Assert.assertNull((Object)csk);
        csk = PairwiseCornerCasesTest.generate(State.EMPTY, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)0);
        Assert.assertEquals((long)csk.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = PairwiseCornerCasesTest.generate(State.EXACT, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)k);
        Assert.assertEquals((long)csk.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = PairwiseCornerCasesTest.generate(State.EST_HEAP, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)true);
        Assert.assertEquals((csk.getRetainedEntries() > k ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = PairwiseCornerCasesTest.generate(State.THLT1_CNT0_FALSE, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)true);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)0);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = PairwiseCornerCasesTest.generate(State.THEQ1_CNT0_TRUE, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)false);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)0);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)false);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)true);
        csk = PairwiseCornerCasesTest.generate(State.EST_MEMORY_UNORDERED, k);
        Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)true);
        Assert.assertEquals((csk.getRetainedEntries() > k ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((csk.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0, (boolean)true);
        Assert.assertEquals((boolean)csk.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)csk.hasMemory(), (boolean)true);
        Assert.assertEquals((boolean)csk.isOrdered(), (boolean)false);
    }

    private static CompactSketch generate(State state, int k) {
        UpdateSketch sk = null;
        CompactSketch csk = null;
        switch (state) {
            case NULL: {
                break;
            }
            case EMPTY: {
                csk = Sketches.updateSketchBuilder().setNominalEntries(k).build().compact(true, null);
                break;
            }
            case EXACT: {
                sk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
                for (int i = 0; i < k; ++i) {
                    sk.update((long)i);
                }
                csk = sk.compact(true, null);
                break;
            }
            case EST_HEAP: {
                sk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
                for (int i = 0; i < 4 * k; ++i) {
                    sk.update((long)i);
                }
                csk = sk.compact(true, null);
                break;
            }
            case THLT1_CNT0_FALSE: {
                sk = Sketches.updateSketchBuilder().setP(0.5f).setNominalEntries(k).build();
                sk.update(7L);
                assert (sk.getRetainedEntries() == 0);
                csk = sk.compact(true, null);
                break;
            }
            case THEQ1_CNT0_TRUE: {
                sk = Sketches.updateSketchBuilder().setP(0.5f).setNominalEntries(k).build();
                assert (sk.getRetainedEntries() == 0);
                csk = sk.compact(true, null);
                break;
            }
            case EST_MEMORY_UNORDERED: {
                sk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
                for (int i = 0; i < 4 * k; ++i) {
                    sk.update((long)i);
                }
                int bytes = Sketch.getMaxCompactSketchBytes((int)sk.getRetainedEntries(true));
                byte[] byteArr = new byte[bytes];
                WritableMemory mem = WritableMemory.wrap((byte[])byteArr);
                csk = sk.compact(false, mem);
                break;
            }
        }
        return csk;
    }

    static enum State {
        NULL,
        EMPTY,
        EXACT,
        EST_HEAP,
        THLT1_CNT0_FALSE,
        THEQ1_CNT0_TRUE,
        EST_MEMORY_UNORDERED;

    }
}

