/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Arrays;
import org.apache.datasketches.Family;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesReadOnlyException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableDirectHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectQuickSelectSketchTest {
    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k = 512;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < k; ++i) {
                usk.update((long)i);
            }
            Assert.assertFalse((boolean)usk.isEmpty());
            Assert.assertEquals((double)usk.getEstimate(), (double)k, (double)0.0);
            Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)k);
            mem.putByte(1L, (byte)0);
            Sketch.wrap((Memory)mem);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorKtooSmall() {
        int k = 8;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch.builder().setNominalEntries(k).build(mem);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorMemTooSmall() {
        int k = 16;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k / 2);){
            WritableMemory mem = h.get();
            UpdateSketch.builder().setNominalEntries(k).build(mem);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyIllegalFamilyID_heapify() {
        int k = 512;
        int bytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[bytes]);
        UpdateSketch.builder().setNominalEntries(k).build(mem);
        mem.putByte(2L, (byte)0);
        Sketch.heapify((Memory)mem);
    }

    @Test
    public void checkHeapifyMemoryEstimating() {
        int k = 512;
        int u = 2 * k;
        boolean estimating = u > k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(k).build(mem);
            for (int i = 0; i < u; ++i) {
                sk1.update((long)i);
            }
            double sk1est = sk1.getEstimate();
            double sk1lb = sk1.getLowerBound(2);
            double sk1ub = sk1.getUpperBound(2);
            Assert.assertEquals((boolean)sk1.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)sk1.getClass().getSimpleName(), (String)"DirectQuickSelectSketch");
            int curCount1 = sk1.getRetainedEntries(true);
            Assert.assertTrue((boolean)sk1.isDirect());
            Assert.assertTrue((boolean)sk1.hasMemory());
            Assert.assertFalse((boolean)sk1.isDirty());
            Assert.assertTrue((boolean)sk1.hasMemory());
            Assert.assertEquals((int)sk1.getCurrentPreambleLongs(false), (int)3);
            UpdateSketch sk2 = Sketches.heapifyUpdateSketch((Memory)mem);
            Assert.assertEquals((Object)sk2.getEstimate(), (Object)sk1est);
            Assert.assertEquals((Object)sk2.getLowerBound(2), (Object)sk1lb);
            Assert.assertEquals((Object)sk2.getUpperBound(2), (Object)sk1ub);
            Assert.assertEquals((boolean)sk2.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)sk2.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)sk2.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
            int curCount2 = sk2.getRetainedEntries(true);
            long[] cache = sk2.getCache();
            Assert.assertEquals((int)curCount1, (int)curCount2);
            long thetaLong = sk2.getThetaLong();
            int cacheCount = HashOperations.count((long[])cache, (long)thetaLong);
            Assert.assertEquals((int)curCount1, (int)cacheCount);
            Assert.assertFalse((boolean)sk2.isDirect());
            Assert.assertFalse((boolean)sk2.hasMemory());
            Assert.assertFalse((boolean)sk2.isDirty());
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_wrap() {
        int k = 512;
        int maxBytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[maxBytes]);
        UpdateSketch.builder().setNominalEntries(k).build(mem);
        mem.putByte(2L, (byte)0);
        Sketch.wrap((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_direct() {
        int k = 512;
        int maxBytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[maxBytes]);
        UpdateSketch.builder().setNominalEntries(k).build(mem);
        mem.putByte(2L, (byte)0);
        DirectQuickSelectSketch.writableWrap((WritableMemory)mem, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        int k = 512;
        long seed1 = 1021L;
        long seed2 = 9001L;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setSeed(seed1).setNominalEntries(k).build(mem);
            byte[] byteArray = usk.toByteArray();
            Memory srcMem = Memory.wrap((byte[])byteArray);
            Sketch.heapify((Memory)srcMem, (long)seed2);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCorruptLgNomLongs() {
        int k = 16;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch.builder().setNominalEntries(k).build(mem);
            mem.putByte(3L, (byte)2);
            Sketch.heapify((Memory)mem, (long)9001L);
        }
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int k = 512;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            for (int i = 0; i < k; ++i) {
                usk.update((long)i);
            }
            int bytes = usk.getCurrentBytes(false);
            byte[] byteArray = usk.toByteArray();
            Assert.assertEquals((int)bytes, (int)byteArray.length);
            Memory srcMem = Memory.wrap((byte[])byteArray);
            Sketch usk2 = Sketch.heapify((Memory)srcMem);
            Assert.assertEquals((double)usk2.getEstimate(), (double)k, (double)0.0);
            Assert.assertEquals((double)usk2.getLowerBound(2), (double)k, (double)0.0);
            Assert.assertEquals((double)usk2.getUpperBound(2), (double)k, (double)0.0);
            Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)false);
            Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
            usk2.toString(true, true, 8, true);
        }
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int k = 4096;
        int u = 2 * k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            double uskEst = usk.getEstimate();
            double uskLB = usk.getLowerBound(2);
            double uskUB = usk.getUpperBound(2);
            Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)true);
            byte[] byteArray = usk.toByteArray();
            Memory srcMem = Memory.wrap((byte[])byteArray);
            Sketch usk2 = Sketch.heapify((Memory)srcMem);
            Assert.assertEquals((Object)usk2.getEstimate(), (Object)uskEst);
            Assert.assertEquals((Object)usk2.getLowerBound(2), (Object)uskLB);
            Assert.assertEquals((Object)usk2.getUpperBound(2), (Object)uskUB);
            Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)true);
            Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        }
    }

    @Test
    public void checkWrapMemoryEst() {
        int k = 512;
        int u = 2 * k;
        boolean estimating = u > k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(k).build(mem);
            for (int i = 0; i < u; ++i) {
                sk1.update((long)i);
            }
            double sk1est = sk1.getEstimate();
            double sk1lb = sk1.getLowerBound(2);
            double sk1ub = sk1.getUpperBound(2);
            Assert.assertEquals((boolean)sk1.isEstimationMode(), (boolean)estimating);
            Sketch sk2 = Sketch.wrap((Memory)mem);
            Assert.assertEquals((Object)sk2.getEstimate(), (Object)sk1est);
            Assert.assertEquals((Object)sk2.getLowerBound(2), (Object)sk1lb);
            Assert.assertEquals((Object)sk2.getUpperBound(2), (Object)sk1ub);
            Assert.assertEquals((boolean)sk2.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)sk2.isEstimationMode(), (boolean)estimating);
        }
    }

    @Test
    public void checkDQStoCompactForms() {
        int k = 512;
        int u = 4 * k;
        boolean estimating = u > k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertEquals((String)usk.getClass().getSimpleName(), (String)"DirectQuickSelectSketch");
            Assert.assertTrue((boolean)usk.isDirect());
            Assert.assertTrue((boolean)usk.hasMemory());
            Assert.assertFalse((boolean)usk.isCompact());
            Assert.assertFalse((boolean)usk.isOrdered());
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            sk1.rebuild();
            double uskEst = usk.getEstimate();
            double uskLB = usk.getLowerBound(2);
            double uskUB = usk.getUpperBound(2);
            Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)estimating);
            CompactSketch csk = usk.compact(false, null);
            Assert.assertEquals((Object)csk.getEstimate(), (Object)uskEst);
            Assert.assertEquals((Object)csk.getLowerBound(2), (Object)uskLB);
            Assert.assertEquals((Object)csk.getUpperBound(2), (Object)uskUB);
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactUnorderedSketch");
            csk = usk.compact(true, null);
            Assert.assertEquals((Object)csk.getEstimate(), (Object)uskEst);
            Assert.assertEquals((Object)csk.getLowerBound(2), (Object)uskLB);
            Assert.assertEquals((Object)csk.getUpperBound(2), (Object)uskUB);
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactOrderedSketch");
            int bytes = usk.getCurrentBytes(true);
            Assert.assertEquals((int)bytes, (int)(k * 8 + (Family.COMPACT.getMaxPreLongs() << 3)));
            byte[] memArr2 = new byte[bytes];
            WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
            csk = usk.compact(false, mem2);
            Assert.assertEquals((Object)csk.getEstimate(), (Object)uskEst);
            Assert.assertEquals((Object)csk.getLowerBound(2), (Object)uskLB);
            Assert.assertEquals((Object)csk.getUpperBound(2), (Object)uskUB);
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactUnorderedSketch");
            mem2.clear();
            csk = usk.compact(true, mem2);
            Assert.assertEquals((Object)csk.getEstimate(), (Object)uskEst);
            Assert.assertEquals((Object)csk.getLowerBound(2), (Object)uskLB);
            Assert.assertEquals((Object)csk.getUpperBound(2), (Object)uskUB);
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactOrderedSketch");
            csk.toString(false, true, 0, false);
        }
    }

    @Test
    public void checkDQStoCompactEmptyForms() {
        int k = 512;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            usk.toString(false, true, 0, false);
            Assert.assertEquals((String)usk.getClass().getSimpleName(), (String)"DirectQuickSelectSketch");
            double uskEst = usk.getEstimate();
            double uskLB = usk.getLowerBound(2);
            double uskUB = usk.getUpperBound(2);
            Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)false);
            int bytes = usk.getCurrentBytes(true);
            Assert.assertEquals((int)bytes, (int)8);
            byte[] memArr2 = new byte[bytes];
            WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
            CompactSketch csk2 = usk.compact(false, mem2);
            Assert.assertEquals((Object)csk2.getEstimate(), (Object)uskEst);
            Assert.assertEquals((Object)csk2.getLowerBound(2), (Object)uskLB);
            Assert.assertEquals((Object)csk2.getUpperBound(2), (Object)uskUB);
            Assert.assertEquals((boolean)csk2.isEmpty(), (boolean)true);
            Assert.assertEquals((boolean)csk2.isEstimationMode(), (boolean)false);
            Assert.assertEquals((String)csk2.getClass().getSimpleName(), (String)"EmptyCompactSketch");
            CompactSketch csk3 = usk.compact(true, mem2);
            csk3.toString(false, true, 0, false);
            csk3.toString();
            Assert.assertEquals((Object)csk3.getEstimate(), (Object)uskEst);
            Assert.assertEquals((Object)csk3.getLowerBound(2), (Object)uskLB);
            Assert.assertEquals((Object)csk3.getUpperBound(2), (Object)uskUB);
            Assert.assertEquals((boolean)csk3.isEmpty(), (boolean)true);
            Assert.assertEquals((boolean)csk3.isEstimationMode(), (boolean)false);
            Assert.assertEquals((String)csk3.getClass().getSimpleName(), (String)"EmptyCompactSketch");
        }
    }

    @Test
    public void checkEstMode() {
        int k = 4096;
        int u = 2 * k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            Assert.assertTrue((sk1.getRetainedEntries(false) > k ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkSamplingMode() {
        int k = 4096;
        float p = 0.5f;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setP(p).setNominalEntries(k).build(mem);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            for (int i = 0; i < k; ++i) {
                usk.update((long)i);
            }
            double p2 = sk1.getP();
            double theta = sk1.getTheta();
            Assert.assertTrue((theta <= p2 ? 1 : 0) != 0);
            double est = usk.getEstimate();
            Assert.assertEquals((double)k, (double)est, (double)((double)k * 0.05));
            double ub = usk.getUpperBound(1);
            Assert.assertTrue((ub > est ? 1 : 0) != 0);
            double lb = usk.getLowerBound(1);
            Assert.assertTrue((lb < est ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkErrorBounds() {
        int k = 512;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            for (int i = 0; i < k; ++i) {
                usk.update((long)i);
            }
            double est = usk.getEstimate();
            double lb = usk.getLowerBound(2);
            double ub = usk.getUpperBound(2);
            Assert.assertEquals((double)est, (double)ub, (double)0.0);
            Assert.assertEquals((double)est, (double)lb, (double)0.0);
            int u = 100 * k;
            for (int i = k; i < u; ++i) {
                usk.update((long)i);
                usk.update((long)i);
            }
            est = usk.getEstimate();
            lb = usk.getLowerBound(2);
            ub = usk.getUpperBound(2);
            Assert.assertTrue((est <= ub ? 1 : 0) != 0);
            Assert.assertTrue((est >= lb ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkEmptyAndP() {
        int k = 1024;
        float p = 1.0f;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setP(p).setNominalEntries(k).build(mem);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            usk.update(1L);
            Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)1);
            Assert.assertFalse((boolean)usk.isEmpty());
            p = 0.001f;
            byte[] memArr2 = new byte[(int)mem.getCapacity()];
            WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
            UpdateSketch usk2 = UpdateSketch.builder().setP(p).setNominalEntries(k).build(mem2);
            sk1 = (DirectQuickSelectSketch)usk2;
            Assert.assertTrue((boolean)usk2.isEmpty());
            usk2.update(1L);
            Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)0);
            Assert.assertFalse((boolean)usk2.isEmpty());
            double est = usk2.getEstimate();
            Assert.assertEquals((double)est, (double)0.0, (double)0.0);
            double ub = usk2.getUpperBound(2);
            Assert.assertTrue((ub > 0.0 ? 1 : 0) != 0);
            double lb = usk2.getLowerBound(2);
            Assert.assertTrue((lb <= est ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkUpperAndLowerBounds() {
        int k = 512;
        int u = 2 * k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            double est = usk.getEstimate();
            double ub = usk.getUpperBound(1);
            double lb = usk.getLowerBound(1);
            Assert.assertTrue((ub > est ? 1 : 0) != 0);
            Assert.assertTrue((lb < est ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkRebuild() {
        int k = 512;
        int u = 4 * k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            Assert.assertFalse((boolean)usk.isEmpty());
            Assert.assertTrue((usk.getEstimate() > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((sk1.getRetainedEntries(false) > k ? 1 : 0) != 0);
            sk1.rebuild();
            Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)k);
            Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)k);
            sk1.rebuild();
            Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)k);
            Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)k);
        }
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int k = 512;
        int u = 4 * k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            Assert.assertFalse((boolean)usk.isEmpty());
            Assert.assertTrue((sk1.getRetainedEntries(false) > k ? 1 : 0) != 0);
            Assert.assertTrue((sk1.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0);
            sk1.reset();
            Assert.assertTrue((boolean)usk.isEmpty());
            Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)0);
            Assert.assertEquals((double)usk.getEstimate(), (double)0.0, (double)0.0);
            Assert.assertEquals((long)sk1.getThetaLong(), (long)Long.MAX_VALUE);
            Assert.assertNotNull((Object)sk1.getMemory());
            Assert.assertFalse((boolean)sk1.isOrdered());
        }
    }

    @Test
    public void checkExactModeMemoryArr() {
        int k = 4096;
        int u = 4096;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            Assert.assertEquals((double)usk.getEstimate(), (double)u, (double)0.0);
            Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)u);
        }
    }

    @Test
    public void checkEstModeMemoryArr() {
        int k = 4096;
        int u = 2 * k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(mem);
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            Assert.assertEquals((double)usk.getEstimate(), (double)u, (double)((double)u * 0.05));
            Assert.assertTrue((sk1.getRetainedEntries(false) > k ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkEstModeNativeMemory() {
        int k = 4096;
        int u = 2 * k;
        int memCapacity = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        try (WritableDirectHandle memHandler = WritableMemory.allocateDirect((long)memCapacity);){
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(memHandler.get());
            DirectQuickSelectSketch sk1 = (DirectQuickSelectSketch)usk;
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            double est = usk.getEstimate();
            DirectQuickSelectSketchTest.println("" + est);
            Assert.assertEquals((double)usk.getEstimate(), (double)u, (double)((double)u * 0.05));
            Assert.assertTrue((sk1.getRetainedEntries(false) > k ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkConstructReconstructFromMemory() {
        int k = 4096;
        int u = 2 * k;
        try (WritableDirectHandle h = DirectQuickSelectSketchTest.makeNativeMemory(k);){
            UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build(h.get());
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < u; ++i) {
                usk.update((long)i);
            }
            double est1 = usk.getEstimate();
            int count1 = usk.getRetainedEntries(false);
            Assert.assertEquals((double)est1, (double)u, (double)((double)u * 0.05));
            Assert.assertTrue((count1 >= k ? 1 : 0) != 0);
            byte[] serArr = usk.toByteArray();
            WritableMemory mem2 = WritableMemory.wrap((byte[])serArr);
            UpdateSketch usk2 = Sketches.wrapUpdateSketch((WritableMemory)mem2);
            double est2 = usk2.getEstimate();
            int count2 = usk2.getRetainedEntries(false);
            Assert.assertEquals((int)count2, (int)count1);
            Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        }
    }

    @Test(expectedExceptions={SketchesReadOnlyException.class})
    public void updateAfterReadOnlyWrap() {
        UpdateSketch usk1 = UpdateSketch.builder().build();
        UpdateSketch usk2 = (UpdateSketch)Sketch.wrap((Memory)Memory.wrap((byte[])usk1.toByteArray()));
        usk2.update(0L);
    }

    public void updateAfterWritableWrap() {
        UpdateSketch usk1 = UpdateSketch.builder().build();
        UpdateSketch usk2 = UpdateSketch.wrap((WritableMemory)WritableMemory.wrap((byte[])usk1.toByteArray()));
        usk2.update(0L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNegativeHashes() {
        int k = 512;
        UpdateSketch qs = UpdateSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(k).build();
        qs.hashUpdate(-1L);
    }

    @Test
    public void checkConstructorSrcMemCorruptions() {
        int k;
        int u = k = 1024;
        int bytes = Sketches.getMaxUpdateSketchBytes((int)k);
        byte[] arr1 = new byte[bytes];
        WritableMemory mem1 = WritableMemory.wrap((byte[])arr1);
        ResizeFactor rf = ResizeFactor.X1;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).setResizeFactor(rf).build(mem1);
        for (int i = 0; i < u; ++i) {
            usk1.update((long)i);
        }
        mem1.putByte(2L, (byte)3);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((WritableMemory)mem1, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        mem1.putByte(2L, (byte)2);
        mem1.putByte(0L, (byte)1);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((WritableMemory)mem1, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        mem1.putByte(0L, (byte)3);
        mem1.putByte(1L, (byte)2);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((WritableMemory)mem1, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        mem1.putByte(1L, (byte)3);
        mem1.putLong(16L, 0x3FFFFFFFFFFFFFFFL);
        mem1.putByte(4L, (byte)10);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((WritableMemory)mem1, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        mem1.putLong(16L, Long.MAX_VALUE);
        mem1.putByte(4L, (byte)11);
        byte badFlags = 27;
        mem1.putByte(5L, badFlags);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((WritableMemory)mem1, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        byte[] arr2 = Arrays.copyOfRange(arr1, 0, bytes - 1);
        WritableMemory mem2 = WritableMemory.wrap((byte[])arr2);
        try {
            DirectQuickSelectSketch usk2 = DirectQuickSelectSketch.writableWrap((WritableMemory)mem2, (long)9001L);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCorruptRFWithInsufficientArray() {
        int k = 1024;
        int bytes = Sketches.getMaxUpdateSketchBytes((int)k);
        byte[] arr = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])arr);
        ResizeFactor rf = ResizeFactor.X8;
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).setResizeFactor(rf).build(mem);
        usk.update(0L);
        PreambleUtil.insertLgResizeFactor((WritableMemory)mem, (int)0);
        DirectQuickSelectSketch dqss = DirectQuickSelectSketch.writableWrap((WritableMemory)mem, (long)9001L);
        Assert.assertEquals((Object)dqss.getResizeFactor(), (Object)ResizeFactor.X2);
    }

    @Test
    public void checkFamilyAndRF() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 16 + 24]);
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build(mem);
        Assert.assertEquals((Object)sketch.getFamily(), (Object)Family.QUICKSELECT);
        Assert.assertEquals((Object)sketch.getResizeFactor(), (Object)ResizeFactor.X8);
    }

    @Test
    public void checkResizeInBigMem() {
        int k = 16384;
        int u = 0x100000;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[8 * k * 16 + 24]);
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build(mem);
        for (int i = 0; i < u; ++i) {
            sketch.update((long)i);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadLgNomLongs() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 16 + 24]);
        Sketches.updateSketchBuilder().setNominalEntries(k).build(mem);
        mem.putByte(3L, (byte)3);
        DirectQuickSelectSketch.writableWrap((WritableMemory)mem, (long)9001L);
    }

    @Test
    public void checkMoveAndResize() {
        int k = 4096;
        int u = 2 * k;
        int bytes = Sketches.getMaxUpdateSketchBytes((int)k);
        try (WritableDirectHandle wdh = WritableMemory.allocateDirect((long)(bytes / 2));){
            WritableMemory wmem = wdh.get();
            UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build(wmem);
            Assert.assertTrue((boolean)sketch.isSameResource((Memory)wmem));
            for (int i = 0; i < u; ++i) {
                sketch.update((long)i);
            }
            Assert.assertFalse((boolean)sketch.isSameResource((Memory)wmem));
        }
    }

    @Test
    public void checkReadOnlyRebuildResize() {
        int k = 4096;
        int u = 2 * k;
        int bytes = Sketches.getMaxUpdateSketchBytes((int)k);
        try (WritableDirectHandle wdh = WritableMemory.allocateDirect((long)(bytes / 2));){
            WritableMemory wmem = wdh.get();
            UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build(wmem);
            for (int i = 0; i < u; ++i) {
                sketch.update((long)i);
            }
            double est1 = sketch.getEstimate();
            byte[] ser = sketch.toByteArray();
            Memory mem = Memory.wrap((byte[])ser);
            UpdateSketch roSketch = (UpdateSketch)Sketches.wrapSketch((Memory)mem);
            double est2 = roSketch.getEstimate();
            Assert.assertEquals((Object)est2, (Object)est1);
            try {
                roSketch.rebuild();
                Assert.fail();
            }
            catch (SketchesReadOnlyException sketchesReadOnlyException) {
                // empty catch block
            }
            try {
                roSketch.reset();
                Assert.fail();
            }
            catch (SketchesReadOnlyException sketchesReadOnlyException) {
                // empty catch block
            }
        }
    }

    @Test
    public void printlnTest() {
        DirectQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    private static final int getMaxBytes(int k) {
        return (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
    }

    private static WritableDirectHandle makeNativeMemory(int k) {
        return WritableMemory.allocateDirect((long)DirectQuickSelectSketchTest.getMaxBytes(k));
    }
}

