/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesReadOnlyException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.IntersectionImpl;
import org.apache.datasketches.theta.IntersectionImplR;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectIntersectionTest {
    private static final int PREBYTES = 24;

    @Test
    public void checkExactIntersectionNoOverlap() {
        int i;
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < k / 2; ++i) {
            usk1.update((long)i);
        }
        for (i = k / 2; i < k; ++i) {
            usk2.update((long)i);
        }
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)usk1);
        inter.update((Sketch)usk2);
        long[] cache = inter.getCache();
        Assert.assertEquals((int)cache.length, (int)32);
        boolean ordered = true;
        Assert.assertTrue((boolean)inter.hasResult());
        CompactSketch rsk1 = inter.getResult(!ordered, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)0.0);
        rsk1 = inter.getResult(ordered, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)0.0);
        boolean compact = true;
        int bytes = rsk1.getCurrentBytes(compact);
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        rsk1 = inter.getResult(!ordered, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)0.0);
        rsk1 = inter.getResult(ordered, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)0.0);
    }

    @Test
    public void checkExactIntersectionFullOverlap() {
        int i;
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < k; ++i) {
            usk1.update((long)i);
        }
        for (i = 0; i < k; ++i) {
            usk2.update((long)i);
        }
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)usk1);
        inter.update((Sketch)usk2);
        boolean ordered = true;
        CompactSketch rsk1 = inter.getResult(!ordered, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)k);
        rsk1 = inter.getResult(ordered, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)k);
        boolean compact = true;
        int bytes = rsk1.getCurrentBytes(compact);
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        rsk1 = inter.getResult(!ordered, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)k);
        rsk1 = inter.getResult(ordered, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)k);
    }

    @Test
    public void checkIntersectionEarlyStop() {
        int i;
        int lgK = 10;
        int k = 1 << lgK;
        int u = 4 * k;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < u; ++i) {
            usk1.update((long)i);
        }
        for (i = u / 2; i < u + u / 2; ++i) {
            usk2.update((long)i);
        }
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)csk1);
        inter.update((Sketch)csk2);
        CompactSketch rsk1 = inter.getResult(true, null);
        DirectIntersectionTest.println("" + rsk1.getEstimate());
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkNoCall() {
        int lgK = 9;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        Assert.assertFalse((boolean)inter.hasResult());
        inter.getResult(false, null);
    }

    @Test
    public void check1stCall() {
        int lgK = 9;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update(null);
        CompactSketch rsk1 = inter.getResult(false, null);
        double est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        UpdateSketch sk = UpdateSketch.builder().setNominalEntries(k).build();
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk);
        rsk1 = inter.getResult(false, null);
        est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk = UpdateSketch.builder().setNominalEntries(k).build();
        sk.update(1L);
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk);
        rsk1 = inter.getResult(false, null);
        est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterNull() {
        int lgK = 9;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update(null);
        inter.update(null);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.update(null);
        UpdateSketch sk = UpdateSketch.builder().build();
        inter.update((Sketch)sk);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.update(null);
        sk = UpdateSketch.builder().build();
        sk.update(1L);
        inter.update((Sketch)sk);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterEmpty() {
        int lgK = 9;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().build();
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
        inter.update(null);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().build();
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(1L);
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterValid() {
        int lgK = 9;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
        inter.update(null);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().build();
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(1L);
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(2L);
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test
    public void checkEstimatingIntersect() {
        int i;
        int lgK = 9;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < 2 * k; ++i) {
            sk1.update((long)i);
        }
        DirectIntersectionTest.println("sk1: " + sk1.getEstimate());
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < 2 * k; ++i) {
            sk2.update((long)i);
        }
        DirectIntersectionTest.println("sk2: " + sk2.getEstimate());
        inter.update((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertTrue((est > (double)k ? 1 : 0) != 0);
        DirectIntersectionTest.println("Est: " + est);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkOverflow() {
        int lgK = 9;
        int k = 1 << lgK;
        int reqBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[reqBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(2 * k).build();
        for (int i = 0; i < 4 * k; ++i) {
            sk1.update((long)i);
        }
        DirectIntersectionTest.println("sk1est: " + sk1.getEstimate());
        DirectIntersectionTest.println("sk1cnt: " + sk1.getRetainedEntries(true));
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
    }

    @Test
    public void checkHeapify() {
        int i;
        int lgK = 9;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < 2 * k; ++i) {
            sk1.update((long)i);
        }
        DirectIntersectionTest.println("sk1: " + sk1.getEstimate());
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < 2 * k; ++i) {
            sk2.update((long)i);
        }
        DirectIntersectionTest.println("sk2: " + sk2.getEstimate());
        inter.update((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertTrue((est > (double)k ? 1 : 0) != 0);
        DirectIntersectionTest.println("Est: " + est);
        byte[] byteArray = inter.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArray);
        Intersection inter2 = (Intersection)SetOperation.heapify((Memory)mem);
        CompactSketch comp2 = inter2.getResult(false, null);
        double est2 = comp2.getEstimate();
        DirectIntersectionTest.println("Est2: " + est2);
    }

    @Test
    public void checkWrapNullEmpty() {
        int lgK = 5;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter1 = SetOperation.builder().buildIntersection(iMem);
        Intersection inter2 = Sketches.wrapIntersection((WritableMemory)iMem);
        Assert.assertFalse((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        inter1.update(null);
        inter2 = Sketches.wrapIntersection((WritableMemory)iMem);
        Assert.assertTrue((boolean)inter1.hasResult());
        Assert.assertTrue((boolean)inter2.hasResult());
        CompactSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertTrue((boolean)comp.isEmpty());
    }

    @Test
    public void checkWrapNullEmpty2() {
        int lgK = 5;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter1 = SetOperation.builder().buildIntersection(iMem);
        Intersection inter2 = Sketches.wrapIntersection((WritableMemory)iMem);
        Assert.assertFalse((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        UpdateSketch sk1 = UpdateSketch.builder().setP(0.005f).setFamily(Family.QUICKSELECT).setNominalEntries(k).build();
        sk1.update(1L);
        inter1.update((Sketch)sk1);
        inter2 = Sketches.wrapIntersection((WritableMemory)iMem);
        Assert.assertTrue((boolean)inter1.hasResult());
        Assert.assertTrue((boolean)inter2.hasResult());
        CompactSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertFalse((boolean)comp.isEmpty());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSizeLowerLimit() {
        int k = 8;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        SetOperation.builder().buildIntersection(iMem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSizedTooSmall() {
        int lgK = 5;
        int k = 1 << lgK;
        int u = 4 * k;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)(k / 2));
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk1.update((long)i);
        }
        CompactSketch csk1 = usk1.compact(true, null);
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)csk1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreambleLongs() {
        int k = 32;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter1 = SetOperation.builder().buildIntersection(iMem);
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putByte(0L, (byte)2);
        Sketches.wrapIntersection((WritableMemory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k = 32;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter1 = SetOperation.builder().buildIntersection(iMem);
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putByte(1L, (byte)2);
        Sketches.wrapIntersection((WritableMemory)mem);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void checkFamilyID() {
        int k = 32;
        Union union = SetOperation.builder().setNominalEntries(k).buildUnion();
        byte[] byteArray = union.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        Sketches.wrapIntersection((WritableMemory)mem);
    }

    @Test
    public void checkWrap() {
        int lgK = 9;
        int k = 1 << lgK;
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr1 = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr1);
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < 2 * k; ++i) {
            sk1.update((long)i);
        }
        CompactSketch compSkIn1 = sk1.compact(true, null);
        DirectIntersectionTest.println("compSkIn1: " + compSkIn1.getEstimate());
        Intersection inter = SetOperation.builder().buildIntersection(iMem);
        inter.update((Sketch)compSkIn1);
        byte[] memArr2 = inter.toByteArray();
        WritableMemory srcMem = WritableMemory.wrap((byte[])memArr2);
        Intersection inter2 = Sketches.wrapIntersection((WritableMemory)srcMem);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < 2 * k; ++i) {
            sk2.update((long)i);
        }
        CompactSketch compSkIn2 = sk2.compact(true, null);
        DirectIntersectionTest.println("sk2: " + compSkIn2.getEstimate());
        inter2.update((Sketch)compSkIn2);
        CompactSketch resultComp1 = inter2.getResult(false, null);
        double est = resultComp1.getEstimate();
        Assert.assertTrue((est > (double)k ? 1 : 0) != 0);
        DirectIntersectionTest.println("Est: " + est);
        byte[] memArr3 = inter2.toByteArray();
        WritableMemory srcMem2 = WritableMemory.wrap((byte[])memArr3);
        Intersection inter3 = Sketches.wrapIntersection((WritableMemory)srcMem2);
        CompactSketch resultComp2 = inter3.getResult(false, null);
        double est2 = resultComp2.getEstimate();
        DirectIntersectionTest.println("Est2: " + est2);
        inter.reset();
        inter2.reset();
        inter3.reset();
    }

    @Test
    public void checkDefaultMinSize() {
        int k = 32;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 8 + 24]);
        IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkExceptionMinSize() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 8 + 24]);
        IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
    }

    @Test
    public void checkGetResult() {
        int k = 1024;
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        int memBytes = SetOperation.getMaxIntersectionBytes((int)k);
        byte[] memArr = new byte[memBytes];
        WritableMemory iMem = WritableMemory.wrap((byte[])memArr);
        Intersection inter = Sketches.setOperationBuilder().buildIntersection(iMem);
        inter.update((Sketch)sk);
        CompactSketch csk = inter.getResult();
        Assert.assertEquals((int)csk.getCurrentBytes(true), (int)8);
    }

    @Test
    public void checkFamily() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 16 + 24]);
        IntersectionImpl impl = IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
        Assert.assertEquals((Object)impl.getFamily(), (Object)Family.INTERSECTION);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkExceptions1() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 16 + 24]);
        IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
        mem.putByte(1L, (byte)2);
        IntersectionImplR.wrapInstance((Memory)mem, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkExceptions2() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 16 + 24]);
        IntersectionImpl.initNewDirectInstance((long)9001L, (WritableMemory)mem);
        mem.setBits(5L, (byte)4);
        mem.putInt(8L, 2);
        IntersectionImplR.wrapInstance((Memory)mem, (long)9001L);
    }

    @Test
    public void checkOverlappedDirect() {
        int k = 16;
        int memBytes = 2 * k * 16 + 24;
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        UpdateSketch sk2 = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            sk1.update((long)i);
            sk2.update((long)(k - 2 + i));
        }
        WritableMemory memIn1 = WritableMemory.wrap((byte[])new byte[memBytes]);
        WritableMemory memIn2 = WritableMemory.wrap((byte[])new byte[memBytes]);
        WritableMemory memInter = WritableMemory.wrap((byte[])new byte[memBytes]);
        WritableMemory memComp = WritableMemory.wrap((byte[])new byte[memBytes]);
        CompactSketch csk1 = sk1.compact(true, memIn1);
        CompactSketch csk2 = sk2.compact(true, memIn2);
        Intersection inter = Sketches.setOperationBuilder().buildIntersection(memInter);
        inter.update((Sketch)csk1);
        inter.update((Sketch)csk2);
        CompactSketch cskOut = inter.getResult(true, memComp);
        Assert.assertEquals((double)cskOut.getEstimate(), (double)2.0, (double)0.0);
        Intersection interRO = (Intersection)SetOperation.wrap((Memory)memInter);
        try {
            interRO.intersect((Sketch)sk1, (Sketch)sk2);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            interRO.reset();
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        DirectIntersectionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

