/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Arrays;
import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.ConcurrentHeapQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapThetaBuffer;
import org.apache.datasketches.theta.ConcurrentPropagationService;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class ConcurrentHeapQuickSelectSketchTest {
    private int lgK;
    private long seed = 9001L;
    private volatile UpdateSketch shared;

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k = 512;
        this.lgK = 9;
        int u = k;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertEquals((double)local.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)u);
        byte[] serArr = this.shared.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])serArr);
        Sketch sk = Sketch.heapify((Memory)mem, (long)this.seed);
        Assert.assertTrue((boolean)(sk instanceof HeapQuickSelectSketch));
        mem.putByte(1L, (byte)0);
        Sketch.heapify((Memory)mem, (long)this.seed);
    }

    @Test
    public void checkPropagationNotOrdered() {
        int k = 256;
        this.lgK = 8;
        int u = 200 * k;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilderNotOrdered();
        Assert.assertFalse((1 << bldr.getLocalLgNominalEntries() == 0 ? 1 : 0) != 0);
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((this.shared.getRetainedEntries(false) <= u ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSketchID_UpdateSketch() {
        int k = 512;
        this.lgK = 9;
        int u = k;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        Assert.assertTrue((boolean)local.isEmpty());
        Assert.assertTrue((boolean)(this.shared instanceof ConcurrentHeapQuickSelectSketch));
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        Assert.assertTrue((boolean)this.shared.compact().isCompact());
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertEquals((double)local.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)u);
        byte[] byteArray = this.shared.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putByte(2L, (byte)0);
        Sketch.heapify((Memory)mem, (long)this.seed);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        this.lgK = 9;
        this.seed = 1021L;
        long seed2 = 9001L;
        this.buildSharedReturnLocalSketch();
        byte[] byteArray = this.shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])byteArray);
        Sketch.heapify((Memory)srcMem, (long)seed2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyCorruptLgNomLongs() {
        this.lgK = 4;
        this.buildSharedReturnLocalSketch();
        byte[] serArr = this.shared.toByteArray();
        WritableMemory srcMem = WritableMemory.wrap((byte[])serArr);
        srcMem.putByte(3L, (byte)2);
        Sketch.heapify((Memory)srcMem, (long)9001L);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void checkIllegalHashUpdate() {
        this.lgK = 4;
        this.buildSharedReturnLocalSketch();
        this.shared.hashUpdate(1L);
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int k = 512;
        this.lgK = 9;
        int u = k;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilder();
        UpdateSketch local = this.buildSharedReturnLocalSketch();
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        byte[] serArr = this.shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])serArr);
        UpdateSketch recoveredShared = Sketches.heapifyUpdateSketch((Memory)srcMem);
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        this.shared = bldr.buildSharedFromSketch(recoveredShared, wmem);
        UpdateSketch local2 = bldr.buildLocal(this.shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)u, (double)0.0);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)u, (double)0.0);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)false);
        Assert.assertEquals((Object)local2.getResizeFactor(), (Object)local.getResizeFactor());
        local2.toString(true, true, 8, true);
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int k = 4096;
        this.lgK = 12;
        int u = 2 * k;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilder();
        UpdateSketch local = this.buildSharedReturnLocalSketch();
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)true);
        byte[] serArr = this.shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])serArr);
        UpdateSketch recoveredShared = UpdateSketch.heapify((Memory)srcMem, (long)this.seed);
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        this.shared = bldr.buildSharedFromSketch(recoveredShared, wmem);
        UpdateSketch local2 = bldr.buildLocal(this.shared);
        Assert.assertEquals((Object)local2.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)local2.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)local2.getUpperBound(2), (Object)localUB);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)true);
        Assert.assertEquals((Object)local2.getResizeFactor(), (Object)local.getResizeFactor());
    }

    @Test
    public void checkHeapifyMemoryEstimating() {
        int k = 512;
        this.lgK = 9;
        int u = 2 * k;
        this.seed = 9001L;
        boolean estimating = u > k;
        UpdateSketchBuilder bldr = this.configureBuilder();
        UpdateSketch local = this.buildSharedReturnLocalSketch();
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
        Assert.assertFalse((boolean)local.isDirect());
        Assert.assertFalse((boolean)local.hasMemory());
        byte[] serArr = this.shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])serArr);
        UpdateSketch recoveredShared = UpdateSketch.heapify((Memory)srcMem, (long)9001L);
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        this.shared = bldr.buildSharedFromSketch(recoveredShared, wmem);
        UpdateSketch local2 = bldr.buildLocal(this.shared);
        Assert.assertEquals((Object)local2.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)local2.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)local2.getUpperBound(2), (Object)localUB);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)estimating);
    }

    @Test
    public void checkHQStoCompactForms() {
        int k = 512;
        this.lgK = 9;
        int u = 4 * k;
        boolean estimating = u > k;
        int maxBytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
        Assert.assertFalse((boolean)local.isDirect());
        Assert.assertFalse((boolean)local.hasMemory());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        this.shared.rebuild();
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        int localBytes = local.getCurrentBytes(false);
        int localCompBytes = local.getCurrentBytes(true);
        Assert.assertEquals((int)localBytes, (int)maxBytes);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
        CompactSketch comp1 = this.shared.compact(false, null);
        Assert.assertEquals((Object)comp1.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)comp1.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)comp1.getUpperBound(2), (Object)localUB);
        Assert.assertEquals((boolean)comp1.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp1.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp1.getCurrentBytes(true), (int)localCompBytes);
        Assert.assertEquals((String)comp1.getClass().getSimpleName(), (String)"HeapCompactUnorderedSketch");
        CompactSketch comp2 = this.shared.compact(true, null);
        Assert.assertEquals((Object)comp2.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)comp2.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)comp2.getUpperBound(2), (Object)localUB);
        Assert.assertEquals((boolean)comp2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp2.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp2.getCurrentBytes(true), (int)localCompBytes);
        Assert.assertEquals((String)comp2.getClass().getSimpleName(), (String)"HeapCompactOrderedSketch");
        byte[] memArr2 = new byte[localCompBytes];
        WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
        CompactSketch comp3 = this.shared.compact(false, mem2);
        Assert.assertEquals((Object)comp3.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)comp3.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)comp3.getUpperBound(2), (Object)localUB);
        Assert.assertEquals((boolean)comp3.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp3.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp3.getCurrentBytes(true), (int)localCompBytes);
        Assert.assertEquals((String)comp3.getClass().getSimpleName(), (String)"DirectCompactUnorderedSketch");
        mem2.clear();
        CompactSketch comp4 = this.shared.compact(true, mem2);
        Assert.assertEquals((Object)comp4.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)comp4.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)comp4.getUpperBound(2), (Object)localUB);
        Assert.assertEquals((boolean)comp4.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp4.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp4.getCurrentBytes(true), (int)localCompBytes);
        Assert.assertEquals((String)comp4.getClass().getSimpleName(), (String)"DirectCompactOrderedSketch");
        comp4.toString(false, true, 0, false);
    }

    @Test
    public void checkHQStoCompactEmptyForms() {
        this.lgK = 9;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        ConcurrentHeapQuickSelectSketchTest.println("lgArr: " + local.getLgArrLongs());
        local.toString(false, true, 0, false);
        boolean estimating = false;
        Assert.assertTrue((boolean)(local instanceof ConcurrentHeapThetaBuffer));
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        int compBytes = local.getCurrentBytes(true);
        Assert.assertEquals((int)compBytes, (int)8);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
        byte[] arr2 = new byte[compBytes];
        WritableMemory mem2 = WritableMemory.wrap((byte[])arr2);
        CompactSketch csk2 = this.shared.compact(false, mem2);
        Assert.assertEquals((Object)csk2.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)csk2.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)csk2.getUpperBound(2), (Object)localUB);
        Assert.assertEquals((boolean)csk2.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk2.isEstimationMode(), (boolean)estimating);
        Assert.assertTrue((boolean)(csk2 instanceof EmptyCompactSketch));
        CompactSketch csk3 = this.shared.compact(true, mem2);
        csk3.toString(false, true, 0, false);
        csk3.toString();
        Assert.assertEquals((Object)csk3.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)csk3.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)csk3.getUpperBound(2), (Object)localUB);
        Assert.assertEquals((boolean)csk3.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk3.isEstimationMode(), (boolean)estimating);
        Assert.assertTrue((boolean)(csk3 instanceof EmptyCompactSketch));
    }

    @Test
    public void checkExactMode() {
        this.lgK = 12;
        int u = 4096;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        Assert.assertEquals((double)local.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)u);
    }

    @Test
    public void checkEstMode() {
        int k = 4096;
        this.lgK = 12;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 3 * k;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        int retained = this.shared.getRetainedEntries(false);
        Assert.assertTrue((retained > k ? 1 : 0) != 0);
    }

    @Test
    public void checkErrorBounds() {
        int k = 512;
        this.lgK = 12;
        this.seed = 9001L;
        UpdateSketch local = this.buildSharedReturnLocalSketch();
        int limit = (int)ConcurrentSharedThetaSketch.computeExactLimit((long)k, (double)0.0);
        for (int i = 0; i < limit; ++i) {
            local.update((long)i);
        }
        double est = local.getEstimate();
        double lb = local.getLowerBound(2);
        double ub = local.getUpperBound(2);
        Assert.assertEquals((double)est, (double)ub, (double)0.0);
        Assert.assertEquals((double)est, (double)lb, (double)0.0);
        int u = 10 * k;
        for (int i = limit; i < u; ++i) {
            local.update((long)i);
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        est = local.getEstimate();
        lb = local.getLowerBound(2);
        ub = local.getUpperBound(2);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertTrue((est >= lb ? 1 : 0) != 0);
    }

    @Test
    public void checkRebuild() {
        int k = 16;
        this.lgK = 4;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        Assert.assertTrue((boolean)local.isEmpty());
        int t = ((ConcurrentHeapThetaBuffer)local).getHashTableThreshold();
        for (int i = 0; i < t; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.shared.getRetainedEntries(false) > k ? 1 : 0) != 0);
        this.shared.rebuild();
        Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)this.shared.getRetainedEntries(true), (int)k);
        this.shared.rebuild();
        Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)this.shared.getRetainedEntries(true), (int)k);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkBuilder() {
        this.lgK = 4;
        this.seed = 9001L;
        UpdateSketchBuilder bldr = this.configureBuilderWithNominal();
        Assert.assertEquals((int)bldr.getLocalLgNominalEntries(), (int)this.lgK);
        Assert.assertEquals((int)bldr.getLgNominalEntries(), (int)this.lgK);
        ConcurrentHeapQuickSelectSketchTest.println(bldr.toString());
        bldr.buildLocal(this.shared);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderSmallLgNominal() {
        this.lgK = 1;
        this.seed = 9001L;
        this.configureBuilder();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderSmallNominal() {
        this.lgK = 2;
        this.seed = 9001L;
        this.configureBuilderWithNominal();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNegativeHashes() {
        this.lgK = 9;
        UpdateSketch qs = this.buildSharedReturnLocalSketch();
        qs.hashUpdate(-1L);
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int k = 512;
        this.lgK = 9;
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared();
        UpdateSketch local = bldr.buildLocal(this.shared);
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 3 * k;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((this.shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
        Assert.assertTrue((local.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0);
        this.shared.reset();
        local.reset();
        Assert.assertTrue((boolean)local.isEmpty());
        Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)0);
        Assert.assertEquals((double)local.getEstimate(), (double)0.0, (double)0.0);
        Assert.assertEquals((long)local.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void checkDQStoCompactEmptyForms() {
        this.lgK = 9;
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        local.toString(false, true, 0, false);
        Assert.assertTrue((boolean)(local instanceof ConcurrentHeapThetaBuffer));
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double uskUB = local.getUpperBound(2);
        Assert.assertFalse((boolean)local.isEstimationMode());
        int bytes = local.getCurrentBytes(true);
        Assert.assertEquals((int)bytes, (int)8);
        byte[] memArr2 = new byte[bytes];
        WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
        CompactSketch csk2 = this.shared.compact(false, mem2);
        Assert.assertEquals((Object)csk2.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)csk2.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)csk2.getUpperBound(2), (Object)uskUB);
        Assert.assertTrue((boolean)csk2.isEmpty());
        Assert.assertFalse((boolean)csk2.isEstimationMode());
        Assert.assertTrue((boolean)(csk2 instanceof EmptyCompactSketch));
        CompactSketch csk3 = this.shared.compact(true, mem2);
        csk3.toString(false, true, 0, false);
        csk3.toString();
        Assert.assertEquals((Object)csk3.getEstimate(), (Object)localEst);
        Assert.assertEquals((Object)csk3.getLowerBound(2), (Object)localLB);
        Assert.assertEquals((Object)csk3.getUpperBound(2), (Object)uskUB);
        Assert.assertTrue((boolean)csk3.isEmpty());
        Assert.assertFalse((boolean)csk3.isEstimationMode());
        Assert.assertTrue((boolean)(csk2 instanceof EmptyCompactSketch));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMinReqBytes() {
        int k = 16;
        this.lgK = 4;
        UpdateSketch local = this.buildSharedReturnLocalSketch();
        for (int i = 0; i < 4 * k; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        byte[] byteArray = this.shared.toByteArray();
        byte[] badBytes = Arrays.copyOfRange(byteArray, 0, 24);
        Memory mem = Memory.wrap((byte[])badBytes);
        Sketch.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkThetaAndLgArrLongs() {
        int k = 16;
        this.lgK = 4;
        UpdateSketch local = this.buildSharedReturnLocalSketch();
        for (int i = 0; i < k; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        byte[] badArray = this.shared.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])badArray);
        PreambleUtil.insertLgArrLongs((WritableMemory)mem, (int)4);
        PreambleUtil.insertThetaLong((WritableMemory)mem, (long)0x3FFFFFFFFFFFFFFFL);
        Sketch.heapify((Memory)mem);
    }

    @Test
    public void checkFamily() {
        UpdateSketch local = this.buildSharedReturnLocalSketch();
        Assert.assertEquals((Object)local.getFamily(), (Object)Family.QUICKSELECT);
    }

    @Test
    public void checkBackgroundPropagation() {
        int i;
        int k = 16;
        this.lgK = 4;
        int u = 5 * k;
        UpdateSketchBuilder bldr = this.configureBuilderWithCache();
        this.shared = bldr.buildShared(null);
        UpdateSketch local = bldr.buildLocal(this.shared);
        Assert.assertTrue((boolean)local.isEmpty());
        for (i = 0; i < k; ++i) {
            local.update((long)i);
        }
        this.waitForBgPropagationToComplete();
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
        long theta1 = ((ConcurrentHeapQuickSelectSketch)this.shared).getVolatileTheta();
        while (i < u) {
            local.update((long)i);
            ++i;
        }
        this.waitForBgPropagationToComplete();
        long theta2 = ((ConcurrentHeapQuickSelectSketch)this.shared).getVolatileTheta();
        int entries = this.shared.getRetainedEntries(false);
        Assert.assertTrue((entries > k || theta2 < theta1 ? 1 : 0) != 0, (String)("entries= " + entries + " k= " + k + " theta1= " + theta1 + " theta2= " + theta2));
        this.shared.rebuild();
        Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)this.shared.getRetainedEntries(true), (int)k);
        local.rebuild();
        Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)this.shared.getRetainedEntries(true), (int)k);
    }

    @Test
    public void checkBuilderExceptions() {
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        try {
            bldr.setNominalEntries(8);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            bldr.setLocalNominalEntries(8);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            bldr.setLocalLogNominalEntries(3);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        bldr.setNumPoolThreads(4);
        Assert.assertEquals((int)bldr.getNumPoolThreads(), (int)4);
        bldr.setMaxConcurrencyError(0.04);
        Assert.assertEquals((Object)bldr.getMaxConcurrencyError(), (Object)0.04);
        bldr.setMaxNumLocalThreads(4);
        Assert.assertEquals((int)bldr.getMaxNumLocalThreads(), (int)4);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void checkToByteArray() {
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        UpdateSketch shared = bldr.buildShared();
        UpdateSketch local = bldr.buildLocal(shared);
        local.toByteArray();
    }

    @Test
    public void printlnTest() {
        ConcurrentHeapQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    @AfterMethod
    public void clearShared() {
        this.shared = null;
    }

    static void println(String s) {
    }

    private UpdateSketch buildSharedReturnLocalSketch() {
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(null);
        return bldr.buildLocal(this.shared);
    }

    private UpdateSketchBuilder configureBuilder() {
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        bldr.setLogNominalEntries(this.lgK);
        bldr.setLocalLogNominalEntries(this.lgK);
        bldr.setSeed(this.seed);
        return bldr;
    }

    private UpdateSketchBuilder configureBuilderNotOrdered() {
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        bldr.setLogNominalEntries(this.lgK);
        bldr.setLocalLogNominalEntries(4);
        bldr.setSeed(this.seed);
        bldr.setPropagateOrderedCompact(false);
        return bldr;
    }

    private UpdateSketchBuilder configureBuilderWithNominal() {
        UpdateSketchBuilder bldr = this.configureBuilder();
        int k = 1 << this.lgK;
        bldr.setLocalNominalEntries(k);
        bldr.setNominalEntries(k);
        Assert.assertTrue((boolean)bldr.getPropagateOrderedCompact());
        Assert.assertEquals((long)bldr.getSeed(), (long)9001L);
        return bldr;
    }

    private UpdateSketchBuilder configureBuilderWithCache() {
        UpdateSketchBuilder bldr = this.configureBuilder();
        return bldr;
    }

    private void waitForBgPropagationToComplete() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ((ConcurrentHeapQuickSelectSketch)this.shared).awaitBgPropagationTermination();
        ConcurrentPropagationService.resetExecutorService((long)Thread.currentThread().getId());
        ((ConcurrentHeapQuickSelectSketch)this.shared).initBgPropagationService();
    }
}

