/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.quantiles.DoublesArrayAccessor;
import org.apache.datasketches.quantiles.DoublesAuxiliary;
import org.apache.datasketches.quantiles.DoublesBufferAccessor;
import org.apache.datasketches.quantiles.DoublesPmfCdfImpl;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantiles.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UtilTest {
    @Test
    public void checkCombBufItemCapacity() {
        int k = 227;
        int capEl = Util.computeCombinedBufferItemCapacity((int)k, (long)0L);
        Assert.assertEquals((int)capEl, (int)4);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPreLongsFlagsCap() {
        Util.checkPreLongsFlagsCap((int)2, (int)0, (long)15L);
    }

    @Test
    public void checkLg() {
        int lgbase2 = (int)Util.lg((double)4096.0);
        Assert.assertEquals((int)lgbase2, (int)12);
    }

    @Test
    public void checkHiBitPos() {
        int bitPos = Util.hiBitPos((long)4096L);
        Assert.assertEquals((int)bitPos, (int)12);
    }

    @Test
    public void checkNumValidLevels() {
        long v = 0xFFFFFFFFL;
        int ones = Util.computeValidLevels((long)v);
        Assert.assertEquals((int)ones, (int)32);
    }

    @Test
    public void testPositionOfLowestZeroBitStartingAt() {
        int[] answers = new int[]{9, 8, 7, 7, 7, 4, 4, 4, 1, 1};
        long v = 109L;
        int i = 0;
        int j = 9;
        while (i < 10) {
            int result = Util.lowestZeroBitStartingAt((long)v, (int)i);
            Assert.assertTrue((answers[j] == result ? 1 : 0) != 0);
            ++i;
            --j;
        }
    }

    @Test
    public void testPositionOfLowestZeroBitStartingAt2() {
        long bits = -1L;
        int startingBit = 70;
        int result = Util.lowestZeroBitStartingAt((long)bits, (int)startingBit);
        Assert.assertEquals((int)result, (int)64);
    }

    @Test
    public void testQuadraticTimeIncrementHistogramCounters() {
        int j;
        double[] samples = new double[]{0.1, 0.2, 0.3, 0.4, 0.5};
        DoublesArrayAccessor accessor = DoublesArrayAccessor.wrap((double[])samples);
        double[] splitPoints = new double[]{0.25, 0.4};
        double[] counters = new double[]{0.0, 0.0, 0.0};
        long[] answers = new long[]{200L, 100L, 200L};
        DoublesPmfCdfImpl.bilinearTimeIncrementHistogramCounters((DoublesBufferAccessor)accessor, (long)100L, (double[])splitPoints, (double[])counters);
        for (j = 0; j < counters.length; ++j) {
            Assert.assertEquals((double)counters[j], (double)answers[j], (double)1.0E-5);
        }
        splitPoints = new double[]{0.01, 0.02};
        counters = new double[]{0.0, 0.0, 0.0};
        answers = new long[]{0L, 0L, 500L};
        DoublesPmfCdfImpl.bilinearTimeIncrementHistogramCounters((DoublesBufferAccessor)accessor, (long)100L, (double[])splitPoints, (double[])counters);
        for (j = 0; j < counters.length; ++j) {
            Assert.assertEquals((double)counters[j], (double)answers[j], (double)1.0E-5);
        }
        splitPoints = new double[]{0.8, 0.9};
        counters = new double[]{0.0, 0.0, 0.0};
        answers = new long[]{500L, 0L, 0L};
        DoublesPmfCdfImpl.bilinearTimeIncrementHistogramCounters((DoublesBufferAccessor)accessor, (long)100L, (double[])splitPoints, (double[])counters);
        for (j = 0; j < counters.length; ++j) {
            Assert.assertEquals((double)counters[j], (double)answers[j], (double)1.0E-5);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkValidateValuesNullException() {
        Util.checkSplitPointsOrder(null);
    }

    @Test
    public void testLinearTimeIncrementHistogramCounters() {
        int j;
        double[] samples = new double[]{0.1, 0.2, 0.3, 0.4, 0.5};
        DoublesArrayAccessor accessor = DoublesArrayAccessor.wrap((double[])samples);
        double[] splitPoints = new double[]{0.25, 0.4};
        double[] counters = new double[]{0.0, 0.0, 0.0};
        long[] answers = new long[]{200L, 100L, 200L};
        DoublesPmfCdfImpl.linearTimeIncrementHistogramCounters((DoublesBufferAccessor)accessor, (long)100L, (double[])splitPoints, (double[])counters);
        for (j = 0; j < counters.length; ++j) {
            Assert.assertEquals((double)counters[j], (double)answers[j], (double)1.0E-5);
        }
        splitPoints = new double[]{0.01, 0.02};
        counters = new double[]{0.0, 0.0, 0.0};
        answers = new long[]{0L, 0L, 500L};
        DoublesPmfCdfImpl.linearTimeIncrementHistogramCounters((DoublesBufferAccessor)accessor, (long)100L, (double[])splitPoints, (double[])counters);
        for (j = 0; j < counters.length; ++j) {
            Assert.assertEquals((double)counters[j], (double)answers[j], (double)1.0E-5);
        }
        splitPoints = new double[]{0.8, 0.9};
        counters = new double[]{0.0, 0.0, 0.0};
        answers = new long[]{500L, 0L, 0L};
        DoublesPmfCdfImpl.linearTimeIncrementHistogramCounters((DoublesBufferAccessor)accessor, (long)100L, (double[])splitPoints, (double[])counters);
        for (j = 0; j < counters.length; ++j) {
            Assert.assertEquals((double)counters[j], (double)answers[j], (double)1.0E-5);
        }
    }

    private static void assertMergeTestPrecondition(double[] arr, long[] brr, int arrLen, int blkSize) {
        int i;
        int violationsCount = 0;
        for (i = 0; i < arrLen - 1; ++i) {
            if ((i + 1) % blkSize == 0 || !(arr[i] > arr[i + 1])) continue;
            ++violationsCount;
        }
        for (i = 0; i < arrLen; ++i) {
            if (brr[i] == (long)(1.0E12 * (1.0 - arr[i]))) continue;
            ++violationsCount;
        }
        if (brr[arrLen] != 0L) {
            ++violationsCount;
        }
        Assert.assertEquals((int)violationsCount, (int)0);
    }

    private static void assertMergeTestPostcondition(double[] arr, long[] brr, int arrLen) {
        int i;
        int violationsCount = 0;
        for (i = 0; i < arrLen - 1; ++i) {
            if (!(arr[i] > arr[i + 1])) continue;
            ++violationsCount;
        }
        for (i = 0; i < arrLen; ++i) {
            if (brr[i] == (long)(1.0E12 * (1.0 - arr[i]))) continue;
            ++violationsCount;
        }
        if (brr[arrLen] != 0L) {
            ++violationsCount;
        }
        Assert.assertEquals((int)violationsCount, (int)0);
    }

    private static double[] makeMergeTestInput(int arrLen, int blkSize) {
        double[] arr = new double[arrLen];
        double pick = Math.random();
        for (int i = 0; i < arrLen; ++i) {
            int denom;
            int j;
            if (pick < 0.01) {
                arr[i] = 0.3;
                continue;
            }
            if (pick < 0.02) {
                j = i + 1;
                denom = arrLen + 1;
                arr[i] = (double)j / (double)denom;
                continue;
            }
            if (pick < 0.03) {
                j = i + 1;
                denom = arrLen + 1;
                arr[i] = 1.0 - (double)j / (double)denom;
                continue;
            }
            arr[i] = Math.random();
        }
        for (int start = 0; start < arrLen; start += blkSize) {
            Arrays.sort(arr, start, Math.min(arrLen, start + blkSize));
        }
        return arr;
    }

    private static long[] makeTheTandemArray(double[] arr) {
        long[] brr = new long[arr.length + 1];
        for (int i = 0; i < arr.length; ++i) {
            brr[i] = (long)(1.0E12 * (1.0 - arr[i]));
        }
        brr[arr.length] = 0L;
        return brr;
    }

    @Test
    public void checkBlockyTandemMergeSort() {
        UtilTest.testBlockyTandemMergeSort(10, 50);
    }

    private static void testBlockyTandemMergeSort(int numTries, int maxArrLen) {
        int arrLen = 0;
        double[] arr = null;
        for (arrLen = 0; arrLen <= maxArrLen; ++arrLen) {
            for (int blkSize = 1; blkSize <= arrLen + 100; ++blkSize) {
                for (int tryno = 1; tryno <= numTries; ++tryno) {
                    arr = UtilTest.makeMergeTestInput(arrLen, blkSize);
                    long[] brr = UtilTest.makeTheTandemArray(arr);
                    UtilTest.assertMergeTestPrecondition(arr, brr, arrLen, blkSize);
                    DoublesAuxiliary.blockyTandemMergeSort((double[])arr, (long[])brr, (int)arrLen, (int)blkSize);
                    for (int i = 0; i < arrLen - 1; ++i) {
                        assert (arr[i] <= arr[i + 1]);
                    }
                    UtilTest.assertMergeTestPostcondition(arr, brr, arrLen);
                }
            }
        }
    }

    @Test
    public void checkKomologorovSmirnovStatistic1() {
        int k = 256;
        UpdateDoublesSketch s1 = DoublesSketch.builder().setK(256).build();
        UpdateDoublesSketch s2 = DoublesSketch.builder().setK(256).build();
        Random rand = new Random();
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 100.0);
            s2.update(x);
        }
        Assert.assertEquals((double)Util.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2), (double)1.0, (double)1.000001);
    }

    @Test
    public void checkKomologorovSmirnovStatistic2() {
        int k = 256;
        UpdateDoublesSketch s1 = DoublesSketch.builder().setK(256).build();
        UpdateDoublesSketch s2 = DoublesSketch.builder().setK(256).build();
        Random rand = new Random();
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x);
            s2.update(x);
        }
        Assert.assertEquals((double)Util.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2), (double)0.0, (double)0.01);
    }

    @Test
    public void checkKomologorovSmirnovStatistic3() {
        int k = 2048;
        UpdateDoublesSketch s1 = DoublesSketch.builder().setK(2048).build();
        UpdateDoublesSketch s2 = DoublesSketch.builder().setK(2048).build();
        double tgtPvalue = 0.05;
        Random rand = new Random();
        int n = 6143;
        for (int i = 0; i < 6143; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 0.05);
            s2.update(x);
        }
        double D = Util.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2);
        double thresh = Util.computeKSThreshold((DoublesSketch)s1, (DoublesSketch)s2, (double)0.05);
        boolean reject = Util.kolmogorovSmirnovTest((DoublesSketch)s1, (DoublesSketch)s2, (double)0.05);
        UtilTest.println("pVal = 0.05\nK = 2048\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject);
        Assert.assertFalse((boolean)reject);
    }

    @Test
    public void checkKomologorovSmirnovStatistic4() {
        int k = 8192;
        UpdateDoublesSketch s1 = DoublesSketch.builder().setK(8192).build();
        UpdateDoublesSketch s2 = DoublesSketch.builder().setK(8192).build();
        double tgtPvalue = 0.05;
        Random rand = new Random();
        int n = 24575;
        for (int i = 0; i < 24575; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 0.05);
            s2.update(x);
        }
        double D = Util.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2);
        double thresh = Util.computeKSThreshold((DoublesSketch)s1, (DoublesSketch)s2, (double)0.05);
        boolean reject = Util.kolmogorovSmirnovTest((DoublesSketch)s1, (DoublesSketch)s2, (double)0.05);
        UtilTest.println("pVal = 0.05\nK = 8192\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject);
        Assert.assertTrue((boolean)reject);
    }

    @Test
    public void printlnTest() {
        UtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

