/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hllmap;

import org.apache.datasketches.Util;
import org.apache.datasketches.hllmap.HllMap;
import org.apache.datasketches.hllmap.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HllMapTest {
    @Test
    public void singleKeyTest() {
        int k = 1024;
        int u = 1000;
        int keySize = 4;
        HllMap map = HllMap.getInstance((int)keySize, (int)k);
        Assert.assertTrue((boolean)Double.isNaN(map.getEstimate(null)));
        Assert.assertTrue((map.getEntrySizeBytes() > 800.0 ? 1 : 0) != 0);
        Assert.assertEquals((int)map.getCapacityEntries(), (int)147);
        Assert.assertEquals((int)map.getTableEntries(), (int)157);
        Assert.assertTrue((map.getMemoryUsageBytes() < 140000L ? 1 : 0) != 0);
        byte[] key = new byte[4];
        byte[] id = new byte[4];
        key = Util.intToBytes((int)1, (byte[])key);
        for (int i = 1; i <= u; ++i) {
            id = Util.intToBytes((int)i, (byte[])id);
            short coupon = (short)Map.coupon16((byte[])id);
            double est = map.update(key, coupon);
            if (i % 100 != 0) continue;
            double err = (est / (double)i - 1.0) * 100.0;
            String eStr = String.format("%.3f%%", err);
            HllMapTest.println("i: " + i + "\t Est: " + est + "\t" + eStr);
        }
        byte[] key2 = Util.intToBytes((int)2, (byte[])key);
        Assert.assertEquals((Object)map.getEstimate(key2), (Object)0.0);
        Assert.assertEquals((int)map.getKeySizeBytes(), (int)4);
        Assert.assertEquals((int)map.getCurrentCountEntries(), (int)1);
    }

    @Test
    public void resizeTest() {
        String eStr;
        double err;
        double est;
        int j;
        int k = 1024;
        int u = 257;
        int keys = 200;
        int keySize = 4;
        long v = 0L;
        HllMap map = HllMap.getInstance((int)keySize, (int)k);
        Assert.assertTrue((map.getEntrySizeBytes() > 800.0 ? 1 : 0) != 0);
        Assert.assertEquals((int)map.getCapacityEntries(), (int)147);
        Assert.assertEquals((int)map.getTableEntries(), (int)157);
        Assert.assertTrue((map.getMemoryUsageBytes() < 140000L ? 1 : 0) != 0);
        byte[] key = new byte[4];
        byte[] id = new byte[8];
        for (j = 1; j <= keys; ++j) {
            key = Util.intToBytes((int)j, (byte[])key);
            for (int i = 0; i < u; ++i) {
                id = Util.longToBytes((long)(++v), (byte[])id);
                short coupon = (short)Map.coupon16((byte[])id);
                map.update(key, coupon);
            }
            est = map.getEstimate(key);
            Assert.assertTrue((map.getUpperBound(key) > est ? 1 : 0) != 0);
            Assert.assertTrue((map.getLowerBound(key) < est ? 1 : 0) != 0);
            err = (est / (double)u - 1.0) * 100.0;
            eStr = String.format("%.3f%%", err);
            HllMapTest.println("key: " + j + "\tu: " + u + "\t Est: " + est + "\t" + eStr);
        }
        Assert.assertEquals((int)317, (int)map.getTableEntries());
        Assert.assertEquals((int)200, (int)map.getCurrentCountEntries());
        for (j = 1; j <= keys; ++j) {
            key = Util.intToBytes((int)j, (byte[])key);
            est = map.getEstimate(key);
            err = (est / (double)u - 1.0) * 100.0;
            eStr = String.format("%.3f%%", err);
            HllMapTest.println("key: " + j + "\tu: " + u + "\t Est: " + est + "\t" + eStr);
        }
    }

    @Test
    public void printlnTest() {
        HllMapTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

