/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hllmap;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.hllmap.CouponTraverseMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CouponTraverseMapTest {
    @Test
    public void getEstimateNoEntry() {
        CouponTraverseMap map = CouponTraverseMap.getInstance((int)4, (int)1);
        byte[] key = new byte[]{0, 0, 0, 0};
        Assert.assertEquals((Object)map.getEstimate(key), (Object)0.0);
        Assert.assertEquals((Object)map.getUpperBound(key), (Object)0.0);
        Assert.assertEquals((Object)map.getLowerBound(key), (Object)0.0);
    }

    @Test
    public void oneKeyOneEntry() {
        CouponTraverseMap map = CouponTraverseMap.getInstance((int)4, (int)1);
        byte[] key = new byte[]{0, 0, 0, 0};
        double estimate = map.update(key, (short)1);
        Assert.assertEquals((Object)estimate, (Object)1.0);
        Assert.assertEquals((Object)map.getEstimate(key), (Object)1.0);
        Assert.assertTrue((map.getUpperBound(key) >= 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((map.getLowerBound(key) <= 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void delete() {
        CouponTraverseMap map = CouponTraverseMap.getInstance((int)4, (int)1);
        double estimate = map.update("1234".getBytes(StandardCharsets.UTF_8), (short)1);
        Assert.assertEquals((Object)estimate, (Object)1.0);
        int index1 = map.findKey("1234".getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((index1 >= 0 ? 1 : 0) != 0);
        map.deleteKey(index1);
        int index2 = map.findKey("1234".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((int)(~index2), (int)index1);
        Assert.assertEquals((Object)map.getEstimate("1".getBytes(StandardCharsets.UTF_8)), (Object)0.0);
    }

    @Test
    public void growAndShrink() {
        CouponTraverseMap map = CouponTraverseMap.getInstance((int)4, (int)1);
        long sizeBytes1 = map.getMemoryUsageBytes();
        for (int i = 0; i < 1000; ++i) {
            byte[] key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            map.update(key, (short)1);
        }
        long sizeBytes2 = map.getMemoryUsageBytes();
        Assert.assertTrue((sizeBytes2 > sizeBytes1 ? 1 : 0) != 0);
        for (int i = 0; i < 1000; ++i) {
            byte[] key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            int index = map.findKey(key);
            Assert.assertTrue((index >= 0 ? 1 : 0) != 0);
            map.deleteKey(index);
        }
        long sizeBytes3 = map.getMemoryUsageBytes();
        Assert.assertTrue((sizeBytes3 < sizeBytes2 ? 1 : 0) != 0);
        CouponTraverseMapTest.println(map.toString());
    }

    @Test
    public void printlnTest() {
        CouponTraverseMapTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

