/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hash;

import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.hash.MurmurHash3v2;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MurmurHash3v2Test {
    @Test
    public void offsetChecks() {
        long seed = 12345L;
        int blocks = 6;
        int cap = blocks * 16;
        long[] hash1 = new long[2];
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        for (int i = 0; i < cap; ++i) {
            wmem.putByte((long)i, (byte)(-128 + i));
        }
        for (int offset = 0; offset < 16; ++offset) {
            int arrLen = cap - offset;
            hash1 = MurmurHash3v2.hash((Memory)wmem, (long)offset, (long)arrLen, (long)seed, (long[])hash1);
            byte[] byteArr2 = new byte[arrLen];
            wmem.getByteArray((long)offset, byteArr2, 0, arrLen);
            long[] hash2 = MurmurHash3.hash((byte[])byteArr2, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
        }
    }

    @Test
    public void byteArrChecks() {
        long seed = 0L;
        int offset = 0;
        int bytes = 1024;
        long[] hash2 = new long[2];
        for (int j = 1; j < bytes; ++j) {
            byte[] in = new byte[bytes];
            WritableMemory wmem = WritableMemory.wrap((byte[])in);
            for (int i = 0; i < j; ++i) {
                wmem.putByte((long)i, (byte)(-128 + i));
            }
            long[] hash1 = MurmurHash3.hash((byte[])in, (long)0L);
            hash2 = MurmurHash3v2.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
            long[] hash3 = MurmurHash3v2.hash((byte[])in, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void charArrChecks() {
        long seed = 0L;
        int offset = 0;
        int chars = 16;
        int bytes = chars << 1;
        long[] hash2 = new long[2];
        for (int j = 1; j < chars; ++j) {
            char[] in = new char[chars];
            WritableMemory wmem = WritableMemory.wrap((char[])in);
            for (int i = 0; i < j; ++i) {
                wmem.putInt((long)i, i);
            }
            long[] hash1 = MurmurHash3.hash((char[])in, (long)0L);
            hash2 = MurmurHash3v2.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
            long[] hash3 = MurmurHash3v2.hash((char[])in, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void intArrChecks() {
        long seed = 0L;
        int offset = 0;
        int ints = 16;
        int bytes = ints << 2;
        long[] hash2 = new long[2];
        for (int j = 1; j < ints; ++j) {
            int[] in = new int[ints];
            WritableMemory wmem = WritableMemory.wrap((int[])in);
            for (int i = 0; i < j; ++i) {
                wmem.putInt((long)i, i);
            }
            long[] hash1 = MurmurHash3.hash((int[])in, (long)0L);
            hash2 = MurmurHash3v2.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
            long[] hash3 = MurmurHash3v2.hash((int[])in, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void longArrChecks() {
        long seed = 0L;
        int offset = 0;
        int longs = 16;
        int bytes = longs << 3;
        long[] hash2 = new long[2];
        for (int j = 1; j < longs; ++j) {
            long[] in = new long[longs];
            WritableMemory wmem = WritableMemory.wrap((long[])in);
            for (int i = 0; i < j; ++i) {
                wmem.putLong((long)i, (long)i);
            }
            long[] hash1 = MurmurHash3.hash((long[])in, (long)0L);
            hash2 = MurmurHash3v2.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
            long[] hash3 = MurmurHash3v2.hash((long[])in, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void longCheck() {
        long seed = 0L;
        int offset = 0;
        int bytes = 8;
        long[] hash2 = new long[2];
        long[] in = new long[]{1L};
        WritableMemory wmem = WritableMemory.wrap((long[])in);
        long[] hash1 = MurmurHash3.hash((long[])in, (long)0L);
        hash2 = MurmurHash3v2.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
        long[] hash3 = MurmurHash3v2.hash((long[])in, (long)seed);
        Assert.assertEquals((long[])hash1, (long[])hash2);
        Assert.assertEquals((long[])hash1, (long[])hash3);
    }

    @Test
    public void checkEmptiesNulls() {
        long seed = 123L;
        long[] hashOut = new long[2];
        Memory mem = Memory.wrap((long[])new long[0]);
        long hash0 = MurmurHash3v2.hash((Memory)mem, (long)0L, (long)0L, (long)seed, (long[])hashOut)[0];
        mem = null;
        Assert.assertEquals((long)MurmurHash3v2.hash((Memory)mem, (long)0L, (long)0L, (long)seed, (long[])hashOut)[0], (long)hash0);
        String s = "";
        Assert.assertEquals((long)MurmurHash3v2.hash((String)s, (long)seed, (long[])hashOut)[0], (long)hash0);
        s = null;
        Assert.assertEquals((long)MurmurHash3v2.hash((String)s, (long)seed, (long[])hashOut)[0], (long)hash0);
        byte[] barr = new byte[]{};
        Assert.assertEquals((long)MurmurHash3v2.hash((byte[])barr, (long)seed)[0], (long)hash0);
        barr = null;
        Assert.assertEquals((long)MurmurHash3v2.hash((byte[])barr, (long)seed)[0], (long)hash0);
        char[] carr = new char[]{};
        Assert.assertEquals((long)MurmurHash3v2.hash((char[])carr, (long)seed)[0], (long)hash0);
        carr = null;
        Assert.assertEquals((long)MurmurHash3v2.hash((char[])carr, (long)seed)[0], (long)hash0);
        int[] iarr = new int[]{};
        Assert.assertEquals((long)MurmurHash3v2.hash((int[])iarr, (long)seed)[0], (long)hash0);
        iarr = null;
        Assert.assertEquals((long)MurmurHash3v2.hash((int[])iarr, (long)seed)[0], (long)hash0);
        long[] larr = new long[]{};
        Assert.assertEquals((long)MurmurHash3v2.hash((long[])larr, (long)seed)[0], (long)hash0);
        larr = null;
        Assert.assertEquals((long)MurmurHash3v2.hash((long[])larr, (long)seed)[0], (long)hash0);
    }

    @Test
    public void checkStringLong() {
        String s = "123";
        long seed = 123L;
        long[] hashOut = new long[2];
        Assert.assertTrue((MurmurHash3v2.hash((String)s, (long)seed, (long[])hashOut)[0] != 0L ? 1 : 0) != 0);
        long v = 123L;
        Assert.assertTrue((MurmurHash3v2.hash((long)v, (long)seed, (long[])hashOut)[0] != 0L ? 1 : 0) != 0);
    }

    @Test
    public void doubleCheck() {
        long[] hash1 = MurmurHash3v2Test.checkDouble(-0.0);
        long[] hash2 = MurmurHash3v2Test.checkDouble(0.0);
        Assert.assertEquals((long[])hash1, (long[])hash2);
        hash1 = MurmurHash3v2Test.checkDouble(Double.NaN);
        long nan = 9218868437227405313L;
        hash2 = MurmurHash3v2Test.checkDouble(Double.longBitsToDouble(nan));
        Assert.assertEquals((long[])hash1, (long[])hash2);
        MurmurHash3v2Test.checkDouble(1.0);
    }

    private static long[] checkDouble(double dbl) {
        long seed = 0L;
        int offset = 0;
        int bytes = 8;
        long[] hash2 = new long[2];
        double d = dbl == 0.0 ? 0.0 : dbl;
        long data = Double.doubleToLongBits(d);
        long[] dataArr = new long[]{data};
        WritableMemory wmem = WritableMemory.wrap((long[])dataArr);
        long[] hash1 = MurmurHash3.hash((long[])dataArr, (long)0L);
        hash2 = MurmurHash3v2.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
        long[] hash3 = MurmurHash3v2.hash((double)dbl, (long)seed, (long[])hash2);
        Assert.assertEquals((long[])hash1, (long[])hash2);
        Assert.assertEquals((long[])hash1, (long[])hash3);
        return hash1;
    }
}

