/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hash;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.Util;
import org.apache.datasketches.hash.MurmurHash3;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MurmurHash3Test {
    @Test
    public void checkByteArrRemainderGT8() {
        String keyStr = "The quick brown fox jumps over the lazy dog";
        byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
        long[] result = MurmurHash3.hash((byte[])key, (long)0L);
        long h1 = -2068352364225029268L;
        long h2 = 8809951995912426311L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkByteArrChange1bit() {
        String keyStr = "The quick brown fox jumps over the lazy eog";
        byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
        long[] result = MurmurHash3.hash((byte[])key, (long)0L);
        long h1 = 3900407617836732873L;
        long h2 = 3640541342445253381L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkByteArrRemainderLt8() {
        String keyStr = "The quick brown fox jumps over the lazy dogdogdog";
        byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
        long[] result = MurmurHash3.hash((byte[])key, (long)0L);
        long h1 = -7169161952862588988L;
        long h2 = -3764816456417919495L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkByteArrReaminderEQ8() {
        String keyStr = "The quick brown fox jumps over the lazy1";
        byte[] key = keyStr.getBytes(StandardCharsets.UTF_8);
        long[] result = MurmurHash3.hash((byte[])key, (long)0L);
        long h1 = -2076130280449712157L;
        long h2 = -4774090513620991086L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkLongArrRemainderEQ8() {
        String keyStr = "The quick brown fox jumps over the lazy1";
        long[] key = MurmurHash3Test.stringToLongs(keyStr);
        long[] result = MurmurHash3.hash((long[])key, (long)0L);
        long h1 = -2076130280449712157L;
        long h2 = -4774090513620991086L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkIntArrRemainderEQ8() {
        String keyStr = "The quick brown fox jumps over the lazy1";
        int[] key = MurmurHash3Test.stringToInts(keyStr);
        long[] result = MurmurHash3.hash((int[])key, (long)0L);
        long h1 = -2076130280449712157L;
        long h2 = -4774090513620991086L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkIntArrRemainderEQ0() {
        String keyStr = "The quick brown fox jumps over t";
        int[] key = MurmurHash3Test.stringToInts(keyStr);
        long[] result = MurmurHash3.hash((int[])key, (long)0L);
        long h1 = -2347790358364300593L;
        long h2 = -7952440200260357210L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkIntArrOddRemainder() {
        String keyStr = "The quick brown fox jumps over the lazy dog";
        int[] key = MurmurHash3Test.stringToInts(keyStr);
        long[] result = MurmurHash3.hash((int[])key, (long)0L);
        long h1 = 2211886098629870581L;
        long h2 = -266816821277170673L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkCharArrOddRemainder() {
        String keyStr = "The quick brown fox jumps over the lazy dog..";
        char[] key = keyStr.toCharArray();
        long[] result = MurmurHash3.hash((char[])key, (long)0L);
        long h1 = -3857415986955232941L;
        long h2 = -8390330609763588738L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkCharArrRemainderEQ0() {
        String keyStr = "The quick brown fox jumps over the lazy ";
        char[] key = keyStr.toCharArray();
        long[] result = MurmurHash3.hash((char[])key, (long)0L);
        long h1 = 5886590216495954417L;
        long h2 = -9149394530286104085L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkByteArrAllOnesZeros() {
        byte[] key = new byte[]{84, 104, 101, 32, 113, 117, 105, 99, 107, 32, 98, 114, 111, 119, 110, 32, 102, 111, 120, 32, 106, 117, 109, 112, 115, 32, 111, 118, 101, 114, 32, 116, 104, 101, 32, 108, 97, 122, 121, 32, 100, 111, 103, -1, 100, 111, 103, 0};
        long[] result = MurmurHash3.hash((byte[])key, (long)0L);
        long h1 = -1690330182926033762L;
        long h2 = -7585885279059409962L;
        Assert.assertEquals((long)result[0], (long)h1);
        Assert.assertEquals((long)result[1], (long)h2);
    }

    @Test
    public void checkCrossTypeHashConsistency() {
        MurmurHash3Test.println("Bytes");
        byte[] bArr = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
        long[] out1 = MurmurHash3.hash((byte[])bArr, (long)0L);
        MurmurHash3Test.println(Util.longToHexBytes((long)out1[0]));
        MurmurHash3Test.println(Util.longToHexBytes((long)out1[1]));
        MurmurHash3Test.println("Chars");
        char[] cArr = new char[]{'\u0201', '\u0403', '\u0605', '\u0807', '\u0a09', '\u0c0b', '\u0e0d', '\u100f', '\u1211', '\u1413', '\u1615', '\u1817'};
        long[] out = MurmurHash3.hash((char[])cArr, (long)0L);
        Assert.assertEquals((long[])out, (long[])out1);
        MurmurHash3Test.println(Util.longToHexBytes((long)out[0]));
        MurmurHash3Test.println(Util.longToHexBytes((long)out[1]));
        MurmurHash3Test.println("Ints");
        int[] iArr = new int[]{67305985, 134678021, 202050057, 269422093, 336794129, 404166165};
        out = MurmurHash3.hash((int[])iArr, (long)0L);
        Assert.assertEquals((long[])out, (long[])out1);
        MurmurHash3Test.println(Util.longToHexBytes((long)out[0]));
        MurmurHash3Test.println(Util.longToHexBytes((long)out[1]));
        MurmurHash3Test.println("Longs");
        long[] lArr = new long[]{578437695752307201L, 1157159078456920585L, 1735880461161533969L};
        out = MurmurHash3.hash((long[])lArr, (long)0L);
        Assert.assertEquals((long[])out, (long[])out1);
        MurmurHash3Test.println(Util.longToHexBytes((long)out[0]));
        MurmurHash3Test.println(Util.longToHexBytes((long)out[1]));
    }

    private static long[] stringToLongs(String in) {
        byte[] bArr = in.getBytes(StandardCharsets.UTF_8);
        int inLen = bArr.length;
        int outLen = inLen / 8 + (inLen % 8 != 0 ? 1 : 0);
        long[] out = new long[outLen];
        for (int i = 0; i < outLen - 1; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i;
                out[n] = out[n] | ((long)bArr[i * 8 + j] & 0xFFL) << j * 8;
            }
        }
        int inTail = 8 * (outLen - 1);
        int rem = inLen - inTail;
        for (int j = 0; j < rem; ++j) {
            int n = outLen - 1;
            out[n] = out[n] | ((long)bArr[inTail + j] & 0xFFL) << j * 8;
        }
        return out;
    }

    private static int[] stringToInts(String in) {
        byte[] bArr = in.getBytes(StandardCharsets.UTF_8);
        int inLen = bArr.length;
        int outLen = inLen / 4 + (inLen % 4 != 0 ? 1 : 0);
        int[] out = new int[outLen];
        for (int i = 0; i < outLen - 1; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n = i;
                out[n] = (int)((long)out[n] | ((long)bArr[i * 4 + j] & 0xFFL) << j * 8);
            }
        }
        int inTail = 4 * (outLen - 1);
        int rem = inLen - inTail;
        for (int j = 0; j < rem; ++j) {
            int n = outLen - 1;
            out[n] = (int)((long)out[n] | ((long)bArr[inTail + j] & 0xFFL) << j * 8);
        }
        return out;
    }

    @Test
    public void printlnTest() {
        MurmurHash3Test.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

