/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.frequencies;

import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfLongsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.frequencies.LongsSketch;
import org.apache.datasketches.frequencies.PreambleUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SerDeCompatibilityTest {
    static final ArrayOfItemsSerDe<Long> serDe = new ArrayOfLongsSerDe();

    @Test
    public void itemsToLongs() {
        ItemsSketch sketch1 = new ItemsSketch(8);
        sketch1.update((Object)1L);
        sketch1.update((Object)2L);
        sketch1.update((Object)3L);
        sketch1.update((Object)4L);
        byte[] bytes = sketch1.toByteArray(serDe);
        LongsSketch sketch2 = LongsSketch.getInstance((Memory)WritableMemory.wrap((byte[])bytes));
        sketch2.update(2L);
        sketch2.update(3L);
        sketch2.update(2L);
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)4);
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)7L);
        Assert.assertEquals((long)sketch2.getEstimate(1L), (long)1L);
        Assert.assertEquals((long)sketch2.getEstimate(2L), (long)3L);
        Assert.assertEquals((long)sketch2.getEstimate(3L), (long)2L);
        Assert.assertEquals((long)sketch2.getEstimate(4L), (long)1L);
    }

    @Test
    public void longsToItems() {
        LongsSketch sketch1 = new LongsSketch(8);
        sketch1.update(1L);
        sketch1.update(2L);
        sketch1.update(3L);
        sketch1.update(4L);
        byte[] bytes = sketch1.toByteArray();
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)WritableMemory.wrap((byte[])bytes), serDe);
        sketch2.update((Object)2L);
        sketch2.update((Object)3L);
        sketch2.update((Object)2L);
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)4);
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)7L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)1L), (long)1L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)2L), (long)3L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)3L), (long)2L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)4L), (long)1L);
    }

    @Test
    public void checkInsertSerDeId() {
        long pre0 = 0L;
        pre0 = PreambleUtil.insertSerDeId((short)-1, (long)pre0);
        short serDeId = PreambleUtil.extractSerDeId((long)pre0);
        Assert.assertEquals((int)serDeId, (int)-1);
    }
}

