/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.HeapAuxHashMap;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;

class Hll4Update {
    Hll4Update() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final void internalHll4Update(AbstractHllArray host, int slotNo, int newValue) {
        int actualOldValue;
        assert (0 <= slotNo && slotNo < 1 << host.getLgConfigK());
        assert (newValue > 0);
        int curMin = host.getCurMin();
        AuxHashMap auxHashMap = host.getAuxHashMap();
        int rawStoredOldValue = host.getSlot(slotNo);
        int lbOnOldValue = rawStoredOldValue + curMin;
        if (newValue <= lbOnOldValue) return;
        int n = actualOldValue = rawStoredOldValue < 15 ? lbOnOldValue : auxHashMap.mustFindValueFor(slotNo);
        if (newValue <= actualOldValue) return;
        AbstractHllArray.hipAndKxQIncrementalUpdate(host, actualOldValue, newValue);
        assert (newValue >= curMin) : "New value " + newValue + " is less than current minimum " + curMin;
        int shiftedNewValue = newValue - curMin;
        assert (shiftedNewValue >= 0);
        if (rawStoredOldValue == 15) {
            if (shiftedNewValue < 15) throw new SketchesStateException("Impossible case");
            auxHashMap.mustReplace(slotNo, newValue);
        } else if (shiftedNewValue >= 15) {
            host.putSlot(slotNo, 15);
            if (auxHashMap == null) {
                auxHashMap = host.getNewAuxHashMap();
                host.putAuxHashMap(auxHashMap, false);
            }
            auxHashMap.mustAdd(slotNo, newValue);
        } else {
            host.putSlot(slotNo, shiftedNewValue);
        }
        if (actualOldValue != curMin) return;
        assert (host.getNumAtCurMin() >= 1);
        host.decNumAtCurMin();
        while (host.getNumAtCurMin() == 0) {
            Hll4Update.shiftToBiggerCurMin(host);
        }
    }

    private static final void shiftToBiggerCurMin(AbstractHllArray host) {
        int oldCurMin = host.getCurMin();
        int newCurMin = oldCurMin + 1;
        int lgConfigK = host.getLgConfigK();
        int configK = 1 << lgConfigK;
        int configKmask = configK - 1;
        int numAtNewCurMin = 0;
        int numAuxTokens = 0;
        for (int i = 0; i < configK; ++i) {
            int oldStoredValue = host.getSlot(i);
            if (oldStoredValue == 0) {
                throw new SketchesStateException("Array slots cannot be 0 at this point.");
            }
            if (oldStoredValue < 15) {
                host.putSlot(i, --oldStoredValue);
                if (oldStoredValue != 0) continue;
                ++numAtNewCurMin;
                continue;
            }
            ++numAuxTokens;
            assert (host.getAuxHashMap() != null) : "AuxHashMap cannot be null at this point.";
        }
        AuxHashMap newAuxMap = null;
        AuxHashMap oldAuxMap = host.getAuxHashMap();
        if (oldAuxMap != null) {
            PairIterator itr = oldAuxMap.getIterator();
            while (itr.nextValid()) {
                int slotNum = itr.getKey() & configKmask;
                int oldActualVal = itr.getValue();
                int newShiftedVal = oldActualVal - newCurMin;
                assert (newShiftedVal >= 0);
                assert (host.getSlot(slotNum) == 15) : "Array slot != AUX_TOKEN: " + host.getSlot(slotNum);
                if (newShiftedVal < 15) {
                    assert (newShiftedVal == 14);
                    host.putSlot(slotNum, newShiftedVal);
                    --numAuxTokens;
                    continue;
                }
                if (newAuxMap == null) {
                    newAuxMap = new HeapAuxHashMap(HllUtil.LG_AUX_ARR_INTS[lgConfigK], lgConfigK);
                }
                newAuxMap.mustAdd(slotNum, oldActualVal);
            }
        } else assert (numAuxTokens == 0) : "auxTokens: " + numAuxTokens;
        if (newAuxMap != null) assert (newAuxMap.getAuxCount() == numAuxTokens) : "auxCount: " + newAuxMap.getAuxCount() + ", HLL tokens: " + numAuxTokens;
        host.putAuxHashMap(newAuxMap, false);
        host.putCurMin(newCurMin);
        host.putNumAtCurMin(numAtNewCurMin);
    }
}

