/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook;

import org.apache.atlas.plugin.classloader.AtlasPluginClassLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetastoreHook
extends MetaStoreEventListener {
    private static final String ATLAS_PLUGIN_TYPE = "hive";
    private static final String ATLAS_HIVE_METASTORE_HOOK_IMPL_CLASSNAME = "org.apache.atlas.hive.hook.HiveMetastoreHookImpl";
    public static final Logger LOG = LoggerFactory.getLogger(HiveMetastoreHook.class);
    private AtlasPluginClassLoader atlasPluginClassLoader = null;
    private MetaStoreEventListener atlasMetastoreHookImpl = null;
    private Configuration config;

    public HiveMetastoreHook(Configuration config) {
        super(config);
        this.config = config;
        this.initialize();
    }

    private void initialize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveMetastoreHook.initialize()");
        }
        try {
            this.atlasPluginClassLoader = AtlasPluginClassLoader.getInstance((String)ATLAS_PLUGIN_TYPE, ((Object)((Object)this)).getClass());
            Class<?> cls = Class.forName(ATLAS_HIVE_METASTORE_HOOK_IMPL_CLASSNAME, true, (ClassLoader)this.atlasPluginClassLoader);
            this.activatePluginClassLoader();
            this.atlasMetastoreHookImpl = (MetaStoreEventListener)cls.getDeclaredConstructor(Configuration.class).newInstance(this.config);
        }
        catch (Exception ex) {
            LOG.error("Error instantiating Atlas hook implementation", (Throwable)ex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveMetastoreHook.initialize()");
        }
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveMetastoreHook.onCreateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.atlasMetastoreHookImpl.onCreateTable(tableEvent);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveMetastoreHook.onCreateTable()");
        }
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveMetastoreHook.onDropTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.atlasMetastoreHookImpl.onDropTable(tableEvent);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveMetastoreHook.onDropTable()");
        }
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveMetastoreHook.onAlterTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.atlasMetastoreHookImpl.onAlterTable(tableEvent);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveMetastoreHook.onAlterTable()");
        }
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveMetastoreHook.onCreateDatabase()");
        }
        try {
            this.activatePluginClassLoader();
            this.atlasMetastoreHookImpl.onCreateDatabase(dbEvent);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveMetastoreHook.onCreateDatabase()");
        }
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveMetastoreHook.onDropDatabase()");
        }
        try {
            this.activatePluginClassLoader();
            this.atlasMetastoreHookImpl.onDropDatabase(dbEvent);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveMetastoreHook.onDropDatabase()");
        }
    }

    public void onAlterDatabase(AlterDatabaseEvent dbEvent) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveMetastoreHook.onAlterDatabase()");
        }
        try {
            this.activatePluginClassLoader();
            this.atlasMetastoreHookImpl.onAlterDatabase(dbEvent);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveMetastoreHook.onAlterDatabase()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.deactivate();
        }
    }
}

