/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook;

import org.apache.atlas.plugin.classloader.AtlasPluginClassLoader;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHook
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger(HiveHook.class);
    private static final String ATLAS_PLUGIN_TYPE = "hive";
    private static final String ATLAS_HIVE_HOOK_IMPL_CLASSNAME = "org.apache.atlas.hive.hook.HiveHook";
    private AtlasPluginClassLoader atlasPluginClassLoader = null;
    private ExecuteWithHookContext hiveHookImpl = null;

    public HiveHook() {
        this.initialize();
    }

    public void run(HookContext hookContext) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveHook.run({})", (Object)hookContext);
        }
        try {
            this.activatePluginClassLoader();
            this.hiveHookImpl.run(hookContext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveHook.run({})", (Object)hookContext);
        }
    }

    private void initialize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveHook.initialize()");
        }
        try {
            this.atlasPluginClassLoader = AtlasPluginClassLoader.getInstance((String)ATLAS_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(ATLAS_HIVE_HOOK_IMPL_CLASSNAME, true, (ClassLoader)this.atlasPluginClassLoader);
            this.activatePluginClassLoader();
            this.hiveHookImpl = (ExecuteWithHookContext)cls.newInstance();
        }
        catch (Exception excp) {
            LOG.error("Error instantiating Atlas hook implementation", (Throwable)excp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveHook.initialize()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.deactivate();
        }
    }
}

