/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.atlas.connector.entities;

import com.couchbase.atlas.connector.entities.CouchbaseAtlasEntity;
import com.couchbase.atlas.connector.entities.CouchbaseBucket;
import com.couchbase.atlas.connector.entities.CouchbaseCollection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.model.instance.AtlasEntity;

public class CouchbaseScope
extends CouchbaseAtlasEntity<CouchbaseScope> {
    public static final String TYPE_NAME = "couchbase_scope";
    private CouchbaseBucket bucket;
    private transient Map<String, CouchbaseCollection> collections = Collections.synchronizedMap(new HashMap());

    public CouchbaseBucket bucket() {
        return this.bucket;
    }

    public CouchbaseScope bucket(CouchbaseBucket bucket) {
        this.bucket = bucket;
        return this;
    }

    @Override
    public UUID id() {
        return UUID.nameUUIDFromBytes(String.format("%s:%s:%s", this.atlasTypeName(), this.bucket().id().toString(), this.name()).getBytes(Charset.defaultCharset()));
    }

    @Override
    public AtlasEntity atlasEntity(AtlasClientV2 atlas) {
        AtlasEntity entity = super.atlasEntity(atlas);
        entity.setRelationshipAttribute("bucket", (Object)this.bucket.atlasEntity(atlas));
        return entity;
    }

    @Override
    public String qualifiedName() {
        return String.format("%s/%s", this.bucket.qualifiedName(), this.name());
    }

    @Override
    public String atlasTypeName() {
        return TYPE_NAME;
    }

    public CouchbaseCollection collection(String name) {
        if (!this.collections.containsKey(name)) {
            this.collections.put(name, (CouchbaseCollection)((CouchbaseCollection)new CouchbaseCollection().name(name)).scope(this).get());
        }
        return this.collections.get(name);
    }
}

