/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.atlas.connector.entities;

import com.couchbase.client.java.json.JsonObject;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public enum CouchbaseFieldType {
    BOOLEAN,
    NUMBER,
    STRING,
    ARRAY,
    OBJECT,
    BINARY;


    public static CouchbaseFieldType infer(@Nonnull Object value) {
        if (value instanceof Map || value instanceof JsonObject) {
            return OBJECT;
        }
        if (value instanceof Collection || value.getClass().isArray()) {
            if (value.getClass().isArray() && Byte.class.isAssignableFrom(value.getClass().getComponentType())) {
                return BINARY;
            }
            return ARRAY;
        }
        if (value instanceof Number) {
            return NUMBER;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        if (value instanceof String) {
            String sValue = (String)value;
            if ("true".equalsIgnoreCase(sValue) || "false".equalsIgnoreCase(sValue)) {
                return BOOLEAN;
            }
            try {
                Double.parseDouble(sValue);
                return NUMBER;
            }
            catch (NumberFormatException nfe) {
                return STRING;
            }
        }
        throw new IllegalArgumentException("Failed to infer type");
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.getDefault());
    }
}

