/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.atlas.connector.entities;

import com.couchbase.atlas.connector.entities.CouchbaseAtlasEntity;
import com.couchbase.atlas.connector.entities.CouchbaseCollection;
import com.couchbase.atlas.connector.entities.CouchbaseFieldType;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.model.instance.AtlasEntity;

public class CouchbaseField
extends CouchbaseAtlasEntity<CouchbaseField> {
    public static final String TYPE_NAME = "couchbase_field";
    private CouchbaseFieldType fieldType;
    private String fieldPath;
    private long documentCount = 0L;
    private CouchbaseField parentField;
    private CouchbaseCollection collection;

    public CouchbaseFieldType fieldType() {
        return this.fieldType;
    }

    public CouchbaseField fieldType(CouchbaseFieldType fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public String fieldPath() {
        return this.fieldPath;
    }

    public CouchbaseField fieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return this;
    }

    public long documentCount() {
        return this.documentCount;
    }

    public CouchbaseField documentCount(long documentCount) {
        this.documentCount = documentCount;
        return this;
    }

    public void incrementDocumentCount() {
        ++this.documentCount;
    }

    public CouchbaseCollection collection() {
        return this.collection;
    }

    public CouchbaseField collection(CouchbaseCollection collection) {
        this.collection = collection;
        return this;
    }

    @Override
    public AtlasEntity atlasEntity(AtlasClientV2 atlas) {
        AtlasEntity entity = super.atlasEntity(atlas);
        entity.setRelationshipAttribute("collection", (Object)this.collection.atlasEntity(atlas));
        if (this.parentField != null) {
            entity.setRelationshipAttribute("parentField", (Object)this.parentField.atlasEntity(atlas));
        }
        return entity;
    }

    @Override
    protected void updateAtlasEntity(AtlasEntity entity) {
        entity.setAttribute("fieldType", (Object)this.fieldType.toString());
        entity.setAttribute("fieldPath", (Object)this.fieldPath);
        entity.setAttribute("documentCount", (Object)this.documentCount);
    }

    @Override
    protected String qualifiedName() {
        return String.format("%s/%s:%s", new Object[]{this.collection.qualifiedName(), this.fieldPath(), this.fieldType()});
    }

    @Override
    public String atlasTypeName() {
        return TYPE_NAME;
    }

    @Override
    public UUID id() {
        return UUID.nameUUIDFromBytes(this.qualifiedName().getBytes(Charset.defaultCharset()));
    }

    public CouchbaseField parentField() {
        return this.parentField;
    }

    public CouchbaseField parentField(CouchbaseField parent) {
        this.parentField = parent;
        return this;
    }
}

