/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.atlas.connector.entities;

import com.couchbase.atlas.connector.entities.CouchbaseAtlasEntity;
import com.couchbase.atlas.connector.entities.CouchbaseScope;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.model.instance.AtlasEntity;

public class CouchbaseCollection
extends CouchbaseAtlasEntity<CouchbaseCollection> {
    private CouchbaseScope scope;
    private long documentsAnalyzed;

    public CouchbaseCollection scope(CouchbaseScope scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public AtlasEntity atlasEntity(AtlasClientV2 atlas) {
        AtlasEntity entity = super.atlasEntity(atlas);
        entity.setRelationshipAttribute("scope", (Object)this.scope.atlasEntity(atlas));
        return entity;
    }

    @Override
    protected void updateAtlasEntity(AtlasEntity entity) {
        entity.setAttribute("documentsAnalyzed", (Object)this.documentsAnalyzed);
    }

    @Override
    protected void updateJavaModel(AtlasEntity entity) {
        this.documentsAnalyzed = ((Integer)entity.getAttribute("documentsAnalyzed")).intValue();
    }

    public long documentsAnalyzed() {
        return this.documentsAnalyzed;
    }

    public CouchbaseCollection incrementAnalyzedDocuments() {
        ++this.documentsAnalyzed;
        return this;
    }

    @Override
    protected String qualifiedName() {
        return String.format("%s/%s", this.scope.qualifiedName(), this.name());
    }

    @Override
    public String atlasTypeName() {
        return "couchbase_collection";
    }

    @Override
    public UUID id() {
        return UUID.nameUUIDFromBytes(String.format("%s:%s:%s", this.atlasTypeName(), this.scope().id().toString(), this.name()).getBytes(Charset.defaultCharset()));
    }

    public CouchbaseScope scope() {
        return this.scope;
    }
}

