/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.atlas.connector.entities;

import com.couchbase.atlas.connector.entities.CouchbaseAtlasEntity;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasTypeUtil;

public class CouchbaseCluster
extends CouchbaseAtlasEntity<CouchbaseCluster> {
    public static final String TYPE_NAME = "couchbase_cluster";
    private String url;

    public String url() {
        return this.url;
    }

    public CouchbaseCluster url(String url) {
        this.url = url;
        return this;
    }

    public static AtlasEntityDef atlasEntityDef() {
        AtlasEntityDef definition = AtlasTypeUtil.createClassTypeDef((String)TYPE_NAME, new HashSet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        definition.getSuperTypes().add("Asset");
        definition.setServiceType("couchbase");
        definition.setTypeVersion("0.1");
        List attributes = definition.getAttributeDefs();
        attributes.add(new AtlasStructDef.AtlasAttributeDef("url", "string", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, true, true, true, Collections.EMPTY_LIST));
        return definition;
    }

    public static Collection<? extends AtlasRelationshipDef> atlasRelationshipDefs() {
        return Arrays.asList(new AtlasRelationshipDef("couchbase_cluster_buckets", "", "0.1", "couchbase", AtlasRelationshipDef.RelationshipCategory.AGGREGATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(TYPE_NAME, "buckets", AtlasStructDef.AtlasAttributeDef.Cardinality.SET, true), new AtlasRelationshipEndDef("couchbase_bucket", "cluster", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, false)));
    }

    @Override
    public String atlasTypeName() {
        return TYPE_NAME;
    }

    @Override
    public UUID id() {
        return UUID.nameUUIDFromBytes(String.format("%s:%s", this.atlasTypeName(), this.url()).getBytes(Charset.defaultCharset()));
    }

    @Override
    public AtlasEntity atlasEntity(AtlasClientV2 atlas) {
        AtlasEntity entity = super.atlasEntity(atlas);
        entity.setAttribute("url", (Object)this.url());
        return entity;
    }

    @Override
    protected String qualifiedName() {
        return this.url();
    }

    @Override
    protected void updateJavaModel(AtlasEntity entity) {
        if (entity.hasAttribute("url")) {
            this.url = (String)entity.getAttribute("url");
        }
    }
}

