/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.atlas.connector.entities;

import com.couchbase.atlas.connector.entities.CouchbaseAtlasEntity;
import com.couchbase.atlas.connector.entities.CouchbaseCluster;
import com.couchbase.atlas.connector.entities.CouchbaseScope;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.model.instance.AtlasEntity;

public class CouchbaseBucket
extends CouchbaseAtlasEntity<CouchbaseBucket> {
    public static final String TYPE_NAME = "couchbase_bucket";
    private CouchbaseCluster cluster;
    private transient Map<String, CouchbaseScope> scopes = Collections.synchronizedMap(new HashMap());

    @Override
    public AtlasEntity atlasEntity(AtlasClientV2 atlas) {
        AtlasEntity entity = super.atlasEntity(atlas);
        entity.setRelationshipAttribute("cluster", (Object)this.cluster.atlasEntity(atlas));
        return entity;
    }

    @Override
    protected String qualifiedName() {
        return String.format("%s/%s", this.cluster.qualifiedName(), this.name());
    }

    public CouchbaseCluster cluster() {
        return this.cluster;
    }

    public CouchbaseBucket cluster(CouchbaseCluster cluster) {
        this.cluster = cluster;
        return this;
    }

    @Override
    public String atlasTypeName() {
        return TYPE_NAME;
    }

    @Override
    public UUID id() {
        return UUID.nameUUIDFromBytes(String.format("%s:%s:%s", this.atlasTypeName(), this.cluster().id(), this.name()).getBytes(Charset.defaultCharset()));
    }

    public CouchbaseScope scope(String name) {
        if (!this.scopes.containsKey(name)) {
            this.scopes.put(name, (CouchbaseScope)((CouchbaseScope)new CouchbaseScope().bucket(this).name(name)).get());
        }
        return this.scopes.get(name);
    }
}

