/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.atlas.connector.entities;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.instance.AtlasEntity;

public abstract class CouchbaseAtlasEntity<E extends CouchbaseAtlasEntity<?>> {
    private static final Map<Class, Map<String, AtlasEntity>> ENTITY_BY_TYPE_AND_ID = Collections.synchronizedMap(new HashMap());
    private static final Map<Class, Map<String, CouchbaseAtlasEntity>> MODEL_BY_TYPE_AND_ID = Collections.synchronizedMap(new HashMap());
    private String name;

    public String name() {
        return this.name;
    }

    public E name(String name) {
        this.name = name;
        return (E)this;
    }

    public AtlasEntity atlasEntity(AtlasClientV2 atlas) {
        AtlasEntity atlasEntity = this.atlasEntity().filter(entity -> entity.getGuid().charAt(0) != '-').orElseGet(() -> this.cache(this.load(atlas).orElseGet(() -> this.atlasEntity().orElseGet(() -> new AtlasEntity(this.atlasTypeName())))));
        atlasEntity.setAttribute("name", (Object)this.name);
        atlasEntity.setAttribute("qualifiedName", (Object)this.qualifiedName());
        this.updateAtlasEntity(atlasEntity);
        return atlasEntity;
    }

    protected abstract String qualifiedName();

    public Optional<AtlasEntity> atlasEntity() {
        return this.cachedEntity().map(atlasEntity -> {
            this.updateAtlasEntity((AtlasEntity)atlasEntity);
            return atlasEntity;
        });
    }

    protected boolean exists() {
        return this.cachedEntity().isPresent();
    }

    public abstract String atlasTypeName();

    public abstract UUID id();

    protected void updateAtlasEntity(AtlasEntity entity) {
    }

    protected void updateJavaModel(AtlasEntity entity) {
    }

    private Optional<AtlasEntity> load(AtlasClientV2 client) {
        block4: {
            try {
                HashMap<String, String> query = new HashMap<String, String>();
                query.put("qualifiedName", this.qualifiedName());
                AtlasEntity atlasEntity = client.getEntityByAttribute(this.atlasTypeName(), query).getEntity();
                if (atlasEntity != null) {
                    this.cache(atlasEntity);
                    if (atlasEntity.hasAttribute("name")) {
                        this.name = (String)atlasEntity.getAttribute("name");
                    }
                    this.updateJavaModel(atlasEntity);
                    return Optional.of(atlasEntity);
                }
            }
            catch (AtlasServiceException e) {
                if (e.getStatus().getStatusCode() == 404) break block4;
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    private AtlasEntity cache(AtlasEntity atlasEntity) {
        if (!ENTITY_BY_TYPE_AND_ID.containsKey(this.getClass())) {
            ENTITY_BY_TYPE_AND_ID.put(this.getClass(), new HashMap());
        }
        ENTITY_BY_TYPE_AND_ID.get(this.getClass()).put(this.id().toString(), atlasEntity);
        return atlasEntity;
    }

    private Optional<AtlasEntity> cachedEntity() {
        return Optional.ofNullable(ENTITY_BY_TYPE_AND_ID.getOrDefault(this.getClass(), Collections.EMPTY_MAP).getOrDefault(this.id().toString(), null));
    }

    public boolean exists(AtlasClientV2 atlas) {
        if (!this.exists()) {
            return this.load(atlas).isPresent();
        }
        return true;
    }

    public E get() {
        Map<String, CouchbaseAtlasEntity> modelsById;
        Class<?> type = this.getClass();
        String id = this.id().toString();
        if (!MODEL_BY_TYPE_AND_ID.containsKey(type)) {
            MODEL_BY_TYPE_AND_ID.put(type, Collections.synchronizedMap(new HashMap()));
        }
        if (!(modelsById = MODEL_BY_TYPE_AND_ID.get(type)).containsKey(id)) {
            try {
                modelsById.put(id, this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (E)modelsById.get(id);
    }

    public static void dropCache() {
        ENTITY_BY_TYPE_AND_ID.clear();
        MODEL_BY_TYPE_AND_ID.clear();
    }
}

