/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import javax.inject.Inject;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.web.service.DebugMetricsWrapper;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TimedAspectInterceptor {
    private static final boolean debugMetricsEnabled = AtlasConfiguration.DEBUG_METRICS_ENABLED.getBoolean();
    private final DebugMetricsWrapper wrapper;

    @Inject
    public TimedAspectInterceptor(DebugMetricsWrapper wrapper) {
        this.wrapper = wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(org.apache.atlas.annotation.Timed) && execution(public * *(..))")
    public Object timerAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            Object object = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            if (debugMetricsEnabled) {
                this.reportMetrics(start, proceedingJoinPoint.getSignature());
            }
        }
    }

    private void reportMetrics(long start, Signature signature) {
        long executionTime = System.currentTimeMillis() - start;
        this.wrapper.update(signature, executionTime);
    }
}

