/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasException;
import org.apache.atlas.security.SecurityProperties;
import org.apache.atlas.security.SecurityUtil;
import org.apache.atlas.web.service.EmbeddedServer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureEmbeddedServer
extends EmbeddedServer {
    private static final Logger LOG = LoggerFactory.getLogger(SecureEmbeddedServer.class);
    public static final String ATLAS_KEYSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String ATLAS_TRUSTSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String ATLAS_TLS_CONTEXT_ALGO_TYPE = "TLS";
    public static final String ATLAS_TLS_KEYMANAGER_DEFAULT_ALGO_TYPE = KeyManagerFactory.getDefaultAlgorithm();
    public static final String ATLAS_TLS_TRUSTMANAGER_DEFAULT_ALGO_TYPE = TrustManagerFactory.getDefaultAlgorithm();

    public SecureEmbeddedServer(String host, int port, String path) throws IOException {
        super(host, port, path);
    }

    @Override
    protected Connector getConnector(String host, int port) throws IOException {
        String[] excludedProtocols;
        Configuration config = this.getConfiguration();
        SSLContext sslContext = this.getSSLContext();
        if (sslContext != null) {
            SSLContext.setDefault(sslContext);
        }
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStoreType(config.getString("keystore.type", "jks"));
        sslContextFactory.setKeyStorePath(config.getString("keystore.file", System.getProperty("keystore.file", "target/atlas.keystore")));
        sslContextFactory.setKeyStorePassword(SecurityUtil.getPassword((Configuration)config, (String)"keystore.password"));
        sslContextFactory.setKeyManagerPassword(SecurityUtil.getPassword((Configuration)config, (String)"password"));
        sslContextFactory.setTrustStoreType(config.getString("truststore.type", "jks"));
        sslContextFactory.setTrustStorePath(config.getString("truststore.file", System.getProperty("truststore.file", "target/atlas.keystore")));
        sslContextFactory.setTrustStorePassword(SecurityUtil.getPassword((Configuration)config, (String)"truststore.password"));
        sslContextFactory.setWantClientAuth(config.getBoolean("client.auth.enabled", Boolean.getBoolean("client.auth.enabled")));
        List cipherList = config.getList("atlas.ssl.exclude.cipher.suites", SecurityProperties.DEFAULT_CIPHER_SUITES);
        sslContextFactory.setExcludeCipherSuites(cipherList.toArray(new String[cipherList.size()]));
        sslContextFactory.setRenegotiationAllowed(false);
        String[] stringArray = excludedProtocols = config.containsKey("atlas.ssl.exclude.protocols") ? config.getStringArray("atlas.ssl.exclude.protocols") : SecurityProperties.DEFAULT_EXCLUDE_PROTOCOLS;
        if (excludedProtocols != null && excludedProtocols.length > 0) {
            sslContextFactory.addExcludeProtocols(excludedProtocols);
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        int bufferSize = AtlasConfiguration.WEBSERVER_REQUEST_BUFFER_SIZE.getInt();
        httpConfig.setSecurePort(port);
        httpConfig.setRequestHeaderSize(bufferSize);
        httpConfig.setResponseHeaderSize(bufferSize);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(false);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        httpsConfig.setSendServerVersion(false);
        ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        sslConnector.setPort(port);
        this.server.addConnector((Connector)sslConnector);
        return sslConnector;
    }

    protected Configuration getConfiguration() {
        try {
            return ApplicationProperties.get();
        }
        catch (AtlasException e) {
            throw new RuntimeException("Unable to load configuration: atlas-application.properties");
        }
    }

    private SSLContext getSSLContext() {
        KeyManager[] kmList = this.getKeyManagers();
        TrustManager[] tmList = this.getTrustManagers();
        SSLContext sslContext = null;
        if (tmList != null) {
            try {
                sslContext = SSLContext.getInstance(ATLAS_TLS_CONTEXT_ALGO_TYPE);
                sslContext.init(kmList, tmList, new SecureRandom());
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("SSL algorithm is not available in the environment. Reason: {}", (Object)String.valueOf(e));
            }
            catch (KeyManagementException e) {
                LOG.error("Unable to initials the SSLContext. Reason: {}", (Object)String.valueOf(e));
            }
        }
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList;
        block19: {
            kmList = null;
            try {
                String keyStoreFile = this.getConfiguration().getString("keystore.file", System.getProperty("keystore.file", "target/atlas.keystore"));
                String keyStoreFilepwd = SecurityUtil.getPassword((Configuration)this.getConfiguration(), (String)"keystore.password");
                if (!StringUtils.isNotEmpty((String)keyStoreFile) || !StringUtils.isNotEmpty((String)keyStoreFilepwd)) break block19;
                InputStream in = null;
                try {
                    in = this.getFileInputStream(keyStoreFile);
                    if (in != null) {
                        KeyStore keyStore = KeyStore.getInstance(this.getConfiguration().getString("keystore.type", "jks"));
                        keyStore.load(in, keyStoreFilepwd.toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(ATLAS_TLS_KEYMANAGER_DEFAULT_ALGO_TYPE);
                        keyManagerFactory.init(keyStore, keyStoreFilepwd.toCharArray());
                        kmList = keyManagerFactory.getKeyManagers();
                    } else {
                        LOG.error("Unable to obtain keystore from file [{}]", (Object)keyStoreFile);
                    }
                }
                catch (KeyStoreException e) {
                    LOG.error("Unable to obtain from KeyStore :{}", (Object)e.getMessage(), (Object)e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error("SSL algorithm is NOT available in the environment", (Throwable)e);
                }
                catch (CertificateException e) {
                    LOG.error("Unable to obtain the requested certification ", (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    LOG.error("Unable to find the necessary TLS Keystore Files", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("Unable to read the necessary TLS Keystore Files", (Throwable)e);
                }
                catch (UnrecoverableKeyException e) {
                    LOG.error("Unable to recover the key from keystore", (Throwable)e);
                }
                finally {
                    this.close(in, keyStoreFile);
                }
            }
            catch (IOException exception) {
                LOG.error(exception.getMessage());
            }
        }
        return kmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] getTrustManagers() {
        TrustManager[] tmList;
        block17: {
            tmList = null;
            try {
                String truststoreFile = this.getConfiguration().getString("truststore.file", System.getProperty("truststore.file", "target/atlas.keystore"));
                String trustStoreFilepwd = SecurityUtil.getPassword((Configuration)this.getConfiguration(), (String)"truststore.password");
                if (!StringUtils.isNotEmpty((String)truststoreFile) || !StringUtils.isNotEmpty((String)trustStoreFilepwd)) break block17;
                InputStream in = null;
                try {
                    in = this.getFileInputStream(truststoreFile);
                    if (in != null) {
                        KeyStore trustStore = KeyStore.getInstance(this.getConfiguration().getString("truststore.type", "jks"));
                        trustStore.load(in, trustStoreFilepwd.toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(ATLAS_TLS_TRUSTMANAGER_DEFAULT_ALGO_TYPE);
                        trustManagerFactory.init(trustStore);
                        tmList = trustManagerFactory.getTrustManagers();
                    } else {
                        LOG.error("Unable to obtain truststore from file [{}]", (Object)truststoreFile);
                    }
                }
                catch (KeyStoreException e) {
                    LOG.error("Unable to obtain from KeyStore", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error("SSL algorithm is NOT available in the environment :{}", (Object)e.getMessage(), (Object)e);
                }
                catch (CertificateException e) {
                    LOG.error("Unable to obtain the requested certification :{}", (Object)e.getMessage(), (Object)e);
                }
                catch (FileNotFoundException e) {
                    LOG.error("Unable to find the necessary TLS TrustStore File:{}", (Object)truststoreFile, (Object)e);
                }
                catch (IOException e) {
                    LOG.error("Unable to read the necessary TLS TrustStore Files :{}", (Object)truststoreFile, (Object)e);
                }
                finally {
                    this.close(in, truststoreFile);
                }
            }
            catch (IOException exception) {
                LOG.error(exception.getMessage());
            }
        }
        return tmList;
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (StringUtils.isNotEmpty((String)fileName)) {
            File f = new File(fileName);
            in = f.exists() ? new FileInputStream(f) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                LOG.error("Error while closing file: [{}]", (Object)filename, (Object)excp);
            }
        }
    }
}

