/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.audit.AtlasAuditEntry;
import org.apache.atlas.repository.audit.AtlasAuditService;
import org.apache.atlas.util.BeanUtil;
import org.apache.atlas.web.service.SecureEmbeddedServer;
import org.apache.atlas.web.service.ServiceState;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedServer {
    public static final Logger LOG = LoggerFactory.getLogger(EmbeddedServer.class);
    public static final String ATLAS_DEFAULT_BIND_ADDRESS = "0.0.0.0";
    public static final Date SERVER_START_TIME = new Date();
    protected final Server server;
    private AtlasAuditService auditService;
    private ServiceState serviceState;

    public EmbeddedServer(String host, int port, String path) throws IOException {
        int queueSize = AtlasConfiguration.WEBSERVER_QUEUE_SIZE.getInt();
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(queueSize);
        int minThreads = AtlasConfiguration.WEBSERVER_MIN_THREADS.getInt();
        int maxThreads = AtlasConfiguration.WEBSERVER_MAX_THREADS.getInt();
        long keepAliveTime = AtlasConfiguration.WEBSERVER_KEEPALIVE_SECONDS.getLong();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(maxThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, queue);
        ExecutorThreadPool pool = new ExecutorThreadPool(executor, minThreads);
        this.server = new Server((ThreadPool)pool);
        Connector connector = this.getConnector(host, port);
        this.server.addConnector(connector);
        WebAppContext application = this.getWebAppContext(path);
        this.server.setHandler((Handler)application);
    }

    public static EmbeddedServer newServer(String host, int port, String path, boolean secure) throws IOException {
        if (secure) {
            return new SecureEmbeddedServer(host, port, path);
        }
        return new EmbeddedServer(host, port, path);
    }

    public void start() throws AtlasBaseException {
        try {
            this.server.start();
            this.auditServerStatus();
            this.server.join();
        }
        catch (Exception e) {
            throw new AtlasBaseException(AtlasErrorCode.EMBEDDED_SERVER_START, (Throwable)e, new String[0]);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            LOG.warn("Error during shutdown", (Throwable)e);
        }
    }

    protected WebAppContext getWebAppContext(String path) {
        WebAppContext application = new WebAppContext(path, "/");
        application.setClassLoader(Thread.currentThread().getContextClassLoader());
        application.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        return application;
    }

    protected Connector getConnector(String host, int port) throws IOException {
        HttpConfiguration httpConfig = new HttpConfiguration();
        int bufferSize = AtlasConfiguration.WEBSERVER_REQUEST_BUFFER_SIZE.getInt();
        httpConfig.setResponseHeaderSize(bufferSize);
        httpConfig.setRequestHeaderSize(bufferSize);
        httpConfig.setSendServerVersion(false);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        connector.setPort(port);
        connector.setHost(host);
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auditServerStatus() {
        this.auditService = (AtlasAuditService)BeanUtil.getBean(AtlasAuditService.class);
        this.serviceState = (ServiceState)BeanUtil.getBean(ServiceState.class);
        ServiceState.ServiceStateValue serviceStateValue = this.serviceState.getState();
        if (serviceStateValue == ServiceState.ServiceStateValue.ACTIVE) {
            Date date = new Date();
            try {
                this.auditService.add(AtlasAuditEntry.AuditOperation.SERVER_START, SERVER_START_TIME, date, null, null, 0L);
                this.auditService.add(AtlasAuditEntry.AuditOperation.SERVER_STATE_ACTIVE, date, date, null, null, 0L);
            }
            catch (AtlasBaseException e) {
                LOG.error("Exception occurred during audit", (Throwable)e);
            }
            finally {
                RequestContext.clear();
            }
        }
    }
}

