/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.web.service.AtlasZookeeperSecurityProperties;
import org.apache.commons.configuration.Configuration;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class CuratorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorFactory.class);
    public static final String APACHE_ATLAS_LEADER_ELECTOR_PATH = "/leader_elector_path";
    public static final String SASL_SCHEME = "sasl";
    public static final String WORLD_SCHEME = "world";
    public static final String ANYONE_ID = "anyone";
    public static final String AUTH_SCHEME = "auth";
    public static final String DIGEST_SCHEME = "digest";
    public static final String IP_SCHEME = "ip";
    public static final String SETUP_LOCK = "/setup_lock";
    private final Configuration configuration;
    private CuratorFramework curatorFramework;

    public CuratorFactory() throws AtlasException {
        this(ApplicationProperties.get());
    }

    public CuratorFactory(Configuration configuration) {
        this.configuration = configuration;
        this.initializeCuratorFramework();
    }

    public void close() {
        this.curatorFramework.close();
    }

    public CuratorFramework clientInstance() {
        return this.curatorFramework;
    }

    public LeaderLatch leaderLatchInstance(String serverId, String zkRoot) {
        return new LeaderLatch(this.curatorFramework, zkRoot + APACHE_ATLAS_LEADER_ELECTOR_PATH, serverId);
    }

    public InterProcessMutex lockInstance(String zkRoot) {
        return new InterProcessMutex(this.curatorFramework, zkRoot + SETUP_LOCK);
    }

    @VisibleForTesting
    protected void initializeCuratorFramework() {
        HAConfiguration.ZookeeperProperties zookeeperProperties = HAConfiguration.getZookeeperProperties((Configuration)this.configuration);
        CuratorFrameworkFactory.Builder builder = this.getBuilder(zookeeperProperties);
        this.enhanceBuilderWithSecurityParameters(zookeeperProperties, builder);
        this.curatorFramework = builder.build();
        this.curatorFramework.start();
    }

    @VisibleForTesting
    void enhanceBuilderWithSecurityParameters(HAConfiguration.ZookeeperProperties zookeeperProperties, CuratorFrameworkFactory.Builder builder) {
        ACLProvider aclProvider = this.getAclProvider(zookeeperProperties);
        AuthInfo authInfo = null;
        if (zookeeperProperties.hasAuth()) {
            authInfo = AtlasZookeeperSecurityProperties.parseAuth(zookeeperProperties.getAuth());
        }
        if (aclProvider != null) {
            LOG.info("Setting up acl provider.");
            builder.aclProvider(aclProvider);
            if (authInfo != null) {
                byte[] auth = authInfo.getAuth();
                LOG.info("Setting up auth provider with scheme: {} and id: {}", (Object)authInfo.getScheme(), (Object)this.getIdForLogging(authInfo.getScheme(), new String(auth, Charsets.UTF_8)));
                builder.authorization(authInfo.getScheme(), auth);
            }
        }
    }

    private String getCurrentUser() {
        try {
            return UserGroupInformation.getCurrentUser().getUserName();
        }
        catch (IOException ioe) {
            return "unknown";
        }
    }

    private ACLProvider getAclProvider(HAConfiguration.ZookeeperProperties zookeeperProperties) {
        ACLProvider aclProvider = null;
        if (zookeeperProperties.hasAcl()) {
            ACL acl = AtlasZookeeperSecurityProperties.parseAcl(zookeeperProperties.getAcl());
            LOG.info("Setting ACL for id {} with scheme {} and perms {}.", new Object[]{this.getIdForLogging(acl.getId().getScheme(), acl.getId().getId()), acl.getId().getScheme(), acl.getPerms()});
            LOG.info("Current logged in user: {}", (Object)this.getCurrentUser());
            final List<ACL> acls = Collections.singletonList(acl);
            aclProvider = new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return acls;
                }

                public List<ACL> getAclForPath(String path) {
                    return acls;
                }
            };
        }
        return aclProvider;
    }

    private String getIdForLogging(String scheme, String id) {
        if (scheme.equalsIgnoreCase(SASL_SCHEME) || scheme.equalsIgnoreCase(IP_SCHEME)) {
            return id;
        }
        if (scheme.equalsIgnoreCase(WORLD_SCHEME)) {
            return ANYONE_ID;
        }
        if (scheme.equalsIgnoreCase(AUTH_SCHEME) || scheme.equalsIgnoreCase(DIGEST_SCHEME)) {
            return id.split(":")[0];
        }
        return "unknown";
    }

    private CuratorFrameworkFactory.Builder getBuilder(HAConfiguration.ZookeeperProperties zookeeperProperties) {
        return CuratorFrameworkFactory.builder().connectString(zookeeperProperties.getConnectString()).sessionTimeoutMs(zookeeperProperties.getSessionTimeout()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(zookeeperProperties.getRetriesSleepTimeMillis(), zookeeperProperties.getNumRetries()));
    }
}

