/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.web.service.AtlasZookeeperSecurityProperties;
import org.apache.atlas.web.service.CuratorFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ActiveInstanceState {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveInstanceState.class);
    public static final String APACHE_ATLAS_ACTIVE_SERVER_INFO = "/active_server_info";
    private final Configuration configuration;
    private final CuratorFactory curatorFactory;

    @Inject
    public ActiveInstanceState(CuratorFactory curatorFactory) throws AtlasException {
        this(ApplicationProperties.get(), curatorFactory);
    }

    public ActiveInstanceState(Configuration configuration, CuratorFactory curatorFactory) {
        this.configuration = configuration;
        this.curatorFactory = curatorFactory;
    }

    public void update(String serverId) throws AtlasBaseException {
        try {
            Stat serverInfo;
            CuratorFramework client = this.curatorFactory.clientInstance();
            HAConfiguration.ZookeeperProperties zookeeperProperties = HAConfiguration.getZookeeperProperties((Configuration)this.configuration);
            String atlasServerAddress = HAConfiguration.getBoundAddressForId((Configuration)this.configuration, (String)serverId);
            ArrayList<ACL> acls = new ArrayList<ACL>();
            ACL parsedACL = AtlasZookeeperSecurityProperties.parseAcl(zookeeperProperties.getAcl(), (ACL)ZooDefs.Ids.OPEN_ACL_UNSAFE.get(0));
            acls.add(parsedACL);
            if (StringUtils.isNotEmpty((String)zookeeperProperties.getAcl())) {
                ACL worldReadPermissionACL = new ACL(1, new Id("world", "anyone"));
                acls.add(worldReadPermissionACL);
            }
            if ((serverInfo = (Stat)client.checkExists().forPath(this.getZnodePath(zookeeperProperties))) == null) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.EPHEMERAL)).withACL(acls)).forPath(this.getZnodePath(zookeeperProperties));
            }
            client.setData().forPath(this.getZnodePath(zookeeperProperties), atlasServerAddress.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new AtlasBaseException(AtlasErrorCode.CURATOR_FRAMEWORK_UPDATE, (Throwable)e, new String[]{"forPath: getZnodePath"});
        }
    }

    public String getActiveServerAddress() {
        CuratorFramework client = this.curatorFactory.clientInstance();
        String serverAddress = null;
        try {
            HAConfiguration.ZookeeperProperties zookeeperProperties = HAConfiguration.getZookeeperProperties((Configuration)this.configuration);
            byte[] bytes = (byte[])client.getData().forPath(this.getZnodePath(zookeeperProperties));
            serverAddress = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("Error getting active server address", (Throwable)e);
        }
        return serverAddress;
    }

    private String getZnodePath(HAConfiguration.ZookeeperProperties zookeeperProperties) {
        return zookeeperProperties.getZkRoot() + APACHE_ATLAS_ACTIVE_SERVER_INFO;
    }
}

