/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.ha.AtlasServerIdSelector;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.listener.ActiveStateChangeHandler;
import org.apache.atlas.service.Service;
import org.apache.atlas.util.AtlasMetricsUtil;
import org.apache.atlas.web.service.ActiveInstanceState;
import org.apache.atlas.web.service.CuratorFactory;
import org.apache.atlas.web.service.ServiceState;
import org.apache.commons.configuration.Configuration;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ActiveInstanceElectorService
implements Service,
LeaderLatchListener {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveInstanceElectorService.class);
    private final Configuration configuration;
    private final ServiceState serviceState;
    private final ActiveInstanceState activeInstanceState;
    private final AtlasMetricsUtil metricsUtil;
    private final Set<ActiveStateChangeHandler> activeStateChangeHandlerProviders;
    private final List<ActiveStateChangeHandler> activeStateChangeHandlers;
    private final CuratorFactory curatorFactory;
    private LeaderLatch leaderLatch;
    private String serverId;

    @Inject
    ActiveInstanceElectorService(Configuration configuration, Set<ActiveStateChangeHandler> activeStateChangeHandlerProviders, CuratorFactory curatorFactory, ActiveInstanceState activeInstanceState, ServiceState serviceState, AtlasMetricsUtil metricsUtil) {
        this.configuration = configuration;
        this.activeStateChangeHandlerProviders = activeStateChangeHandlerProviders;
        this.activeStateChangeHandlers = new ArrayList<ActiveStateChangeHandler>();
        this.curatorFactory = curatorFactory;
        this.activeInstanceState = activeInstanceState;
        this.serviceState = serviceState;
        this.metricsUtil = metricsUtil;
    }

    public void start() throws AtlasException {
        this.metricsUtil.onServerStart();
        if (!HAConfiguration.isHAEnabled((Configuration)this.configuration)) {
            this.metricsUtil.onServerActivation();
            LOG.info("HA is not enabled, no need to start leader election service");
            return;
        }
        this.cacheActiveStateChangeHandlers();
        this.serverId = AtlasServerIdSelector.selectServerId((Configuration)this.configuration);
        this.joinElection();
    }

    public void stop() {
        if (!HAConfiguration.isHAEnabled((Configuration)this.configuration)) {
            LOG.info("HA is not enabled, no need to stop leader election service");
            return;
        }
        try {
            this.leaderLatch.close();
            this.curatorFactory.close();
        }
        catch (IOException e) {
            LOG.error("Error closing leader latch", (Throwable)e);
        }
    }

    public void isLeader() {
        LOG.warn("Server instance with server id {} is elected as leader", (Object)this.serverId);
        this.serviceState.becomingActive();
        try {
            for (ActiveStateChangeHandler handler : this.activeStateChangeHandlers) {
                handler.instanceIsActive();
            }
            this.activeInstanceState.update(this.serverId);
            this.serviceState.setActive();
            this.metricsUtil.onServerActivation();
        }
        catch (Exception e) {
            LOG.error("Got exception while activating", (Throwable)e);
            this.notLeader();
            this.rejoinElection();
        }
    }

    public void notLeader() {
        LOG.warn("Server instance with server id {} is removed as leader", (Object)this.serverId);
        this.serviceState.becomingPassive();
        for (int idx = this.activeStateChangeHandlers.size() - 1; idx >= 0; --idx) {
            try {
                this.activeStateChangeHandlers.get(idx).instanceIsPassive();
                continue;
            }
            catch (AtlasException e) {
                LOG.error("Error while reacting to passive state.", (Throwable)e);
            }
        }
        this.serviceState.setPassive();
    }

    private void joinElection() {
        LOG.info("Starting leader election for {}", (Object)this.serverId);
        String zkRoot = HAConfiguration.getZookeeperProperties((Configuration)this.configuration).getZkRoot();
        this.leaderLatch = this.curatorFactory.leaderLatchInstance(this.serverId, zkRoot);
        this.leaderLatch.addListener((LeaderLatchListener)this);
        try {
            this.leaderLatch.start();
            LOG.info("Leader latch started for {}.", (Object)this.serverId);
        }
        catch (Exception e) {
            LOG.info("Exception while starting leader latch for {}.", (Object)this.serverId, (Object)e);
        }
    }

    private void cacheActiveStateChangeHandlers() {
        if (this.activeStateChangeHandlers.isEmpty()) {
            this.activeStateChangeHandlers.addAll(this.activeStateChangeHandlerProviders);
            LOG.info("activeStateChangeHandlers(): before reorder: {}", this.activeStateChangeHandlers);
            this.activeStateChangeHandlers.sort(Comparator.comparingInt(ActiveStateChangeHandler::getHandlerOrder));
            LOG.info("activeStateChangeHandlers(): after reorder: {}", this.activeStateChangeHandlers);
        }
    }

    private void rejoinElection() {
        try {
            this.leaderLatch.close();
            this.joinElection();
        }
        catch (IOException e) {
            LOG.error("Error rejoining election", (Throwable)e);
        }
    }
}

