/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.web.model.User;
import org.apache.atlas.web.security.AtlasAbstractAuthenticationProvider;
import org.apache.atlas.web.security.AtlasAuthenticationException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.stereotype.Component;

@Component
public class AtlasLdapAuthenticationProvider
extends AtlasAbstractAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasLdapAuthenticationProvider.class);
    private String ldapURL;
    private String ldapUserDNPattern;
    private String ldapGroupSearchBase;
    private String ldapGroupSearchFilter;
    private String ldapGroupRoleAttribute;
    private String ldapBindDN;
    private String ldapBindPassword;
    private String ldapDefaultRole;
    private String ldapUserSearchFilter;
    private String ldapReferral;
    private String ldapBase;
    private boolean groupsFromUGI;

    @PostConstruct
    public void setup() {
        this.setLdapProperties();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            authentication = this.getLdapBindAuthentication(authentication);
            if (authentication != null && authentication.isAuthenticated()) {
                return authentication;
            }
            if ((authentication = this.getLdapAuthentication(authentication)) != null && authentication.isAuthenticated()) {
                return authentication;
            }
        }
        catch (Exception e) {
            throw new AtlasAuthenticationException(e.getMessage(), e.getCause());
        }
        return authentication;
    }

    private Authentication getLdapBindAuthentication(Authentication authentication) {
        try {
            LOG.debug("==> AtlasLdapAuthenticationProvider getLdapBindAuthentication");
            String userName = authentication.getName();
            String userPassword = "";
            if (authentication.getCredentials() != null) {
                userPassword = authentication.getCredentials().toString();
            }
            LdapContextSource ldapContextSource = this.getLdapContextSource();
            DefaultLdapAuthoritiesPopulator defaultLdapAuthoritiesPopulator = this.getDefaultLdapAuthoritiesPopulator(ldapContextSource);
            if (this.ldapUserSearchFilter == null || this.ldapUserSearchFilter.trim().isEmpty()) {
                this.ldapUserSearchFilter = "(uid={0})";
            }
            FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(this.ldapBase, this.ldapUserSearchFilter, (BaseLdapPathContextSource)ldapContextSource);
            userSearch.setSearchSubtree(true);
            BindAuthenticator bindAuthenticator = this.getBindAuthenticator(userSearch, ldapContextSource);
            LdapAuthenticationProvider ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator, (LdapAuthoritiesPopulator)defaultLdapAuthoritiesPopulator);
            if (userName != null && userPassword != null && !userName.trim().isEmpty() && !userPassword.trim().isEmpty()) {
                List<GrantedAuthority> grantedAuths = this.getAuthorities(userName);
                User principal = new User(userName, userPassword, grantedAuths);
                UsernamePasswordAuthenticationToken finalAuthentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)userPassword, grantedAuths);
                authentication = ldapAuthenticationProvider.authenticate((Authentication)finalAuthentication);
                if (this.groupsFromUGI) {
                    authentication = this.getAuthenticationWithGrantedAuthorityFromUGI(authentication);
                }
                return authentication;
            }
            LOG.error("LDAP Authentication::userName or userPassword is null or empty for userName {}", (Object)userName);
        }
        catch (Exception e) {
            LOG.error(" getLdapBindAuthentication LDAP Authentication Failed:", (Throwable)e);
        }
        LOG.debug("<== AtlasLdapAuthenticationProvider getLdapBindAuthentication");
        return authentication;
    }

    private Authentication getLdapAuthentication(Authentication authentication) {
        LOG.debug("==> AtlasLdapAuthenticationProvider getLdapAuthentication");
        try {
            LdapAuthenticationProvider ldapAuthenticationProvider;
            String userName = authentication.getName();
            String userPassword = "";
            if (authentication.getCredentials() != null) {
                userPassword = authentication.getCredentials().toString();
            }
            DefaultSpringSecurityContextSource ldapContextSource = new DefaultSpringSecurityContextSource(this.ldapURL);
            ldapContextSource.setCacheEnvironmentProperties(false);
            ldapContextSource.setAnonymousReadOnly(true);
            BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)ldapContextSource);
            String[] userDnPatterns = this.ldapUserDNPattern.split(";");
            bindAuthenticator.setUserDnPatterns(userDnPatterns);
            if (!StringUtils.isEmpty((String)this.ldapGroupSearchBase) && !StringUtils.isEmpty((String)this.ldapGroupSearchFilter)) {
                DefaultLdapAuthoritiesPopulator defaultLdapAuthoritiesPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)ldapContextSource, this.ldapGroupSearchBase);
                defaultLdapAuthoritiesPopulator.setGroupRoleAttribute(this.ldapGroupRoleAttribute);
                defaultLdapAuthoritiesPopulator.setGroupSearchFilter(this.ldapGroupSearchFilter);
                defaultLdapAuthoritiesPopulator.setIgnorePartialResultException(true);
                ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator, (LdapAuthoritiesPopulator)defaultLdapAuthoritiesPopulator);
            } else {
                ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator);
            }
            if (userName != null && userPassword != null && !userName.trim().isEmpty() && !userPassword.trim().isEmpty()) {
                List<GrantedAuthority> grantedAuths = this.getAuthorities(userName);
                User principal = new User(userName, userPassword, grantedAuths);
                UsernamePasswordAuthenticationToken finalAuthentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)userPassword, grantedAuths);
                authentication = ldapAuthenticationProvider.authenticate((Authentication)finalAuthentication);
                if (this.groupsFromUGI) {
                    authentication = this.getAuthenticationWithGrantedAuthorityFromUGI(authentication);
                }
                return authentication;
            }
            return authentication;
        }
        catch (Exception e) {
            LOG.error("getLdapAuthentication LDAP Authentication Failed:", (Throwable)e);
            LOG.debug("<== AtlasLdapAuthenticationProvider getLdapAuthentication");
            return authentication;
        }
    }

    private void setLdapProperties() {
        try {
            Configuration configuration = ApplicationProperties.get();
            Properties properties = ConfigurationConverter.getProperties((Configuration)configuration.subset("atlas.authentication.method.ldap"));
            this.ldapURL = properties.getProperty("url");
            this.ldapUserDNPattern = properties.getProperty("userDNpattern");
            this.ldapGroupSearchBase = properties.getProperty("groupSearchBase");
            this.ldapGroupSearchFilter = properties.getProperty("groupSearchFilter");
            this.ldapGroupRoleAttribute = properties.getProperty("groupRoleAttribute");
            this.ldapBindDN = properties.getProperty("bind.dn");
            this.ldapBindPassword = properties.getProperty("bind.password");
            this.ldapDefaultRole = properties.getProperty("default.role");
            this.ldapUserSearchFilter = properties.getProperty("user.searchfilter");
            this.ldapReferral = properties.getProperty("referral");
            this.ldapBase = properties.getProperty("base.dn");
            this.groupsFromUGI = configuration.getBoolean("atlas.authentication.method.ldap.ugi-groups", true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("AtlasLdapAuthenticationProvider{ldapURL='{}', ldapUserDNPattern='{}', ldapGroupSearchBase='{}', ldapGroupSearchFilter='{}', ldapGroupRoleAttribute='{}', ldapBindDN='{}', ldapDefaultRole='{}', ldapUserSearchFilter='{}', ldapReferral='{}', ldapBase='{}', groupsFromUGI={}}", new Object[]{this.ldapURL, this.ldapUserDNPattern, this.ldapGroupSearchBase, this.ldapGroupSearchFilter, this.ldapGroupRoleAttribute, this.ldapBindDN, this.ldapDefaultRole, this.ldapUserSearchFilter, this.ldapReferral, this.ldapBase, this.groupsFromUGI});
            }
        }
        catch (Exception e) {
            LOG.error("Exception while setLdapProperties", (Throwable)e);
        }
    }

    private LdapContextSource getLdapContextSource() {
        DefaultSpringSecurityContextSource ldapContextSource = new DefaultSpringSecurityContextSource(this.ldapURL);
        ldapContextSource.setUserDn(this.ldapBindDN);
        ldapContextSource.setPassword(this.ldapBindPassword);
        ldapContextSource.setReferral(this.ldapReferral);
        ldapContextSource.setCacheEnvironmentProperties(false);
        ldapContextSource.setAnonymousReadOnly(false);
        ldapContextSource.setPooled(true);
        ldapContextSource.afterPropertiesSet();
        return ldapContextSource;
    }

    private DefaultLdapAuthoritiesPopulator getDefaultLdapAuthoritiesPopulator(LdapContextSource ldapContextSource) {
        DefaultLdapAuthoritiesPopulator defaultLdapAuthoritiesPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)ldapContextSource, this.ldapGroupSearchBase);
        defaultLdapAuthoritiesPopulator.setGroupRoleAttribute(this.ldapGroupRoleAttribute);
        defaultLdapAuthoritiesPopulator.setGroupSearchFilter(this.ldapGroupSearchFilter);
        defaultLdapAuthoritiesPopulator.setIgnorePartialResultException(true);
        return defaultLdapAuthoritiesPopulator;
    }

    private BindAuthenticator getBindAuthenticator(FilterBasedLdapUserSearch userSearch, LdapContextSource ldapContextSource) {
        BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)ldapContextSource);
        bindAuthenticator.setUserSearch((LdapUserSearch)userSearch);
        String[] userDnPatterns = new String[]{this.ldapUserDNPattern};
        bindAuthenticator.setUserDnPatterns(userDnPatterns);
        bindAuthenticator.afterPropertiesSet();
        return bindAuthenticator;
    }
}

