/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.util.Collection;
import javax.inject.Inject;
import org.apache.atlas.web.dao.UserDao;
import org.apache.atlas.web.security.AtlasAbstractAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;

@Component
public class AtlasFileAuthenticationProvider
extends AtlasAbstractAuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(AtlasFileAuthenticationProvider.class);
    private final UserDetailsService userDetailsService;

    @Inject
    public AtlasFileAuthenticationProvider(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        if (username == null || username.isEmpty()) {
            logger.error("Username can't be null or empty.");
            throw new BadCredentialsException("Username can't be null or empty.");
        }
        if (password == null || password.isEmpty()) {
            logger.error("Password can't be null or empty.");
            throw new BadCredentialsException("Password can't be null or empty.");
        }
        UserDetails user = this.userDetailsService.loadUserByUsername(username);
        boolean isValidPassword = UserDao.checkEncrypted(password, user.getPassword(), username);
        if (!isValidPassword) {
            logger.error("Wrong password {}", (Object)username);
            throw new BadCredentialsException("Wrong password");
        }
        Collection authorities = user.getAuthorities();
        authentication = new UsernamePasswordAuthenticationToken((Object)username, (Object)password, authorities);
        return authentication;
    }
}

