/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.atlas.AtlasConfiguration;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class AtlasAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthenticationSuccessHandler.class);
    public static final String LOCALLOGIN = "locallogin";
    private int sessionTimeout = 3600;

    @PostConstruct
    public void setup() {
        this.sessionTimeout = AtlasConfiguration.SESSION_TIMEOUT_SECS.getInt();
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        LOG.debug("Login Success {}", authentication.getPrincipal());
        JSONObject json = new JSONObject();
        json.put((Object)"msgDesc", (Object)"Success");
        if (request.getSession() != null) {
            request.getSession().setAttribute(LOCALLOGIN, (Object)"true");
            request.getServletContext().setAttribute(request.getSession().getId(), (Object)LOCALLOGIN);
            if (this.sessionTimeout != -1) {
                request.getSession().setMaxInactiveInterval(this.sessionTimeout);
            }
        }
        response.setContentType("application/json");
        response.setStatus(200);
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(json.toJSONString());
    }
}

