/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.web.security.AtlasADAuthenticationProvider;
import org.apache.atlas.web.security.AtlasAbstractAuthenticationProvider;
import org.apache.atlas.web.security.AtlasAuthenticationException;
import org.apache.atlas.web.security.AtlasFileAuthenticationProvider;
import org.apache.atlas.web.security.AtlasKeycloakAuthenticationProvider;
import org.apache.atlas.web.security.AtlasLdapAuthenticationProvider;
import org.apache.atlas.web.security.AtlasPamAuthenticationProvider;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class AtlasAuthenticationProvider
extends AtlasAbstractAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthenticationProvider.class);
    public static final String FILE_AUTH_METHOD = "atlas.authentication.method.file";
    public static final String LDAP_AUTH_METHOD = "atlas.authentication.method.ldap";
    public static final String LDAP_TYPE = "atlas.authentication.method.ldap.type";
    public static final String PAM_AUTH_METHOD = "atlas.authentication.method.pam";
    public static final String KEYCLOAK_AUTH_METHOD = "atlas.authentication.method.keycloak";
    final AtlasLdapAuthenticationProvider ldapAuthenticationProvider;
    final AtlasFileAuthenticationProvider fileAuthenticationProvider;
    final AtlasADAuthenticationProvider adAuthenticationProvider;
    final AtlasPamAuthenticationProvider pamAuthenticationProvider;
    final AtlasKeycloakAuthenticationProvider atlasKeycloakAuthenticationProvider;
    private boolean fileAuthenticationMethodEnabled = true;
    private boolean pamAuthenticationEnabled;
    private boolean keycloakAuthenticationEnabled;
    private String ldapType = "NONE";
    private boolean ssoEnabled;

    @Inject
    public AtlasAuthenticationProvider(AtlasLdapAuthenticationProvider ldapAuthenticationProvider, AtlasFileAuthenticationProvider fileAuthenticationProvider, AtlasADAuthenticationProvider adAuthenticationProvider, AtlasPamAuthenticationProvider pamAuthenticationProvider, AtlasKeycloakAuthenticationProvider atlasKeycloakAuthenticationProvider) {
        this.ldapAuthenticationProvider = ldapAuthenticationProvider;
        this.fileAuthenticationProvider = fileAuthenticationProvider;
        this.adAuthenticationProvider = adAuthenticationProvider;
        this.pamAuthenticationProvider = pamAuthenticationProvider;
        this.atlasKeycloakAuthenticationProvider = atlasKeycloakAuthenticationProvider;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (this.ssoEnabled) {
            if (authentication != null && (authentication = this.getSSOAuthentication(authentication)) != null && authentication.isAuthenticated()) {
                return authentication;
            }
        } else if (this.ldapType.equalsIgnoreCase("LDAP")) {
            try {
                authentication = this.ldapAuthenticationProvider.authenticate(authentication);
            }
            catch (Exception ex) {
                LOG.error("Error while LDAP authentication", (Throwable)ex);
            }
        } else if (this.ldapType.equalsIgnoreCase("AD")) {
            try {
                authentication = this.adAuthenticationProvider.authenticate(authentication);
            }
            catch (Exception ex) {
                LOG.error("Error while AD authentication", (Throwable)ex);
            }
        } else if (this.pamAuthenticationEnabled) {
            try {
                authentication = this.pamAuthenticationProvider.authenticate(authentication);
            }
            catch (Exception ex) {
                LOG.error("Error while PAM authentication", (Throwable)ex);
            }
        } else if (this.keycloakAuthenticationEnabled) {
            try {
                authentication = this.atlasKeycloakAuthenticationProvider.authenticate(authentication);
            }
            catch (Exception ex) {
                LOG.error("Error while Keycloak authentication", (Throwable)ex);
            }
        }
        if (authentication != null) {
            if (authentication.isAuthenticated()) {
                return authentication;
            }
            if (this.fileAuthenticationMethodEnabled && (authentication = this.fileAuthenticationProvider.authenticate(authentication)) != null && authentication.isAuthenticated()) {
                return authentication;
            }
        }
        LOG.error("Authentication failed.");
        throw new AtlasAuthenticationException("Authentication failed.");
    }

    @Override
    public boolean supports(Class<?> authentication) {
        if (this.pamAuthenticationEnabled) {
            return this.pamAuthenticationProvider.supports(authentication);
        }
        if (this.ldapType.equalsIgnoreCase("LDAP")) {
            return this.ldapAuthenticationProvider.supports(authentication);
        }
        if (this.ldapType.equalsIgnoreCase("AD")) {
            return this.adAuthenticationProvider.supports(authentication);
        }
        if (this.keycloakAuthenticationEnabled) {
            return this.atlasKeycloakAuthenticationProvider.supports(authentication);
        }
        return super.supports(authentication);
    }

    public boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    public void setSsoEnabled(boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    @PostConstruct
    void setAuthenticationMethod() {
        try {
            Configuration configuration = ApplicationProperties.get();
            this.fileAuthenticationMethodEnabled = configuration.getBoolean(FILE_AUTH_METHOD, true);
            this.pamAuthenticationEnabled = configuration.getBoolean(PAM_AUTH_METHOD, false);
            this.keycloakAuthenticationEnabled = configuration.getBoolean(KEYCLOAK_AUTH_METHOD, false);
            boolean ldapAuthenticationEnabled = configuration.getBoolean(LDAP_AUTH_METHOD, false);
            this.ldapType = ldapAuthenticationEnabled ? configuration.getString(LDAP_TYPE, "NONE") : "NONE";
        }
        catch (Exception e) {
            LOG.error("Error while getting atlas.login.method application properties", (Throwable)e);
        }
    }

    private Authentication getSSOAuthentication(Authentication authentication) throws AuthenticationException {
        return authentication;
    }
}

