/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;

public abstract class AtlasAbstractAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAbstractAuthenticationProvider.class);

    public static List<GrantedAuthority> getAuthoritiesFromUGI(String userName) {
        HashSet userGroups = new HashSet();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)userName);
        if (ugi != null) {
            Object[] groups = ugi.getGroupNames();
            if (LOG.isDebugEnabled()) {
                LOG.debug("UserGroupInformation userGroups=" + Arrays.toString(groups));
            }
            if (groups != null) {
                Collections.addAll(userGroups, groups);
            }
        }
        if (CollectionUtils.isEmpty(userGroups) || AuthenticationUtil.includeHadoopGroups()) {
            try {
                Configuration config = new Configuration();
                Groups gp = new Groups(config);
                List groups = gp.getGroups(userName);
                LOG.debug("Hadoop userGroups={}", (Object)groups);
                if (groups != null) {
                    userGroups.addAll(groups);
                }
            }
            catch (IOException e) {
                LOG.error("Exception while fetching groups ", (Throwable)e);
            }
        }
        ArrayList<GrantedAuthority> ret = new ArrayList<GrantedAuthority>();
        for (String userGroup : userGroups) {
            ret.add((GrantedAuthority)new SimpleGrantedAuthority(userGroup));
        }
        return ret;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public Authentication getAuthenticationWithGrantedAuthority(Authentication authentication) {
        if (authentication != null && authentication.isAuthenticated()) {
            List<GrantedAuthority> grantedAuths = this.getAuthorities(authentication.getName());
            User userDetails = new User(authentication.getName(), authentication.getCredentials().toString(), grantedAuths);
            UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)userDetails, authentication.getCredentials(), grantedAuths);
            result.setDetails(authentication.getDetails());
            return result;
        }
        return authentication;
    }

    public Authentication getAuthenticationWithGrantedAuthorityFromUGI(Authentication authentication) {
        if (authentication != null && authentication.isAuthenticated()) {
            List<GrantedAuthority> grantedAuthsUGI = AtlasAbstractAuthenticationProvider.getAuthoritiesFromUGI(authentication.getName());
            User userDetails = new User(authentication.getName(), authentication.getCredentials().toString(), grantedAuthsUGI);
            UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)userDetails, authentication.getCredentials(), grantedAuthsUGI);
            result.setDetails(authentication.getDetails());
            return result;
        }
        return authentication;
    }

    protected List<GrantedAuthority> getAuthorities(String username) {
        ArrayList<GrantedAuthority> grantedAuths = new ArrayList<GrantedAuthority>();
        grantedAuths.add((GrantedAuthority)new SimpleGrantedAuthority("DATA_SCIENTIST"));
        return grantedAuths;
    }
}

