/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.rest;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.atlas.annotation.Timed;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypeDefHeader;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.util.FilterUtil;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.web.util.Servlets;
import org.apache.http.annotation.Experimental;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Path(value="v2/types")
@Singleton
@Service
@Consumes(value={"application/json; charset=UTF-8", "application/json"})
@Produces(value={"application/json; charset=UTF-8", "application/json"})
public class TypesREST {
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.TypesREST");
    private final AtlasTypeDefStore typeDefStore;

    @Inject
    public TypesREST(AtlasTypeDefStore typeDefStore) {
        this.typeDefStore = typeDefStore;
    }

    @GET
    @Path(value="/typedef/name/{name}")
    @Timed
    public AtlasBaseTypeDef getTypeDefByName(@PathParam(value="name") String name) throws AtlasBaseException {
        Servlets.validateQueryParamLength("name", name);
        return this.typeDefStore.getByName(name);
    }

    @GET
    @Path(value="/typedef/guid/{guid}")
    @Timed
    public AtlasBaseTypeDef getTypeDefByGuid(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        return this.typeDefStore.getByGuid(guid);
    }

    @GET
    @Path(value="/typedefs/headers")
    @Timed
    public List<AtlasTypeDefHeader> getTypeDefHeaders(@Context HttpServletRequest httpServletRequest) throws AtlasBaseException {
        SearchFilter searchFilter = this.getSearchFilter(httpServletRequest);
        AtlasTypesDef searchTypesDef = this.typeDefStore.searchTypesDef(searchFilter);
        return AtlasTypeUtil.toTypeDefHeader((AtlasTypesDef)searchTypesDef);
    }

    @GET
    @Path(value="/typedefs")
    @Timed
    public AtlasTypesDef getAllTypeDefs(@Context HttpServletRequest httpServletRequest) throws AtlasBaseException {
        SearchFilter searchFilter = this.getSearchFilter(httpServletRequest);
        return this.typeDefStore.searchTypesDef(searchFilter);
    }

    @GET
    @Path(value="/enumdef/name/{name}")
    @Timed
    public AtlasEnumDef getEnumDefByName(@PathParam(value="name") String name) throws AtlasBaseException {
        Servlets.validateQueryParamLength("name", name);
        return this.typeDefStore.getEnumDefByName(name);
    }

    @GET
    @Path(value="/enumdef/guid/{guid}")
    @Timed
    public AtlasEnumDef getEnumDefByGuid(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        return this.typeDefStore.getEnumDefByGuid(guid);
    }

    @GET
    @Path(value="/structdef/name/{name}")
    @Timed
    public AtlasStructDef getStructDefByName(@PathParam(value="name") String name) throws AtlasBaseException {
        Servlets.validateQueryParamLength("name", name);
        return this.typeDefStore.getStructDefByName(name);
    }

    @GET
    @Path(value="/structdef/guid/{guid}")
    @Timed
    public AtlasStructDef getStructDefByGuid(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        return this.typeDefStore.getStructDefByGuid(guid);
    }

    @GET
    @Path(value="/classificationdef/name/{name}")
    @Timed
    public AtlasClassificationDef getClassificationDefByName(@PathParam(value="name") String name) throws AtlasBaseException {
        Servlets.validateQueryParamLength("name", name);
        return this.typeDefStore.getClassificationDefByName(name);
    }

    @GET
    @Path(value="/classificationdef/guid/{guid}")
    @Timed
    public AtlasClassificationDef getClassificationDefByGuid(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        return this.typeDefStore.getClassificationDefByGuid(guid);
    }

    @GET
    @Path(value="/entitydef/name/{name}")
    @Timed
    public AtlasEntityDef getEntityDefByName(@PathParam(value="name") String name) throws AtlasBaseException {
        Servlets.validateQueryParamLength("name", name);
        return this.typeDefStore.getEntityDefByName(name);
    }

    @GET
    @Path(value="/entitydef/guid/{guid}")
    @Timed
    public AtlasEntityDef getEntityDefByGuid(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        return this.typeDefStore.getEntityDefByGuid(guid);
    }

    @GET
    @Path(value="/relationshipdef/name/{name}")
    @Timed
    public AtlasRelationshipDef getRelationshipDefByName(@PathParam(value="name") String name) throws AtlasBaseException {
        Servlets.validateQueryParamLength("name", name);
        return this.typeDefStore.getRelationshipDefByName(name);
    }

    @GET
    @Path(value="/relationshipdef/guid/{guid}")
    @Timed
    public AtlasRelationshipDef getRelationshipDefByGuid(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        return this.typeDefStore.getRelationshipDefByGuid(guid);
    }

    @GET
    @Path(value="/businessmetadatadef/guid/{guid}")
    @Timed
    public AtlasBusinessMetadataDef getBusinessMetadataDefByGuid(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        return this.typeDefStore.getBusinessMetadataDefByGuid(guid);
    }

    @GET
    @Path(value="/businessmetadatadef/name/{name}")
    @Timed
    public AtlasBusinessMetadataDef getBusinessMetadataDefByName(@PathParam(value="name") String name) throws AtlasBaseException {
        Servlets.validateQueryParamLength("name", name);
        return this.typeDefStore.getBusinessMetadataDefByName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/typedefs")
    @Timed
    public AtlasTypesDef createAtlasTypeDefs(AtlasTypesDef typesDef) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("TypesREST.createAtlasTypeDefs(" + AtlasTypeUtil.toDebugString((AtlasTypesDef)typesDef) + ")"));
            }
            AtlasTypesDef atlasTypesDef = this.typeDefStore.createTypesDef(typesDef);
            return atlasTypesDef;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/typedefs")
    @Timed
    @Experimental
    public AtlasTypesDef updateAtlasTypeDefs(AtlasTypesDef typesDef) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("TypesREST.updateAtlasTypeDefs(" + AtlasTypeUtil.toDebugString((AtlasTypesDef)typesDef) + ")"));
            }
            AtlasTypesDef atlasTypesDef = this.typeDefStore.updateTypesDef(typesDef);
            return atlasTypesDef;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    @DELETE
    @Path(value="/typedefs")
    @Timed
    @Experimental
    public void deleteAtlasTypeDefs(AtlasTypesDef typesDef) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("TypesREST.deleteAtlasTypeDefs(" + AtlasTypeUtil.toDebugString((AtlasTypesDef)typesDef) + ")"));
            }
            this.typeDefStore.deleteTypesDef(typesDef);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    @DELETE
    @Path(value="/typedef/name/{typeName}")
    @Timed
    public void deleteAtlasTypeByName(@PathParam(value="typeName") String typeName) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("TypesREST.deleteAtlasTypeByName(" + typeName + ")"));
            }
            this.typeDefStore.deleteTypeByName(typeName);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    private SearchFilter getSearchFilter(HttpServletRequest httpServletRequest) {
        SearchFilter ret = new SearchFilter();
        Set keySet = httpServletRequest.getParameterMap().keySet();
        for (String k : keySet) {
            String key = String.valueOf(k);
            String value = String.valueOf(httpServletRequest.getParameter(k));
            if (key.equalsIgnoreCase("excludeInternalTypesAndReferences") && value.equalsIgnoreCase("true")) {
                FilterUtil.addParamsToHideInternalType((SearchFilter)ret);
                continue;
            }
            ret.setParam(key, value);
        }
        return ret;
    }
}

