/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.rest;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.annotation.Timed;
import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.IndexRecoveryService;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Service;

@Path(value="v2/indexrecovery")
@Singleton
@Service
@Consumes(value={"application/json; charset=UTF-8", "application/json"})
@Produces(value={"application/json; charset=UTF-8", "application/json"})
public class IndexRecoveryREST {
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.IndexRecoveryREST");
    private final IndexRecoveryService indexRecoveryService;
    private final AtlasGraph graph;

    @Inject
    IndexRecoveryREST(IndexRecoveryService indexRecoveryService, AtlasGraph graph) {
        this.indexRecoveryService = indexRecoveryService;
        this.graph = graph;
    }

    public static String getPropertyKeyByRemovingPrefix(String propertyKey) {
        return StringUtils.removeStart((String)propertyKey, (String)"__idxRecovery_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Timed
    public Map<String, String> getIndexRecoveryData() {
        AtlasPerfTracer perf = null;
        Long startTime = null;
        Long prevTime = null;
        Long customStartTime = null;
        HashMap<String, String> indexRecoveryData = new HashMap<String, String>();
        try {
            AtlasVertex indexRecoveryVertex;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"IndexRecoveryREST.getIndexRecoveryData()");
            }
            if ((indexRecoveryVertex = this.indexRecoveryService.recoveryInfoManagement.findVertex()) != null) {
                startTime = (Long)indexRecoveryVertex.getProperty(Constants.PROPERTY_KEY_INDEX_RECOVERY_START_TIME, Long.class);
                prevTime = (Long)indexRecoveryVertex.getProperty(Constants.PROPERTY_KEY_INDEX_RECOVERY_PREV_TIME, Long.class);
                customStartTime = (Long)indexRecoveryVertex.getProperty(Constants.PROPERTY_KEY_INDEX_RECOVERY_CUSTOM_TIME, Long.class);
            }
            indexRecoveryData.put(IndexRecoveryREST.getPropertyKeyByRemovingPrefix(Constants.PROPERTY_KEY_INDEX_RECOVERY_START_TIME), startTime != null ? Instant.ofEpochMilli(startTime).toString() : "Not applicable");
            indexRecoveryData.put(IndexRecoveryREST.getPropertyKeyByRemovingPrefix(Constants.PROPERTY_KEY_INDEX_RECOVERY_PREV_TIME), prevTime != null ? Instant.ofEpochMilli(prevTime).toString() : "Not applicable");
            indexRecoveryData.put(IndexRecoveryREST.getPropertyKeyByRemovingPrefix(Constants.PROPERTY_KEY_INDEX_RECOVERY_CUSTOM_TIME), customStartTime != null ? Instant.ofEpochMilli(customStartTime).toString() : "Not applicable");
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return indexRecoveryData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/start")
    public void startCustomIndexRecovery(@QueryParam(value="startTime") @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") String startTime) throws AtlasBaseException, AtlasException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"IndexRecoveryREST.getIndexRecoveryData()");
            }
            AtlasAuthorizationUtils.verifyAccess((AtlasAdminAccessRequest)new AtlasAdminAccessRequest(AtlasPrivilege.ADMIN_IMPORT), (Object[])new Object[]{"to start dynamic index recovery by custom time"});
            if (startTime == null) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Index Recovery requested without start time"});
            }
            if (!this.indexRecoveryService.recoveryThread.isIndexBackendHealthy()) {
                throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, new String[]{"Index recovery can not be started - Solr Health: Unhealthy"});
            }
            long startTimeMilli = Instant.parse(startTime).toEpochMilli();
            this.indexRecoveryService.recoveryThread.stopMonitoringByUserRequest();
            this.indexRecoveryService.recoveryThread.startMonitoringByUserRequest(Long.valueOf(startTimeMilli));
            this.indexRecoveryService.recoveryInfoManagement.updateCustomStartTime(startTimeMilli);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }
}

