/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.rest;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.Timed;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.bulkimport.BulkImportResponse;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasEntityHeaders;
import org.apache.atlas.model.instance.ClassificationAssociateRequest;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.ClassificationAssociator;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.FileUtils;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="v2/entity")
@Singleton
@Service
@Consumes(value={"application/json; charset=UTF-8", "application/json"})
@Produces(value={"application/json; charset=UTF-8", "application/json"})
public class EntityREST {
    private static final Logger LOG = LoggerFactory.getLogger(EntityREST.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.EntityREST");
    public static final String PREFIX_ATTR = "attr:";
    public static final String PREFIX_ATTR_ = "attr_";
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasEntityStore entitiesStore;
    private final EntityAuditRepository auditRepository;
    private final AtlasInstanceConverter instanceConverter;

    @Inject
    public EntityREST(AtlasTypeRegistry typeRegistry, AtlasEntityStore entitiesStore, EntityAuditRepository auditRepository, AtlasInstanceConverter instanceConverter) {
        this.typeRegistry = typeRegistry;
        this.entitiesStore = entitiesStore;
        this.auditRepository = auditRepository;
        this.instanceConverter = instanceConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/guid/{guid}")
    @Timed
    public AtlasEntity.AtlasEntityWithExtInfo getById(@PathParam(value="guid") String guid, @QueryParam(value="minExtInfo") @DefaultValue(value="false") boolean minExtInfo, @QueryParam(value="ignoreRelationships") @DefaultValue(value="false") boolean ignoreRelationships) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getById(" + guid + ", " + minExtInfo + " )"));
            }
            AtlasEntity.AtlasEntityWithExtInfo atlasEntityWithExtInfo = this.entitiesStore.getById(guid, minExtInfo, ignoreRelationships);
            return atlasEntityWithExtInfo;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/guid/{guid}/header")
    @Timed
    public AtlasEntityHeader getHeaderById(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getHeaderById(" + guid + ")"));
            }
            AtlasEntityHeader atlasEntityHeader = this.entitiesStore.getHeaderById(guid);
            return atlasEntityHeader;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/uniqueAttribute/type/{typeName}/header")
    @Timed
    public AtlasEntityHeader getEntityHeaderByUniqueAttributes(@PathParam(value="typeName") String typeName, @Context HttpServletRequest servletRequest) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> attributes = this.getAttributes(servletRequest);
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getEntityHeaderByUniqueAttributes(" + typeName + "," + attributes + ")"));
            }
            AtlasEntityType entityType = this.ensureEntityType(typeName);
            this.validateUniqueAttribute(entityType, attributes);
            AtlasEntityHeader atlasEntityHeader = this.entitiesStore.getEntityHeaderByUniqueAttributes(entityType, attributes);
            return atlasEntityHeader;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/uniqueAttribute/type/{typeName}")
    @Timed
    public AtlasEntity.AtlasEntityWithExtInfo getByUniqueAttributes(@PathParam(value="typeName") String typeName, @QueryParam(value="minExtInfo") @DefaultValue(value="false") boolean minExtInfo, @QueryParam(value="ignoreRelationships") @DefaultValue(value="false") boolean ignoreRelationships, @Context HttpServletRequest servletRequest) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo atlasEntityWithExtInfo;
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> attributes = this.getAttributes(servletRequest);
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getByUniqueAttributes(" + typeName + "," + attributes + ")"));
            }
            AtlasEntityType entityType = this.ensureEntityType(typeName);
            this.validateUniqueAttribute(entityType, attributes);
            atlasEntityWithExtInfo = this.entitiesStore.getByUniqueAttributes(entityType, attributes, minExtInfo, ignoreRelationships);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasEntityWithExtInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/uniqueAttribute/type/{typeName}")
    @Timed
    public EntityMutationResponse partialUpdateEntityByUniqueAttrs(@PathParam(value="typeName") String typeName, @Context HttpServletRequest servletRequest, AtlasEntity.AtlasEntityWithExtInfo entityInfo) throws Exception {
        EntityMutationResponse entityMutationResponse;
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> uniqueAttributes = this.getAttributes(servletRequest);
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.partialUpdateEntityByUniqueAttrs(" + typeName + "," + uniqueAttributes + ")"));
            }
            AtlasEntityType entityType = this.ensureEntityType(typeName);
            this.validateUniqueAttribute(entityType, uniqueAttributes);
            entityMutationResponse = this.entitiesStore.updateByUniqueAttributes(entityType, uniqueAttributes, entityInfo);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return entityMutationResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/uniqueAttribute/type/{typeName}")
    @Timed
    public EntityMutationResponse deleteByUniqueAttribute(@PathParam(value="typeName") String typeName, @Context HttpServletRequest servletRequest) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> attributes = this.getAttributes(servletRequest);
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.deleteByUniqueAttribute(" + typeName + "," + attributes + ")"));
            }
            AtlasEntityType entityType = this.ensureEntityType(typeName);
            EntityMutationResponse entityMutationResponse = this.entitiesStore.deleteByUniqueAttributes(entityType, attributes);
            return entityMutationResponse;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Timed
    public EntityMutationResponse createOrUpdate(AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasBaseException {
        EntityMutationResponse entityMutationResponse;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"EntityREST.createOrUpdate()");
            }
            entityMutationResponse = this.entitiesStore.createOrUpdate((EntityStream)new AtlasEntityStream(entity), false);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return entityMutationResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/guid/{guid}")
    @Timed
    public EntityMutationResponse partialUpdateEntityAttrByGuid(@PathParam(value="guid") String guid, @QueryParam(value="name") String attrName, Object attrValue) throws Exception {
        Servlets.validateQueryParamLength("guid", guid);
        Servlets.validateQueryParamLength("name", attrName);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.partialUpdateEntityAttrByGuid(" + guid + "," + attrName + ")"));
            }
            EntityMutationResponse entityMutationResponse = this.entitiesStore.updateEntityAttributeByGuid(guid, attrName, attrValue);
            return entityMutationResponse;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/guid/{guid}")
    @Timed
    public EntityMutationResponse deleteByGuid(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.deleteByGuid(" + guid + ")"));
            }
            EntityMutationResponse entityMutationResponse = this.entitiesStore.deleteById(guid);
            return entityMutationResponse;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/guid/{guid}/classification/{classificationName}")
    @Timed
    public AtlasClassification getClassification(@PathParam(value="guid") String guid, @PathParam(value="classificationName") String classificationName) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        Servlets.validateQueryParamLength("classificationName", classificationName);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getClassification(" + guid + "," + classificationName + ")"));
            }
            if (StringUtils.isEmpty((CharSequence)guid)) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
            }
            this.ensureClassificationType(classificationName);
            AtlasClassification atlasClassification = this.entitiesStore.getClassification(guid, classificationName);
            return atlasClassification;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/guid/{guid}/classifications")
    @Timed
    public AtlasClassification.AtlasClassifications getClassifications(@PathParam(value="guid") String guid) throws AtlasBaseException {
        AtlasClassification.AtlasClassifications atlasClassifications;
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getClassifications(" + guid + ")"));
            }
            if (StringUtils.isEmpty((CharSequence)guid)) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
            }
            atlasClassifications = new AtlasClassification.AtlasClassifications(this.entitiesStore.getClassifications(guid));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasClassifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/uniqueAttribute/type/{typeName}/classifications")
    @Timed
    public void addClassificationsByUniqueAttribute(@PathParam(value="typeName") String typeName, @Context HttpServletRequest servletRequest, List<AtlasClassification> classifications) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> attributes;
            AtlasEntityType entityType;
            String guid;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.addClassificationsByUniqueAttribute(" + typeName + ")"));
            }
            if ((guid = this.entitiesStore.getGuidByUniqueAttributes(entityType = this.ensureEntityType(typeName), attributes = this.getAttributes(servletRequest))) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, attributes.toString()});
            }
            this.entitiesStore.addClassifications(guid, classifications);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/guid/{guid}/classifications")
    @Timed
    public void addClassifications(@PathParam(value="guid") String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.addClassifications(" + guid + ")"));
            }
            if (StringUtils.isEmpty((CharSequence)guid)) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
            }
            this.entitiesStore.addClassifications(guid, classifications);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/uniqueAttribute/type/{typeName}/classifications")
    @Timed
    public void updateClassificationsByUniqueAttribute(@PathParam(value="typeName") String typeName, @Context HttpServletRequest servletRequest, List<AtlasClassification> classifications) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> attributes;
            AtlasEntityType entityType;
            String guid;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.updateClassificationsByUniqueAttribute(" + typeName + ")"));
            }
            if ((guid = this.entitiesStore.getGuidByUniqueAttributes(entityType = this.ensureEntityType(typeName), attributes = this.getAttributes(servletRequest))) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, attributes.toString()});
            }
            this.entitiesStore.updateClassifications(guid, classifications);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/guid/{guid}/classifications")
    @Timed
    public void updateClassifications(@PathParam(value="guid") String guid, List<AtlasClassification> classifications) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.updateClassifications(" + guid + ")"));
            }
            if (StringUtils.isEmpty((CharSequence)guid)) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
            }
            this.entitiesStore.updateClassifications(guid, classifications);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/uniqueAttribute/type/{typeName}/classification/{classificationName}")
    @Timed
    public void deleteClassificationByUniqueAttribute(@PathParam(value="typeName") String typeName, @Context HttpServletRequest servletRequest, @PathParam(value="classificationName") String classificationName) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        Servlets.validateQueryParamLength("classificationName", classificationName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> attributes;
            AtlasEntityType entityType;
            String guid;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.deleteClassificationByUniqueAttribute(" + typeName + ")"));
            }
            if ((guid = this.entitiesStore.getGuidByUniqueAttributes(entityType = this.ensureEntityType(typeName), attributes = this.getAttributes(servletRequest))) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, attributes.toString()});
            }
            this.entitiesStore.deleteClassification(guid, classificationName);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/guid/{guid}/classification/{classificationName}")
    @Timed
    public void deleteClassification(@PathParam(value="guid") String guid, @PathParam(value="classificationName") String classificationName, @QueryParam(value="associatedEntityGuid") String associatedEntityGuid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        Servlets.validateQueryParamLength("classificationName", classificationName);
        Servlets.validateQueryParamLength("associatedEntityGuid", associatedEntityGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.deleteClassification(" + guid + "," + classificationName + "," + associatedEntityGuid + ")"));
            }
            if (StringUtils.isEmpty((CharSequence)guid)) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
            }
            this.ensureClassificationType(classificationName);
            this.entitiesStore.deleteClassification(guid, classificationName, associatedEntityGuid);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/bulk/uniqueAttribute/type/{typeName}")
    @Timed
    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByUniqueAttributes(@PathParam(value="typeName") String typeName, @QueryParam(value="minExtInfo") @DefaultValue(value="false") boolean minExtInfo, @QueryParam(value="ignoreRelationships") @DefaultValue(value="false") boolean ignoreRelationships, @Context HttpServletRequest servletRequest) throws AtlasBaseException {
        AtlasEntity.AtlasEntitiesWithExtInfo atlasEntitiesWithExtInfo;
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            List<Map<String, Object>> uniqAttributesList = this.getAttributesList(servletRequest);
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getEntitiesByUniqueAttributes(" + typeName + "," + uniqAttributesList + ")"));
            }
            AtlasEntityType entityType = this.ensureEntityType(typeName);
            for (Map<String, Object> uniqAttributes : uniqAttributesList) {
                this.validateUniqueAttribute(entityType, uniqAttributes);
            }
            atlasEntitiesWithExtInfo = this.entitiesStore.getEntitiesByUniqueAttributes(entityType, uniqAttributesList, minExtInfo, ignoreRelationships);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasEntitiesWithExtInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/bulk")
    @Timed
    public AtlasEntity.AtlasEntitiesWithExtInfo getByGuids(@QueryParam(value="guid") List<String> guids, @QueryParam(value="minExtInfo") @DefaultValue(value="false") boolean minExtInfo, @QueryParam(value="ignoreRelationships") @DefaultValue(value="false") boolean ignoreRelationships) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(guids)) {
            for (String guid : guids) {
                Servlets.validateQueryParamLength("guid", guid);
            }
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getByGuids(" + guids + ")"));
            }
            if (CollectionUtils.isEmpty(guids)) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, guids);
            }
            AtlasEntity.AtlasEntitiesWithExtInfo atlasEntitiesWithExtInfo = this.entitiesStore.getByIds(guids, minExtInfo, ignoreRelationships);
            return atlasEntitiesWithExtInfo;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/bulk")
    @Timed
    public EntityMutationResponse createOrUpdate(AtlasEntity.AtlasEntitiesWithExtInfo entities) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.createOrUpdate(entityCount=" + (CollectionUtils.isEmpty((Collection)entities.getEntities()) ? 0 : entities.getEntities().size()) + ")"));
            }
            AtlasEntityStream entityStream = new AtlasEntityStream(entities);
            EntityMutationResponse entityMutationResponse = this.entitiesStore.createOrUpdate((EntityStream)entityStream, false);
            return entityMutationResponse;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/bulk")
    @Timed
    public EntityMutationResponse deleteByGuids(@QueryParam(value="guid") List<String> guids) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(guids)) {
            for (String guid : guids) {
                Servlets.validateQueryParamLength("guid", guid);
            }
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.deleteByGuids(" + guids + ")"));
            }
            EntityMutationResponse entityMutationResponse = this.entitiesStore.deleteByIds(guids);
            return entityMutationResponse;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/bulk/classification")
    @Timed
    public void addClassification(ClassificationAssociateRequest request) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            String entityTypeName;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.addClassification(" + request + ")"));
            }
            AtlasClassification classification = request == null ? null : request.getClassification();
            ArrayList<String> entityGuids = request == null ? null : request.getEntityGuids();
            List entitiesUniqueAttributes = request == null ? null : request.getEntitiesUniqueAttributes();
            String string = entityTypeName = request == null ? null : request.getEntityTypeName();
            if (classification == null || StringUtils.isEmpty((CharSequence)classification.getTypeName())) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no classification"});
            }
            if (this.hasNoGUIDAndTypeNameAttributes(request)) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Need either list of GUIDs or entity type and list of qualified Names"});
            }
            if (CollectionUtils.isNotEmpty((Collection)entitiesUniqueAttributes) && entityTypeName != null) {
                AtlasEntityType entityType = this.ensureEntityType(entityTypeName);
                if (CollectionUtils.isEmpty((Collection)entityGuids)) {
                    entityGuids = new ArrayList<String>();
                }
                for (Map eachEntityAttributes : entitiesUniqueAttributes) {
                    try {
                        String guid = this.entitiesStore.getGuidByUniqueAttributes(entityType, eachEntityAttributes);
                        if (guid == null) continue;
                        entityGuids.add(guid);
                    }
                    catch (AtlasBaseException e) {
                        if (RequestContext.get().isSkipFailedEntities()) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("getByIds(): ignoring failure for entity with unique attributes {} and typeName {}: error code={}, message={}", new Object[]{eachEntityAttributes, entityTypeName, e.getAtlasErrorCode(), e.getMessage()});
                            continue;
                        }
                        throw e;
                    }
                }
                if (CollectionUtils.isEmpty(entityGuids)) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"No guid found for given entity Type Name and list of attributes"});
                }
            }
            this.entitiesStore.addClassification((List)entityGuids, classification);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{guid}/audit")
    @Timed
    public List<EntityAuditEventV2> getAuditEvents(@PathParam(value="guid") String guid, @QueryParam(value="startKey") String startKey, @QueryParam(value="auditAction") EntityAuditEventV2.EntityAuditActionV2 auditAction, @QueryParam(value="count") @DefaultValue(value="100") short count, @QueryParam(value="offset") @DefaultValue(value="-1") int offset, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="sortOrder") String sortOrder) throws AtlasBaseException {
        ArrayList<EntityAuditEventV2> arrayList;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getAuditEvents(" + guid + ", " + startKey + ", " + count + ")"));
            }
            try {
                this.entitiesStore.getHeaderById(guid);
            }
            catch (AtlasBaseException e) {
                if (e.getAtlasErrorCode() == AtlasErrorCode.INSTANCE_GUID_NOT_FOUND) {
                    AtlasEntityHeader entityHeader = this.getEntityHeaderFromPurgedAudit(guid);
                    AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, entityHeader), (Object[])new Object[]{"read entity audit: guid=", guid});
                }
                throw e;
            }
            ArrayList<EntityAuditEventV2> ret = new ArrayList();
            if (sortBy != null || offset > -1) {
                ret = this.auditRepository.listEventsV2(guid, auditAction, sortBy, StringUtils.equalsIgnoreCase((CharSequence)sortOrder, (CharSequence)"desc"), offset, count);
            } else if (auditAction != null) {
                ret = this.auditRepository.listEventsV2(guid, auditAction, startKey, count);
            } else {
                List events = this.auditRepository.listEvents(guid, startKey, count);
                for (Object event : events) {
                    if (event instanceof EntityAuditEventV2) {
                        ret.add((EntityAuditEventV2)event);
                        continue;
                    }
                    if (event instanceof EntityAuditEvent) {
                        ret.add(this.instanceConverter.toV2AuditEvent((EntityAuditEvent)event));
                        continue;
                    }
                    LOG.warn("unknown entity-audit event type {}. Ignored", (Object)(event != null ? event.getClass().getCanonicalName() : "null"));
                }
            }
            arrayList = ret;
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="bulk/headers")
    @Produces(value={"application/json; charset=UTF-8"})
    @Timed
    public AtlasEntityHeaders getEntityHeaders(@QueryParam(value="tagUpdateStartTime") long tagUpdateStartTime) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            long tagUpdateEndTime = System.currentTimeMillis();
            if (tagUpdateStartTime > tagUpdateEndTime) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"fromTimestamp should be less than toTimestamp"});
            }
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.getEntityHeaders(" + tagUpdateStartTime + ", " + tagUpdateEndTime + ")"));
            }
            ClassificationAssociator.Retriever associator = new ClassificationAssociator.Retriever(this.typeRegistry, this.auditRepository);
            AtlasEntityHeaders atlasEntityHeaders = associator.get(tagUpdateStartTime, tagUpdateEndTime);
            return atlasEntityHeaders;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="bulk/setClassifications")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/json; charset=UTF-8"})
    @Timed
    public String setClassifications(AtlasEntityHeaders entityHeaders) {
        String string;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"EntityREST.setClassifications()");
            }
            ClassificationAssociator.Updater associator = new ClassificationAssociator.Updater(this.typeRegistry, this.entitiesStore);
            string = associator.setClassifications(entityHeaders.getGuidHeaderMap());
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/guid/{guid}/businessmetadata")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/json; charset=UTF-8"})
    @Timed
    public void addOrUpdateBusinessAttributes(@PathParam(value="guid") String guid, @QueryParam(value="isOverwrite") @DefaultValue(value="false") boolean isOverwrite, Map<String, Map<String, Object>> businessAttributes) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.addOrUpdateBusinessAttributes(" + guid + ", isOverwrite=" + isOverwrite + ")"));
            }
            this.entitiesStore.addOrUpdateBusinessAttributes(guid, businessAttributes, isOverwrite);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/guid/{guid}/businessmetadata")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/json; charset=UTF-8"})
    @Timed
    public void removeBusinessAttributes(@PathParam(value="guid") String guid, Map<String, Map<String, Object>> businessAttributes) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.removeBusinessAttributes(" + guid + ")"));
            }
            this.entitiesStore.removeBusinessAttributes(guid, businessAttributes);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/guid/{guid}/businessmetadata/{bmName}")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/json; charset=UTF-8"})
    @Timed
    public void addOrUpdateBusinessAttributes(@PathParam(value="guid") String guid, @PathParam(value="bmName") String bmName, Map<String, Object> businessAttributes) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.addOrUpdateBusinessAttributes(" + guid + ", " + bmName + ")"));
            }
            this.entitiesStore.addOrUpdateBusinessAttributes(guid, Collections.singletonMap(bmName, businessAttributes), false);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/guid/{guid}/businessmetadata/{bmName}")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/json; charset=UTF-8"})
    @Timed
    public void removeBusinessAttributes(@PathParam(value="guid") String guid, @PathParam(value="bmName") String bmName, Map<String, Object> businessAttributes) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.removeBusinessAttributes(" + guid + ", " + bmName + ")"));
            }
            this.entitiesStore.removeBusinessAttributes(guid, Collections.singletonMap(bmName, businessAttributes));
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/guid/{guid}/labels")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/json; charset=UTF-8"})
    @Timed
    public void setLabels(@PathParam(value="guid") String guid, Set<String> labels) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"EntityREST.setLabels()");
            }
            this.entitiesStore.setLabels(guid, labels);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/guid/{guid}/labels")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/json; charset=UTF-8"})
    @Timed
    public void removeLabels(@PathParam(value="guid") String guid, Set<String> labels) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"EntityREST.deleteLabels()");
            }
            this.entitiesStore.removeLabels(guid, labels);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/guid/{guid}/labels")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/json; charset=UTF-8"})
    @Timed
    public void addLabels(@PathParam(value="guid") String guid, Set<String> labels) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"EntityREST.addLabels()");
            }
            this.entitiesStore.addLabels(guid, labels);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/uniqueAttribute/type/{typeName}/labels")
    @Timed
    public void setLabels(@PathParam(value="typeName") String typeName, Set<String> labels, @Context HttpServletRequest servletRequest) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> attributes;
            AtlasEntityType entityType;
            String guid;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.setLabels(" + typeName + ")"));
            }
            if ((guid = this.entitiesStore.getGuidByUniqueAttributes(entityType = this.ensureEntityType(typeName), attributes = this.getAttributes(servletRequest))) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, attributes.toString()});
            }
            this.entitiesStore.setLabels(guid, labels);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/uniqueAttribute/type/{typeName}/labels")
    @Timed
    public void addLabels(@PathParam(value="typeName") String typeName, Set<String> labels, @Context HttpServletRequest servletRequest) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> attributes;
            AtlasEntityType entityType;
            String guid;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.addLabels(" + typeName + ")"));
            }
            if ((guid = this.entitiesStore.getGuidByUniqueAttributes(entityType = this.ensureEntityType(typeName), attributes = this.getAttributes(servletRequest))) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, attributes.toString()});
            }
            this.entitiesStore.addLabels(guid, labels);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/uniqueAttribute/type/{typeName}/labels")
    @Timed
    public void removeLabels(@PathParam(value="typeName") String typeName, Set<String> labels, @Context HttpServletRequest servletRequest) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            Map<String, Object> attributes;
            AtlasEntityType entityType;
            String guid;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityREST.removeLabels(" + typeName + ")"));
            }
            if ((guid = this.entitiesStore.getGuidByUniqueAttributes(entityType = this.ensureEntityType(typeName), attributes = this.getAttributes(servletRequest))) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, attributes.toString()});
            }
            this.entitiesStore.removeLabels(guid, labels);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
    }

    @GET
    @Path(value="/businessmetadata/import/template")
    @Produces(value={"application/octet-stream"})
    public Response produceTemplate() {
        return Response.ok(outputStream -> outputStream.write(FileUtils.getBusinessMetadataHeaders().getBytes())).header("Content-Disposition", (Object)"attachment; filename=\"template_business_metadata\"").build();
    }

    @POST
    @Path(value="/businessmetadata/import")
    @Consumes(value={"multipart/form-data"})
    @Timed
    public BulkImportResponse importBMAttributes(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws AtlasBaseException {
        return this.entitiesStore.bulkCreateOrUpdateBusinessAttributes(uploadedInputStream, fileDetail.getFileName());
    }

    private AtlasEntityType ensureEntityType(String typeName) throws AtlasBaseException {
        AtlasEntityType ret = this.typeRegistry.getEntityTypeByName(typeName);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), typeName});
        }
        return ret;
    }

    private AtlasClassificationType ensureClassificationType(String typeName) throws AtlasBaseException {
        AtlasClassificationType ret = this.typeRegistry.getClassificationTypeByName(typeName);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.CLASSIFICATION.name(), typeName});
        }
        return ret;
    }

    private Map<String, Object> getAttributes(HttpServletRequest request) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty((Map)request.getParameterMap())) {
            for (Map.Entry e : request.getParameterMap().entrySet()) {
                String key = (String)e.getKey();
                if (key == null || !key.startsWith(PREFIX_ATTR)) continue;
                String[] values = (String[])e.getValue();
                String value = values != null && values.length > 0 ? values[0] : null;
                attributes.put(key.substring(PREFIX_ATTR.length()), value);
            }
        }
        return attributes;
    }

    private List<Map<String, Object>> getAttributesList(HttpServletRequest request) {
        HashMap<String, Map> ret = new HashMap<String, Map>();
        if (MapUtils.isNotEmpty((Map)request.getParameterMap())) {
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                String value;
                String key = (String)entry.getKey();
                if (key == null || !key.startsWith(PREFIX_ATTR_)) continue;
                int sepPos = key.indexOf(58, PREFIX_ATTR_.length());
                String[] values = (String[])entry.getValue();
                String string = value = values != null && values.length > 0 ? values[0] : null;
                if (sepPos == -1 || value == null) continue;
                String attrName = key.substring(sepPos + 1);
                String listIdx = key.substring(PREFIX_ATTR_.length(), sepPos);
                Map attributes = ret.computeIfAbsent(listIdx, k -> new HashMap());
                attributes.put(attrName, value);
            }
        }
        return new ArrayList<Map<String, Object>>(ret.values());
    }

    private void validateUniqueAttribute(AtlasEntityType entityType, Map<String, Object> attributes) throws AtlasBaseException {
        if (MapUtils.isEmpty(attributes)) {
            throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_UNIQUE_INVALID, new String[]{entityType.getTypeName(), ""});
        }
        for (String attributeName : attributes.keySet()) {
            AtlasStructDef.AtlasAttributeDef attribute = entityType.getAttributeDef(attributeName);
            if (attribute != null && attribute.getIsUnique()) continue;
            throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_UNIQUE_INVALID, new String[]{entityType.getTypeName(), attributeName});
        }
    }

    private AtlasEntityHeader getEntityHeaderFromPurgedAudit(String guid) throws AtlasBaseException {
        AtlasEntityHeader ret;
        List auditEvents = this.auditRepository.listEventsV2(guid, EntityAuditEventV2.EntityAuditActionV2.ENTITY_PURGE, null, (short)1);
        AtlasEntityHeader atlasEntityHeader = ret = CollectionUtils.isNotEmpty((Collection)auditEvents) ? ((EntityAuditEventV2)auditEvents.get(0)).getEntityHeader() : null;
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        return ret;
    }

    private boolean hasNoGUIDAndTypeNameAttributes(ClassificationAssociateRequest request) {
        return request == null || CollectionUtils.isEmpty((Collection)request.getEntityGuids()) && (CollectionUtils.isEmpty((Collection)request.getEntitiesUniqueAttributes()) || request.getEntityTypeName() == null);
    }
}

