/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.atlas.discovery.AtlasLineageService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.v1.model.lineage.LineageResponse;
import org.apache.atlas.v1.model.lineage.SchemaResponse;
import org.apache.atlas.web.util.LineageUtils;
import org.apache.atlas.web.util.Servlets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="lineage")
@Singleton
@Service
@Deprecated
public class LineageResource {
    private static final Logger LOG = LoggerFactory.getLogger(LineageResource.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.LineageResource");
    private final AtlasLineageService atlasLineageService;
    private final AtlasTypeRegistry typeRegistry;

    @Inject
    public LineageResource(AtlasLineageService atlasLineageService, AtlasTypeRegistry typeRegistry) {
        this.atlasLineageService = atlasLineageService;
        this.typeRegistry = typeRegistry;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{guid}/inputs/graph")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public LineageResponse inputsGraph(@PathParam(value="guid") String guid) {
        LineageResponse lineageResponse;
        LOG.debug("==> LineageResource.inputsGraph({})", (Object)guid);
        LineageResponse ret = new LineageResponse();
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("LineageResource.inputsGraph(" + guid + ")"));
            }
            AtlasLineageInfo lineageInfo = this.atlasLineageService.getAtlasLineageInfo(guid, AtlasLineageInfo.LineageDirection.INPUT, -1);
            ret.setRequestId(Servlets.getRequestId());
            ret.setResults(LineageUtils.toLineageStruct(lineageInfo, this.typeRegistry));
            lineageResponse = ret;
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to get lineage inputs graph for entity guid={}", (Object)guid, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get lineage inputs graph for entity guid={}", (Object)guid, (Object)e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                LOG.debug("<== LineageResource.inputsGraph({})", (Object)guid);
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        LOG.debug("<== LineageResource.inputsGraph({})", (Object)guid);
        return lineageResponse;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{guid}/outputs/graph")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public LineageResponse outputsGraph(@PathParam(value="guid") String guid) {
        LineageResponse lineageResponse;
        LOG.debug("==> LineageResource.outputsGraph({})", (Object)guid);
        LineageResponse ret = new LineageResponse();
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("LineageResource.outputsGraph(" + guid + ")"));
            }
            AtlasLineageInfo lineageInfo = this.atlasLineageService.getAtlasLineageInfo(guid, AtlasLineageInfo.LineageDirection.OUTPUT, -1);
            ret.setRequestId(Servlets.getRequestId());
            ret.setResults(LineageUtils.toLineageStruct(lineageInfo, this.typeRegistry));
            lineageResponse = ret;
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to get lineage outputs graph for entity guid={}", (Object)guid, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get lineage outputs graph for entity guid={}", (Object)guid, (Object)e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                LOG.debug("<== LineageResource.outputsGraph({})", (Object)guid);
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        LOG.debug("<== LineageResource.outputsGraph({})", (Object)guid);
        return lineageResponse;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{guid}/schema")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public SchemaResponse schema(@PathParam(value="guid") String guid) {
        SchemaResponse schemaResponse;
        LOG.debug("==> LineageResource.schema({})", (Object)guid);
        AtlasPerfTracer perf = null;
        SchemaResponse ret = new SchemaResponse();
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("LineageResource.schema(" + guid + ")"));
            }
            SchemaResponse.SchemaDetails schemaDetails = this.atlasLineageService.getSchemaForHiveTableByGuid(guid);
            ret.setRequestId(Servlets.getRequestId());
            ret.setResults(schemaDetails);
            schemaResponse = ret;
        }
        catch (IllegalArgumentException e) {
            try {
                LOG.error("Unable to get schema for entity guid={}", (Object)guid, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get schema for entity guid={}", (Object)guid, (Object)e2);
                    throw e2;
                }
                catch (AtlasBaseException e3) {
                    LOG.error("Unable to get schema for entity={}", (Object)guid, (Object)e3);
                    throw new WebApplicationException(Servlets.getErrorResponse(e3, e3.getAtlasErrorCode().getHttpCode()));
                }
                catch (Throwable e4) {
                    LOG.error("Unable to get schema for entity={}", (Object)guid, (Object)e4);
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                LOG.debug("<== LineageResource.schema({})", (Object)guid);
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        LOG.debug("<== LineageResource.schema({})", (Object)guid);
        return schemaResponse;
    }
}

