/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.params;

import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.atlas.exception.AtlasBaseException;

public abstract class AbstractParam<T> {
    private final T value;

    protected AbstractParam(String input) {
        try {
            this.value = this.parse(input);
        }
        catch (Exception e) {
            throw new WebApplicationException(this.error(input, e));
        }
    }

    public T get() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractParam that = (AbstractParam)o;
        return Objects.equals(this.value, that.value);
    }

    public String toString() {
        return this.value.toString();
    }

    protected Response error(String input, Exception e) {
        return Response.status((Response.Status)this.getErrorStatus()).entity((Object)this.errorMessage(input, e)).type(this.mediaType()).build();
    }

    protected MediaType mediaType() {
        return MediaType.TEXT_PLAIN_TYPE;
    }

    protected String errorMessage(String input, Exception e) {
        return String.format("Invalid parameter: %s (%s)", input, e.getMessage());
    }

    protected Response.Status getErrorStatus() {
        return Response.Status.BAD_REQUEST;
    }

    protected abstract T parse(String var1) throws AtlasBaseException;
}

