/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.listeners;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LoginProcessor.class);
    public static final String ATLAS_AUTHENTICATION_PREFIX = "atlas.authentication.";
    public static final String AUTHENTICATION_KERBEROS_METHOD = "atlas.authentication.method.kerberos";
    public static final String AUTHENTICATION_PRINCIPAL = "atlas.authentication.principal";
    public static final String AUTHENTICATION_KEYTAB = "atlas.authentication.keytab";

    public void login() {
        boolean isHadoopCluster = this.isHadoopCluster();
        org.apache.hadoop.conf.Configuration hadoopConfig = isHadoopCluster ? this.getHadoopConfiguration() : new org.apache.hadoop.conf.Configuration(false);
        Configuration configuration = this.getApplicationConfiguration();
        if (!isHadoopCluster) {
            this.setupHadoopConfiguration(hadoopConfig, configuration);
        }
        this.doServiceLogin(hadoopConfig, configuration);
    }

    protected void doServiceLogin(org.apache.hadoop.conf.Configuration hadoopConfig, Configuration configuration) {
        UserGroupInformation.setConfiguration((org.apache.hadoop.conf.Configuration)hadoopConfig);
        UserGroupInformation.AuthenticationMethod authenticationMethod = SecurityUtil.getAuthenticationMethod((org.apache.hadoop.conf.Configuration)hadoopConfig);
        try {
            if (authenticationMethod == UserGroupInformation.AuthenticationMethod.SIMPLE) {
                UserGroupInformation.loginUserFromSubject(null);
            } else if (authenticationMethod == UserGroupInformation.AuthenticationMethod.KERBEROS) {
                String bindAddress = this.getHostname(configuration);
                UserGroupInformation.loginUserFromKeytab((String)this.getServerPrincipal(configuration.getString(AUTHENTICATION_PRINCIPAL), bindAddress), (String)configuration.getString(AUTHENTICATION_KEYTAB));
            }
            LOG.info("Logged in user {}", (Object)UserGroupInformation.getLoginUser());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to perform %s login.", authenticationMethod), e);
        }
    }

    protected void setupHadoopConfiguration(org.apache.hadoop.conf.Configuration hadoopConfig, Configuration configuration) {
        String kerberosAuthNEnabled;
        String authMethod = "";
        String string = kerberosAuthNEnabled = configuration != null ? configuration.getString(AUTHENTICATION_KERBEROS_METHOD) : null;
        if (kerberosAuthNEnabled == null || kerberosAuthNEnabled.equalsIgnoreCase("false")) {
            LOG.info("No authentication method configured.  Defaulting to simple authentication");
            authMethod = "simple";
        } else if (kerberosAuthNEnabled.equalsIgnoreCase("true")) {
            authMethod = "kerberos";
        }
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.valueOf((String)authMethod.toUpperCase()), (org.apache.hadoop.conf.Configuration)hadoopConfig);
    }

    protected org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
        return new org.apache.hadoop.conf.Configuration();
    }

    protected Configuration getApplicationConfiguration() {
        try {
            return ApplicationProperties.get();
        }
        catch (AtlasException e) {
            LOG.warn("Error reading application configuration", (Throwable)e);
            return null;
        }
    }

    protected boolean isHadoopCluster() {
        boolean isHadoopCluster = false;
        try {
            isHadoopCluster = Shell.getHadoopHome() != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isHadoopCluster;
    }

    private String getHostname(Configuration configuration) {
        String bindAddress = configuration.getString("atlas.server.bind.address");
        if (bindAddress == null) {
            LOG.info("No host name configured.  Defaulting to local host name.");
            try {
                bindAddress = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
        return bindAddress;
    }

    private String getServerPrincipal(String principal, String host) throws IOException {
        return SecurityUtil.getServerPrincipal((String)principal, (String)host);
    }
}

