/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RestUtil.class);
    public static final String TIMEOUT_ACTION = "timeout";
    public static final String LOGOUT_URL = "/logout.html";
    public static final String DELIMITTER = "://";
    private static final String PROXY_ATLAS_URL_PATH = "/atlas";
    private static final String X_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String X_FORWARDED_CONTEXT = "x-forwarded-context";

    private RestUtil() {
    }

    public static String constructForwardableURL(HttpServletRequest httpRequest) {
        String xForwardedProto = "";
        String xForwardedHost = "";
        String xForwardedContext = "";
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration values = httpRequest.getHeaders(name);
            String value = "";
            if (values != null) {
                while (values.hasMoreElements()) {
                    value = (String)values.nextElement();
                }
            }
            if (StringUtils.trimToNull((String)name) == null || StringUtils.trimToNull((String)value) == null) continue;
            if (name.equalsIgnoreCase(X_FORWARDED_PROTO)) {
                xForwardedProto = value;
                continue;
            }
            if (name.equalsIgnoreCase(X_FORWARDED_HOST)) {
                xForwardedHost = value;
                continue;
            }
            if (!name.equalsIgnoreCase(X_FORWARDED_CONTEXT)) continue;
            xForwardedContext = value;
        }
        if (xForwardedHost.contains(",")) {
            LOG.debug("xForwardedHost value is {} it contains multiple hosts, selecting the first host.", (Object)xForwardedHost);
            xForwardedHost = xForwardedHost.split(",")[0].trim();
        }
        String xForwardedURL = "";
        if (StringUtils.trimToNull((String)xForwardedProto) != null) {
            if (StringUtils.trimToNull((String)xForwardedHost) != null && StringUtils.trimToNull((String)xForwardedContext) != null) {
                xForwardedURL = xForwardedProto + DELIMITTER + xForwardedHost + xForwardedContext + PROXY_ATLAS_URL_PATH + httpRequest.getRequestURI();
            } else if (StringUtils.trimToNull((String)xForwardedHost) != null) {
                xForwardedURL = xForwardedProto + DELIMITTER + xForwardedHost + httpRequest.getRequestURI();
            } else {
                String requestURL = httpRequest.getRequestURL().toString();
                if (StringUtils.trimToNull((String)requestURL) != null && requestURL.startsWith("http:")) {
                    requestURL = requestURL.replaceFirst("http", xForwardedProto);
                }
                xForwardedURL = requestURL;
            }
        }
        return xForwardedURL;
    }

    public static String constructRedirectURL(HttpServletRequest request, String redirectUrl, String xForwardedURL, String originalUrlQueryParam) {
        String delimiter = "?";
        if (redirectUrl.contains("?")) {
            delimiter = "&";
        }
        String loginURL = redirectUrl + delimiter + originalUrlQueryParam + "=";
        loginURL = StringUtils.trimToNull((String)xForwardedURL) != null ? loginURL + xForwardedURL : loginURL + request.getRequestURL().append(RestUtil.getOriginalQueryString(request));
        return loginURL;
    }

    private static String getOriginalQueryString(HttpServletRequest request) {
        String originalQueryString = request.getQueryString();
        return originalQueryString == null ? "" : "?" + originalQueryString;
    }
}

