/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.atlas.web.filters.AtlasResponseRequestWrapper;
import org.apache.atlas.web.filters.HeadersUtil;
import org.apache.atlas.web.filters.NullServletContext;
import org.apache.atlas.web.filters.RestUtil;
import org.apache.atlas.web.security.AtlasAuthenticationProvider;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Component;

@Component
public class AtlasAuthenticationFilter
extends AuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthenticationFilter.class);
    protected static final ServletContext nullContext = new NullServletContext();
    private static final int SESSION_TIMEOUT_DISABLED_VALUE = -1;
    private static final String CONFIG_KERBEROS_TOKEN_VALIDITY = "atlas.authentication.method.kerberos.token.validity";
    private static final String CONFIG_PROXY_USERS = "atlas.proxyusers";
    private static final String PREFIX = "atlas.authentication.method";
    private static final String[] DEFAULT_PROXY_USERS = new String[]{"knox"};
    private static final String CONF_PROXYUSER_PREFIX = "atlas.proxyuser";
    private static final String ORIGINAL_URL_QUERY_PARAM = "originalUrl";
    private final boolean isKerberos = AuthenticationUtil.isKerberosAuthenticationEnabled();
    private Signer signer;
    private SignerSecretProvider secretProvider;
    private boolean isInitializedByTomcat;
    private Set<Pattern> browserUserAgents;
    private boolean supportKeyTabBrowserLogin;
    private org.apache.commons.configuration.Configuration configuration;
    private Properties headerProperties;
    private Set<String> atlasProxyUsers = new HashSet<String>();
    private HttpServlet optionsServlet;
    private boolean supportTrustedProxy;
    private int sessionTimeout;
    private SecurityContextLogoutHandler logoutHandler;

    public AtlasAuthenticationFilter() {
        LOG.info("==> AtlasAuthenticationFilter()");
        try {
            this.init(null);
        }
        catch (ServletException e) {
            LOG.error("Error while initializing AtlasAuthenticationFilter", (Throwable)e);
        }
        LOG.info("<== AtlasAuthenticationFilter()");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("==> AtlasAuthenticationFilter.init");
        final FilterConfig globalConf = filterConfig;
        final HashMap<String, String> params = new HashMap<String, String>();
        try {
            this.configuration = ApplicationProperties.get();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        String tokenValidityStr = null;
        if (this.configuration != null) {
            tokenValidityStr = this.configuration.getString(CONFIG_KERBEROS_TOKEN_VALIDITY);
        }
        if (StringUtils.isNotBlank(tokenValidityStr)) {
            try {
                long tokenValidity = Long.parseLong(tokenValidityStr);
                if (tokenValidity <= 0L) {
                    throw new ServletException(tokenValidity + ": invalid value for property '" + CONFIG_KERBEROS_TOKEN_VALIDITY + "'. Must be a positive integer");
                }
                params.put("token.validity", Long.toString(tokenValidity));
            }
            catch (NumberFormatException e) {
                throw new ServletException(tokenValidityStr + ": invalid value for property '" + CONFIG_KERBEROS_TOKEN_VALIDITY + "'. Must be a positive integer", (Throwable)e);
            }
        }
        FilterConfig filterConfig1 = new FilterConfig(){

            public String getFilterName() {
                return "AtlasAuthenticationFilter";
            }

            public ServletContext getServletContext() {
                if (globalConf != null) {
                    return globalConf.getServletContext();
                }
                return nullContext;
            }

            public String getInitParameter(String param) {
                return (String)params.get(param);
            }

            public Enumeration<String> getInitParameterNames() {
                return new IteratorEnumeration(params.keySet().iterator());
            }
        };
        super.init(filterConfig1);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.getProxyuserConfiguration(), (String)CONF_PROXYUSER_PREFIX);
        this.optionsServlet = new HttpServlet(){};
        this.optionsServlet.init();
        if (this.sessionTimeout != -1) {
            this.logoutHandler = new SecurityContextLogoutHandler();
        }
        LOG.info("<== AtlasAuthenticationFilter.init(filterConfig={})", (Object)filterConfig);
    }

    public void initializeSecretProvider(FilterConfig filterConfig) throws ServletException {
        LOG.info("==> AtlasAuthenticationFilter.initializeSecretProvider");
        this.secretProvider = (SignerSecretProvider)filterConfig.getServletContext().getAttribute("signer.secret.provider.object");
        if (this.secretProvider == null) {
            String configPrefix = filterConfig.getInitParameter("config.prefix");
            configPrefix = configPrefix != null ? configPrefix + "." : "";
            try {
                this.secretProvider = AuthenticationFilter.constructSecretProvider((ServletContext)filterConfig.getServletContext(), (Properties)super.getConfiguration(configPrefix, filterConfig), (boolean)false);
                this.isInitializedByTomcat = true;
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        this.signer = new Signer(this.secretProvider);
        LOG.info("<== AtlasAuthenticationFilter.initializeSecretProvider(filterConfig={})", (Object)filterConfig);
    }

    public void destroy() {
        if (this.secretProvider != null && this.isInitializedByTomcat) {
            this.secretProvider.destroy();
            this.secretProvider = null;
        }
        this.optionsServlet.destroy();
        super.destroy();
    }

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        String[] proxyUsers;
        String principal;
        String authMethod;
        String kerberosAuthEnabled;
        LOG.info("==> AtlasAuthenticationFilter.getConfiguration()");
        try {
            this.configuration = ApplicationProperties.get();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        Properties ret = new Properties();
        String string = kerberosAuthEnabled = this.configuration != null ? this.configuration.getString("atlas.authentication.method.kerberos") : null;
        if (kerberosAuthEnabled == null || kerberosAuthEnabled.equalsIgnoreCase("false")) {
            LOG.info("No authentication method configured.  Defaulting to simple authentication");
            authMethod = "simple";
        } else if (kerberosAuthEnabled.equalsIgnoreCase("true")) {
            authMethod = "kerberos";
            if (this.configuration.getString("atlas.authentication.method.kerberos.name.rules") != null) {
                ret.put("kerberos.name.rules", this.configuration.getString("atlas.authentication.method.kerberos.name.rules"));
            }
            if (this.configuration.getString("atlas.authentication.method.kerberos.keytab") != null) {
                ret.put("kerberos.keytab", this.configuration.getString("atlas.authentication.method.kerberos.keytab"));
            }
            if (this.configuration.getString("atlas.authentication.method.kerberos.principal") != null) {
                ret.put("kerberos.principal", this.configuration.getString("atlas.authentication.method.kerberos.principal"));
            }
        } else {
            authMethod = "";
        }
        ret.put("type", authMethod);
        ret.put("cookie.path", "/");
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            ret.put(name, filterConfig.getInitParameter(name));
        }
        String bindAddress = this.configuration.getString("atlas.server.bind.address");
        if (bindAddress == null) {
            LOG.info("No host name configured. Defaulting to local host name.");
            try {
                bindAddress = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new ServletException("Unable to obtain host name", (Throwable)e);
            }
        }
        if ((principal = ret.getProperty("kerberos.principal")) != null) {
            try {
                principal = SecurityUtil.getServerPrincipal((String)principal, (String)bindAddress);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not resolve Kerberos principal name: " + ex, ex);
            }
            ret.put("kerberos.principal", principal);
        }
        LOG.debug(" AuthenticationFilterConfig: {}", (Object)ret);
        this.sessionTimeout = AtlasConfiguration.SESSION_TIMEOUT_SECS.getInt();
        LOG.info("AtlasAuthenticationFilter: {} = {}: {}", new Object[]{AtlasConfiguration.SESSION_TIMEOUT_SECS.getPropertyName(), this.sessionTimeout, this.sessionTimeout == -1 ? "Disabled" : "Enabled"});
        this.supportKeyTabBrowserLogin = this.configuration.getBoolean("atlas.authentication.method.kerberos.support.keytab.browser.login", false);
        this.supportTrustedProxy = this.configuration.getBoolean("atlas.authentication.method.trustedproxy", true);
        String agents = this.configuration.getString("atlas.rest-csrf.browser-useragents-regex", "^Mozilla.*,^Opera.*,^Chrome");
        if (agents == null) {
            agents = "^Mozilla.*,^Opera.*,^Chrome";
        }
        if ((proxyUsers = this.configuration.getStringArray(CONFIG_PROXY_USERS)) == null || proxyUsers.length == 0) {
            proxyUsers = DEFAULT_PROXY_USERS;
        }
        this.atlasProxyUsers = new HashSet<String>(Arrays.asList(proxyUsers));
        this.parseBrowserUserAgents(agents);
        LOG.info("<== AtlasAuthenticationFilter.getConfiguration(configPrefix={}, filterConfig={}): {}", new Object[]{configPrefix, filterConfig, ret});
        return ret;
    }

    protected AuthenticationToken getToken(HttpServletRequest request) throws AuthenticationException {
        AuthenticationToken token = null;
        String tokenStr = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("hadoop.auth")) continue;
                tokenStr = cookie.getValue();
                try {
                    tokenStr = this.signer.verifyAndExtract(tokenStr);
                }
                catch (SignerException ex) {
                    throw new AuthenticationException((Throwable)ex);
                }
            }
        }
        if (tokenStr != null && (token = AuthenticationToken.parse(tokenStr)) != null) {
            AuthenticationHandler authHandler = this.getAuthenticationHandler();
            if (!token.getType().equals(authHandler.getType())) {
                throw new AuthenticationException("Invalid AuthenticationToken type");
            }
            if (token.isExpired()) {
                throw new AuthenticationException("AuthenticationToken expired");
            }
        }
        return token;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        try {
            Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            AtlasResponseRequestWrapper responseWrapper = new AtlasResponseRequestWrapper(httpResponse);
            String action = httpRequest.getParameter("action");
            String doAsUser = request.getParameter("doAs");
            HeadersUtil.setSecurityHeaders(responseWrapper);
            if (this.logoutHandler != null && this.supportTrustedProxy && StringUtils.isNotEmpty((String)doAsUser) && StringUtils.equals((String)action, (String)"timeout")) {
                if (existingAuth != null) {
                    this.logoutHandler.logout(httpRequest, httpResponse, existingAuth);
                }
                this.redirectTimeoutReqeust(httpRequest, httpResponse);
                return;
            }
            if (existingAuth == null) {
                String authHeader = httpRequest.getHeader("Authorization");
                if (authHeader != null && authHeader.startsWith("Basic")) {
                    filterChain.doFilter(request, response);
                } else if (this.isKerberos) {
                    this.doKerberosAuth(request, response, filterChain);
                } else {
                    filterChain.doFilter(request, response);
                }
            } else {
                filterChain.doFilter(request, response);
            }
        }
        catch (NullPointerException e) {
            LOG.error("Exception in AtlasAuthenticationFilter ", (Throwable)e);
            ((HttpServletResponse)response).sendError(Response.Status.BAD_REQUEST.getStatusCode(), "Authentication is enabled and user is not specified. Specify user.name parameter");
        }
    }

    void parseBrowserUserAgents(String userAgents) {
        String[] agentsArray = userAgents.split(",");
        this.browserUserAgents = new HashSet<Pattern>();
        for (String patternString : agentsArray) {
            this.browserUserAgents.add(Pattern.compile(patternString));
        }
    }

    boolean isBrowser(String userAgent) {
        if (userAgent != null) {
            for (Pattern pattern : this.browserUserAgents) {
                Matcher matcher = pattern.matcher(userAgent);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    private void redirectTimeoutReqeust(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        String logoutUrl = httpRequest.getRequestURL().toString();
        logoutUrl = StringUtils.replace((String)logoutUrl, (String)httpRequest.getRequestURI(), (String)"/logout.html");
        LOG.debug("logoutUrl value is {}", (Object)logoutUrl);
        String xForwardedURL = RestUtil.constructForwardableURL(httpRequest);
        LOG.debug("xForwardedURL = {}", (Object)xForwardedURL);
        String redirectUrl = RestUtil.constructRedirectURL(httpRequest, logoutUrl, xForwardedURL, ORIGINAL_URL_QUERY_PARAM);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirect URL = {}", (Object)redirectUrl);
            LOG.debug("session id = {}", (Object)httpRequest.getRequestedSessionId());
        }
        httpResponse.sendRedirect(redirectUrl);
    }

    private void doKerberosAuth(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        KerberosFilterChainWrapper filterChainWrapper = new KerberosFilterChainWrapper(request, response, filterChain);
        boolean unauthorizedResponse = true;
        int errCode = 401;
        AuthenticationException authenticationEx = null;
        Object httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isHttps = "https".equals(httpRequest.getScheme());
        AuthenticationHandler authHandler = this.getAuthenticationHandler();
        String doAsUser = this.supportTrustedProxy ? Servlets.getDoAsUser(httpRequest) : null;
        try {
            AuthenticationToken token;
            boolean newToken = false;
            try {
                token = this.getToken((HttpServletRequest)httpRequest);
            }
            catch (AuthenticationException ex) {
                LOG.warn("AuthenticationToken ignored: {}", (Object)String.valueOf((Object)ex));
                authenticationEx = ex;
                token = null;
            }
            if (authHandler.managementOperation(token, httpRequest, httpResponse)) {
                if (token == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Request [{}] triggering authentication", (Object)this.getRequestURL((HttpServletRequest)httpRequest));
                    }
                    if ((token = authHandler.authenticate(httpRequest, httpResponse)) != null && token.getExpires() != 0L && token != AuthenticationToken.ANONYMOUS) {
                        token.setExpires(System.currentTimeMillis() + this.getValidity() * 1000L);
                    }
                    newToken = true;
                }
                if (token != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Request [{}] user [{}] authenticated", (Object)this.getRequestURL((HttpServletRequest)httpRequest), (Object)token.getUserName());
                    }
                    unauthorizedResponse = false;
                    final AuthenticationToken authToken = token;
                    httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                        public String getAuthType() {
                            return authToken.getType();
                        }

                        public String getRemoteUser() {
                            return authToken.getUserName();
                        }

                        public Principal getUserPrincipal() {
                            return authToken != AuthenticationToken.ANONYMOUS ? authToken : null;
                        }
                    };
                    if (this.supportTrustedProxy && doAsUser != null && !doAsUser.equals(httpRequest.getRemoteUser())) {
                        UserGroupInformation requestUgi;
                        LOG.debug("doAsUser is {}", (Object)doAsUser);
                        UserGroupInformation userGroupInformation = requestUgi = token != null ? UserGroupInformation.createRemoteUser((String)token.getUserName()) : null;
                        if (requestUgi != null) {
                            requestUgi = UserGroupInformation.createProxyUser((String)doAsUser, (UserGroupInformation)requestUgi);
                            try {
                                ProxyUsers.authorize((UserGroupInformation)requestUgi, (String)request.getRemoteAddr());
                                request.setAttribute("proxyUser", (Object)doAsUser);
                            }
                            catch (AuthorizationException ex) {
                                LOG.warn("Proxy user AuthorizationException", (Throwable)ex);
                                httpResponse.setStatus(403);
                                filterChain.doFilter(request, response);
                                return;
                            }
                        }
                    } else if (StringUtils.isNotBlank((String)httpRequest.getRemoteUser()) && this.atlasProxyUsers.contains(httpRequest.getRemoteUser())) {
                        LOG.info("Ignoring kerberos login from proxy user {}", (Object)httpRequest.getRemoteUser());
                        httpResponse.setHeader("WWW-Authenticate", "");
                        httpResponse.setStatus(401);
                        filterChain.doFilter(request, response);
                        return;
                    }
                    if (newToken && !token.isExpired() && token != AuthenticationToken.ANONYMOUS) {
                        String signedToken = this.signer.sign(token.toString());
                        this.createAtlasAuthCookie(httpResponse, signedToken, this.getCookieDomain(), this.getCookiePath(), token.getExpires(), isHttps);
                    }
                    filterChainWrapper.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
            } else {
                unauthorizedResponse = false;
            }
        }
        catch (AuthenticationException ex) {
            LOG.warn("Authentication exception: {}", (Object)ex.getMessage(), (Object)ex);
            errCode = 403;
            authenticationEx = ex;
        }
        if (unauthorizedResponse && !httpResponse.isCommitted()) {
            boolean isKerberosOnBrowser;
            this.createAtlasAuthCookie(httpResponse, "", this.getCookieDomain(), this.getCookiePath(), 0L, isHttps);
            if (errCode == 401 && !httpResponse.containsHeader("WWW-Authenticate")) {
                errCode = 403;
            }
            boolean bl = isKerberosOnBrowser = this.supportKeyTabBrowserLogin || doAsUser != null;
            if (authenticationEx == null) {
                if (!isKerberosOnBrowser && this.isBrowser(httpRequest.getHeader("User-Agent"))) {
                    filterChain.doFilter(request, response);
                } else {
                    String authHeader;
                    boolean chk = true;
                    Collection headerNames = httpResponse.getHeaderNames();
                    for (String headerName : headerNames) {
                        String value = httpResponse.getHeader(headerName);
                        if (!headerName.equalsIgnoreCase("Set-Cookie") || !value.startsWith("ATLASSESSIONID")) continue;
                        chk = false;
                        break;
                    }
                    if ((authHeader = httpRequest.getHeader("Authorization")) == null && chk) {
                        filterChain.doFilter(request, response);
                    } else if (authHeader != null && authHeader.startsWith("Basic")) {
                        filterChain.doFilter(request, response);
                    }
                }
            } else {
                httpResponse.sendError(errCode, authenticationEx.getMessage());
            }
        }
    }

    private static String readUserFromCookie(HttpServletResponse response1) {
        Collection authUserName;
        String userName = null;
        boolean isCookieSet = response1.containsHeader("Set-Cookie");
        if (isCookieSet && (authUserName = response1.getHeaders("Set-Cookie")) != null) {
            block2: for (String cookie : authUserName) {
                String[] split;
                if (StringUtils.isEmpty((String)cookie) || !cookie.toLowerCase().startsWith("hadoop.auth".toLowerCase()) || !cookie.contains("u=")) continue;
                for (String s : split = cookie.split(";")) {
                    int andStr;
                    int ustr;
                    if (StringUtils.isEmpty((String)s) || !s.toLowerCase().startsWith("hadoop.auth".toLowerCase()) || (ustr = s.indexOf("u=")) == -1 || (andStr = s.indexOf("&", ustr)) == -1) continue;
                    try {
                        userName = s.substring(ustr + 2, andStr);
                        continue block2;
                    }
                    catch (Exception e) {
                        userName = null;
                    }
                }
            }
        }
        return userName;
    }

    private void createAtlasAuthCookie(HttpServletResponse resp, String token, String domain, String path, long expires, boolean isSecure) {
        StringBuilder sb = new StringBuilder("hadoop.auth").append("=");
        if (token != null && !token.isEmpty()) {
            sb.append("\"").append(token).append("\"");
        }
        sb.append("; Version=1");
        if (path != null) {
            sb.append("; Path=").append(path);
        }
        if (domain != null) {
            sb.append("; Domain=").append(domain);
        }
        if (expires >= 0L) {
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            sb.append("; Expires=").append(df.format(new Date(expires)));
        }
        if (isSecure) {
            sb.append("; Secure");
        }
        sb.append("; HttpOnly");
        resp.addHeader("Set-Cookie", sb.toString());
    }

    private Configuration getProxyuserConfiguration() {
        Configuration ret = new Configuration(false);
        if (this.configuration != null) {
            Properties props = ConfigurationConverter.getProperties((org.apache.commons.configuration.Configuration)this.configuration.subset(CONF_PROXYUSER_PREFIX));
            for (String key : props.stringPropertyNames()) {
                ret.set("atlas.proxyuser." + key, props.getProperty(key));
            }
        }
        return ret;
    }

    private class KerberosFilterChainWrapper
    implements FilterChain {
        private final ServletRequest request;
        private final ServletResponse response;
        private final FilterChain filterChain;

        KerberosFilterChainWrapper(ServletRequest request, ServletResponse response, FilterChain filterChain) {
            this.request = request;
            this.response = response;
            this.filterChain = filterChain;
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            String loggedInUser;
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
            Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
            String userName = loggedInUser = AtlasAuthenticationFilter.readUserFromCookie(httpResponse);
            if (!StringUtils.isEmpty((String)((String)httpRequest.getAttribute("proxyUser")))) {
                userName = (String)httpRequest.getAttribute("proxyUser");
            } else if (StringUtils.isEmpty((String)userName) && !StringUtils.isEmpty((String)httpRequest.getRemoteUser())) {
                userName = httpRequest.getRemoteUser();
            }
            if (!(existingAuth != null && existingAuth.isAuthenticated() || StringUtils.isEmpty((String)userName))) {
                List<GrantedAuthority> grantedAuths = AtlasAuthenticationProvider.getAuthoritiesFromUGI(userName);
                User principal = new User(userName, "", grantedAuths);
                UsernamePasswordAuthenticationToken finalAuthentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)"", grantedAuths);
                WebAuthenticationDetails webDetails = new WebAuthenticationDetails(httpRequest);
                finalAuthentication.setDetails((Object)webDetails);
                SecurityContextHolder.getContext().setAuthentication((Authentication)finalAuthentication);
                if (AtlasAuthenticationFilter.this.sessionTimeout != -1) {
                    httpRequest.getSession().setMaxInactiveInterval(AtlasAuthenticationFilter.this.sessionTimeout);
                }
                this.request.setAttribute("atlas.http.authentication.type", (Object)true);
                if (!StringUtils.equals((String)loggedInUser, (String)userName)) {
                    LOG.info("Logged into Atlas as = {}, by proxyUser = {}", (Object)userName, (Object)loggedInUser);
                } else {
                    LOG.info("Logged into Atlas as = {}", (Object)userName);
                }
            }
            if (httpRequest.getMethod().equals("OPTIONS")) {
                AtlasAuthenticationFilter.this.optionsServlet.service(this.request, this.response);
            } else {
                String requestUser = httpRequest.getRemoteUser();
                LOG.info("Request from authenticated user: {}, URL={}", (Object)requestUser, (Object)Servlets.getRequestURI(httpRequest));
                this.filterChain.doFilter(servletRequest, servletResponse);
            }
        }
    }
}

